/**
 * 系统配置项数据
 * @author w00131173
 * @since iManager U2000 V1R7,2012-6-4
 */
function SystemConfigDataMgr()
{
    /**
     * 系统配置数据
     */
    this._systemProps = null;
}

/**
 * 初始化全局数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-6-4
 */
SystemConfigDataMgr.prototype.init = function()
{
    if (null == this._systemProps)
    {
        // 向后台请求全局选项数据
        var operResult = jsonrpc.invoke("systemConfigurationInfoMgr", "getSystemConfigurations", []);
        if ((null != operResult) && (null != operResult.map))
        {
            this._systemProps = operResult.map;
        }
    }
}

/**
 * 获取指定属性值（key为配置文件中索引值）
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-6-4
 * @return 找不到返回null；找到返回对应值
 */
SystemConfigDataMgr.prototype.getProperty = function(key)
{
    //使用时初始化
    this.init();
    
    return this._systemProps[key];
}

////////////////////////////////////////////////////
/**
 * 点击E2E调用界面中的确定取消按钮时跳转的URL
 */
var E2EBUTTONURL =
{
    OKURL : "wrui://ok",
    CANCELURL : "wrui://close"
}


