/*
 * Title:         设备面板详细信息中属性组界面中的事件处理
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author         w00131173
 * @version        iManager U2000 V1R3,2010-7-2
 */
/**
 * 映射表
 */
var signalMap =
{
    on_load_ui :doLoad,
    doClose :doClose
};

/**
 * 初始化函数，当页面载入时调用load函数将页面定义文件加载进来
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/online/externalview/devicepanel/singletable/singletable.xui", signalMap);
}

/**
 * 加载页面初始设置
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 */
function doLoad()
{
    // 获得界面控件对象
    viewManager = window.xui.getWidget("ViewManager");
    viewManager.showView("normal");
    viewManager.activateView("normal");

    // 焦点默认设置在关闭按钮上
    var closeBtn = window.xui.getWidget("btnClose");
    closeBtn.focus();

}

/**
 * 获取当前选中面板的数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 */
function getMenuData()
{
    var parentWin = jse.getFromWin();
    if (null != parentWin)
    {
        var data = parentWin.pub_getMenuData();
        return data;
    }
}

/**
 * “关闭”按钮的事件处理：关闭对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 */
function doClose(evt)
{
    jse.closeSelfView();
}

/**
 * 共常规页面调用，获取当前选中面板的数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 */
function pub_getMenuInfo()
{
    return getMenuData();
}

Event.observe(window, "load", init);