/*
 * Title:         设备面板详细信息中属性组常规页面的处理
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author         w00131173
 * @version        iManager U2000 V1R3,2010-7-2
 */

jse.require("jse.widget.propertytable");

/**
 * 映射表.<br>
 */
var signalMap =
{
    on_load_ui :doLoad
};

/**
 * 初始化界面信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 */
function init()
{
    var propTable = new jse.widget.propertytable.PropertyTable("propPane", "PropertyTable", jse.GROUP
            | jse.DEFAULT_TOOLTIP);
    var g_proTableCtrl = initCtrlData(propTable);
    g_proTableCtrl.initColumnWidth(640, 430, 200);
    g_proTableCtrl.initViewData();
}

/**
 * 用户载入页面.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 * @return
 */
function doLoad()
{

}

/**
 * 初始化数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-7-1
 * @param proTable
 * @param menuData
 * @return
 */
function initCtrlData(proTable)
{
    var menuData = window.parent.pub_getMenuInfo();

    var deviceForm = new DeviceForm();
    deviceForm.deviceIp = menuData.getDeviceIP();
    deviceForm.deviceType = null;
    deviceForm.deviceVersion = null;
    deviceForm.lrRole = menuData.getLrRole();;
    deviceForm.type = menuData.getNeName();
    deviceForm.vrId = null;
    deviceForm.officeName = null;
    deviceForm.pnpForm= jse.topWin.pub_getClonePnpForm();
    deviceForm.viewType = "vmf";

    var featureForm = new FeatureForm();
    featureForm.featureName = menuData.getFeatureName();
    featureForm.xpath = menuData.getXpath();
    featureForm.domain = menuData.getDomain();

    var frameParam = new FrameParam();
    frameParam.viewType = OperViewType.QUERY_VIEW;

    var groupProTable = new PanelGroupProTable(proTable, null, menuData.getXpath());

    var proTableCtrl = new GroupProTableCtrl(groupProTable, deviceForm, featureForm, frameParam, menuData
            .getBoardPosition());

    var groupProTableModel = new GroupProTableModel(null);
    proTableCtrl.setProModel(groupProTableModel);
    
    //
    var checkerUseData = new GroupCheckerUseData(groupProTableModel);
    var checkerFactory = new GroupProTableCheckerFactory();
    
    var prosorUseData = new GroupProsorUserData(groupProTableModel);
    var prosorFactory = new GroupProTableProsorFactory();
    
    var linkageTransactionCtrl = new FeatureLinkageTransactionCtrl(checkerFactory, prosorFactory);
    var linkageCtrl = new GroupProTableLinkageController(checkerUseData, linkageTransactionCtrl, prosorFactory, 
    prosorUseData);

    proTableCtrl.setLinkageCtrl(linkageCtrl);
    return proTableCtrl;
}

Event.observe(window, "load", init);