/*
 * Title:         设备面板详细信息中属性组表的事件处理
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author         w00131173
 * @version        iManager U2000 V1R3,2010-7-2
 */

/**
 * 属性组表的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-7-1
 * @return
 */
function GroupProTableCtrl(proTable, deviceForm, featureForm, frameForm, position)
{
    /**
     * 分组属性表对象
     */
    this._proTable = proTable;
    
    /**
     * 分组属性数据模型
     */
    this._proModel = {};

    /**
     * 设备信息
     */
    this._deviceForm = deviceForm;

    /**
     * 特性信息
     */
    this._featureForm = featureForm;

    /**
     * 界面信息
     */
    this._frameForm = frameForm;

    /**
     * 要查询的面板表中板位置的值
     */
    this._position = position;
    
    /**
     * 初始化联动控制类
     */
    this._linkageCtrl = {};

}

/**
 * 联动控制对象
 */
GroupProTableCtrl.prototype.setLinkageCtrl = function(linkageCtrl)
{
    this._linkageCtrl = linkageCtrl;
}

/**
 * 设置数据模型
 */
GroupProTableCtrl.prototype.setProModel = function(proModel)
{
    this._proModel = proModel;
}

/**
 * 初始化列宽
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-7-1
 */
GroupProTableCtrl.prototype.initColumnWidth = function(hight, width, nameColumWidth)
{
    this._proTable.setPreferSize(hight, width, nameColumWidth);
}

/**
 * 向后台请求页面信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-7-1
 */
GroupProTableCtrl.prototype.initViewData = function()
{
    var operResult = jse.topWin.jsonrpc.invoke("NEPanelService", "queryPropertyGroup", [ this._deviceForm, this._featureForm,
            this._frameForm, this._position ]);
    if (null == operResult)
    {
        return;
    }

    if (operResult.resultType != GlobalConstants.OPER_OK)
    {
        CommonDlgReq.openRspErrorDialog(operResult, null, null);
        return;
    }
    else
    {
        var tableInfo = operResult.returnObj;
        
        this._proModel.initModelData(tableInfo.groupInfos);
        
        // 初始化联动控制信息
        if (null != tableInfo.featureLinkages && null != this._linkageCtrl)
        {
            this._linkageCtrl.init(tableInfo.featureLinkages, null, this._featureForm.xpath);
            
            //预先处理联动
            this._linkageCtrl.processDoLoadLinkage(this._proModel);
        }

        this.AddPropertyTableItem(this._proModel.getGroupNodes());
    }

}

/**
 * 向页面中添加数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-7-1
 */
GroupProTableCtrl.prototype.AddPropertyTableItem = function(groupNodes)
{
    this._proTable.addGroupItems(groupNodes);
}