/*
 * Title:         面板界面中分组属性表的处理对象，
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author         f00145226
 * @version        版本  2010-3-12
 */

/**
 * 面板界面中分组属性表的处理对象
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-7-1
 * @param proTable
 * @param resource
 * @return
 */
function PanelGroupProTable(propTable, resource, nodeXpath)
{
    GroupProTable.call(this, propTable, resource, nodeXpath);
}

PanelGroupProTable.prototype = new GroupProTable();

/**
 * 获取值的资源及时间本地化的处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-7-1
 * @param item 属性表条目信息
 * @param itemValue 原值
 * @return 资源化处理的显示值
 */
PanelGroupProTable.prototype.getDisplayValue = function(itemValue, item)
{
    if (itemValue != "" && itemValue != null && item.isChoice())
    {
        itemValue = FeaturesResourceMgr.getChoiceResource(item.getItemId(), itemValue, item.getChoiceXpath());
    }
    else if (DataTypeUtil.isBoolType(item.getBasicType()))
    {
        itemValue = DataTypeUtil.getBoolenResource(itemValue);
    }
    else if(DataTypeUtil.isTimeTickType(item.getBasicType()))
    {
    	itemValue = DataTypeUtil.getTimeTickResource(itemValue);
    }
    
    // 增加对tm特性的处理，如果是时钟管理，则不做时间本地化处理
    var itemXpath = item.getItemId();
    if(null != itemXpath && (-1 == jse.topWin.pub_getSystemConfigDataMgr().getProperty("notSupportLocaleTime").indexOf(itemXpath)))
    {
        // 时间本地化-gcu_lib.js
        itemValue = this.getDateTimeValue(itemValue);
    }

    return itemValue;
}