/*
 * Title:         分组属性表联动处理文件
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author        j65716
 * @version        版本  2010-8-7
 */

/**
 * 分组属性表联动控制类，用于封装不同事件处理的联动类
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-8-7
 */
function GroupProTableLinkageController()
{
    AbstractLinkageController.call(this);
}
GroupProTableLinkageController.prototype = new AbstractLinkageController();

/**
 * 联动触发事件注册接口
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-8-7
 * @param triggerEventType 事件类型
 * @override
 */
GroupProTableLinkageController.prototype.registTriggerEventTypes = function(triggerEventType)
{
    // 注册doload事件
    this._linkagesMap.put(LinkageTriggerEventType.DOLOAD, []);
}

/**
 * 处理点击功能树加载三段式的联动操作
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-5-28
 */
GroupProTableLinkageController.prototype.processDoLoadLinkage = function(groupProTableModel)
{
    // 获取所有
    var allRowIds = groupProTableModel.getAllAttributeIds();

    var itemValue = null;
    var valueLinkages = null;

    // 针对每一行做联动判断
    for ( var rowIndex in allRowIds)
    {

        // 获取对应的参数校验联动
        valueLinkages = this.getLinkages(allRowIds[rowIndex], this
                .getSpecialEventLinkages(LinkageTriggerEventType.DOLOAD));

        // 无联动处理，则继续
        if ((null == valueLinkages) || (0 == valueLinkages.length))
        {
            continue;
        }

        itemValue = groupProTableModel.getItemValue(allRowIds[rowIndex]);

        // 处理该行对应的事件
        this.processLinkage(valueLinkages, allRowIds[rowIndex], null, itemValue);
    }
}

/**
 * 分组属性表校验工厂.<br>
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-8-7
 */
function GroupProTableCheckerFactory(groupProTableModel)
{
    this._groupProTableModel = groupProTableModel;

    AbstractCheckerFactory.call(this);
}
GroupProTableCheckerFactory.prototype = new AbstractCheckerFactory();

/**
 * 抽象方法，创建指定类型的对象处理器类.<br>
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-8-7
 * @param type 对象类型
 * @override
 */
GroupProTableCheckerFactory.prototype.createObject = function(conditionType)
{
    var checker = null;
    if (conditionType == ConditionType.COMPAREVALUE)
    {
        checker = new GroupProTableValueCompareChecker(this._groupProTableModel);
    }

    return checker;
}

/**
 * 分组属性表处理器工厂.<br>
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-8-7
 */
function GroupProTableProsorFactory(groupProTableModel)
{
    this._groupProTableModel = groupProTableModel;

    AbstractProsorFactory.call(this);
}
GroupProTableProsorFactory.prototype = new AbstractProsorFactory();

/**
 * 抽象方法，创建指定类型的对象处理器类.<br>
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-8-7
 * @param type 对象类型
 * @override
 */
GroupProTableProsorFactory.prototype.createObject = function(operType)
{
    var checker = null;
    if (operType == OperType.TREETABLEVISIBLE)
    {
        checker = new GroupProTableVisibleProsor(this._groupProTableModel);
    }

    return checker;
}

/**
 * 特性第二段表格联动的值比较工具
 */
function GroupProTableValueComparator(resourceMgr, groupProTableModel)
{
    /**
     * 处理的特性表格对象，用于获取数据信息
     */
    this._groupProTableModel = groupProTableModel;

    AbstractValueComparator.call(this, resourceMgr);
}

GroupProTableValueComparator.prototype = new AbstractValueComparator();

/**
 * 设置表格对象.<br>
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-8-16
 */
GroupProTableValueComparator.prototype.setGroupProTableModel = function(groupProTableModel)
{
    this._groupProTableModel = groupProTableModel;
}

/**
 * 覆写获取引用对象值.<br>
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-7-5
 * @override
 */
GroupProTableValueComparator.prototype.getCompareRefValue = function(compareInfo)
{
    return this._groupProTableModel.getItemValue(compareInfo);

}
// /////////////////////////////////////////////////////////////////////////
/**
 * 验证表格是否满足条件
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-8-7
 * @param groupProTableModel 分组属性表数据模型
 */
function GroupProTableValueCompareChecker(groupProTableModel)
{
    AbstractChecker.call(this);
    this._groupProTableModel = groupProTableModel;
    this._valueComparator = new GroupProTableValueComparator(this._resourceMgr, groupProTableModel);
}
GroupProTableValueCompareChecker.prototype = new AbstractChecker();

/**
 * 验证表格是否满足条件
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-8-7
 * @param conditionParam 条件参数
 */
GroupProTableValueCompareChecker.prototype.checkCondition = function(conditionParam)
{
    // 设置比较器动态参数
    this._setValueComparatorPara(conditionParam);

    // 调用值比较接口
    return this._valueComparator.compareValues();
}

/**
 * 设置值比较器的动态参数
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-8-7
 * @param conditionParam 条件参数
 */
GroupProTableValueCompareChecker.prototype._setValueComparatorPara = function(conditionParam)
{
    var condition = conditionParam.condition;
    // 获取比较值
    var itemValue = this._groupProTableModel.getItemValue(condition.getXpath());

    // 设置动态参数
    this._valueComparator.setFirstXpath(condition.getXpath());
    this._valueComparator.setFirstValue(itemValue);
    this._valueComparator.setContentMap(condition.getContents());
}

/**
 * 分组属性表可见性处理器
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-8-7
 * @param groupProTableModel 分组属性表数据模型
 */
function GroupProTableVisibleProsor(groupProTableModel)
{
    AbstractProsor.call(this);
    this._groupProTableModel = groupProTableModel;
}
GroupProTableVisibleProsor.prototype = new AbstractProsor();

/**
 * 分组属性表可见性联动
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-8-7
 * @param operParam 操作参数
 */
GroupProTableVisibleProsor.prototype.doOperation = function(operParam)
{
    var oper = operParam.oper;
    var operMaps = oper.getOperContents();
    var visible = operMaps.get("visible");
    if (null != visible && "false" == visible)
    {
        this._groupProTableModel.setItemVisible(oper.getXpath());
    }
}
