/*
 * Title:         设备面板详细信息中列表界面中的事件处理
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author         w00131173
 * @version        iManager U2000 V1R3,2010-7-2
 */

/**
 * 设备面板表数据对象控制处理类
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-7-2
 * @return
 */
function PanelDataController(dataTable, tableModel, resource, featureForm, frameParam, nodeInfo, deviceForm)
{
    DataController.call(this, dataTable, tableModel, resource, featureForm, frameParam, nodeInfo, deviceForm, null,
            null, null);

    this._boardPosition = null;
}

PanelDataController.prototype = new DataController();

/**
 * 设置板的位置值
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 */
PanelDataController.prototype.setPosionValue = function(boardPosition)
{
    this._boardPosition = boardPosition;
}

/**
 * 刷新表格界面，通过定时触发IE刷新界面，以免在最后才刷新
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 * @return 无
 */
PanelDataController.prototype.updateTable = function(viewType)
{
    TimeOperation.doObjSetTimeout(this, this._doUpdateTable, [viewType], 0);
}

/**
 * 刷新第二段表格和分页信息
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 */
PanelDataController.prototype._doUpdateTable = function(viewType)
{
    // 清空焦点操作，防止操作界面点击取消时刷新三段式有焦点设置
    this.intitTableView(viewType);
    this._queryAllTableData(viewType);
}

/**
 * 刷新表格界面
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 * @return 无
 */
PanelDataController.prototype.intitTableView = function(viewType)
{
    // 初始化表格中各列的名称
    var operResult = jse.topWin.jsonrpc.invoke("NEPanelService", "genDataTableView", [ this._deviceForm, this._featureForm,
            this._frameParam ]);
    if (null == operResult)
    {
        return;
    }
    if (operResult.resultType != GlobalConstants.OPER_OK)
    {
        CommonDlgReq.openRspErrorDialog(operResult, null, null);
        return;
    }
    else
    {
        var tableInfo = operResult.returnObj;
        this._dataTable.initNormalColumns(tableInfo.columnList);
        this._initNodeInfo(tableInfo);
    }
}

/**
 * 按照过滤条件下发查询命令接口（不同页面覆写该命令）
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 * @param viewType 页面类型
 * @return
 */
PanelDataController.prototype.sendQueryCmdbyCondition = function(filterCondition)
{
    var operResult = jse.topWin.jsonrpc.invoke("NEPanelService", "queryData", [ this._deviceForm, this._featureForm,
            this._frameParam, this._dataTable.getJonsColumnInfos(), this._boardPosition ]);
    this.doGetTableRow(operResult);
    
}

/**
 * 刷新表格界面
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 * @return 无
 */
PanelDataController.prototype._queryAllTableData = function()
{
    this.sendQueryCmdbyCondition(null);
}

/**
 * 更新表格数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 */
PanelDataController.prototype.updateTableAndStatus = function(dataModel)
{
    var jsonColumnInfos = this._dataTable.getJonsColumnInfos();
    var jsonRowDatas = dataModel.rowDatas.list;

    this._tableModel.initJsonTableModel(jsonColumnInfos, jsonRowDatas, jsonColumnInfos,dataModel);

    // 更新表格内容
    this._dataTable.updateTableAfterSetModel();

}

/**
 * 覆写父类方法
 */
PanelDataController.prototype._initProgressCtrl = function()
{
    
}