jse.require("vmt.extend.table_prototype");
/*
 * Title:         设备面板详细信息中列表界面的处理
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author         w00131173
 * @version        版本  2010-6-23
 */

var signalMap =
{
    on_load_ui :doLoad,
    doClose :doClose
};

/**
 * 初始化界面信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 */
function init()
{
    // 通过JSON获取控件的Handler
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/online/externalview/devicepanel/multitable/multitable.xui", signalMap);

}

/**
 * 初始化加载界面中的数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 */
function doLoad()
{
    var table = window.xui.getWidget("Table");
    table.onsort = doSortHandler;

    var g_menuData = getMenuData();

    var featureData = initFeatureData(g_menuData);
    var deviceForm = featureData.getDeviceForm();
    var featureForm = featureData.getFeatureForm();
    var frameParam = featureData.getFrameParam();

    var resource = new FeaturesResourceMgr();
    resource.addFeatureNameWithVersionInfo(featureForm.featureName, featureForm.featureNameWithVersion);
    
    var tableModel = new TableModel(resource, table);
    var datatable = new DataTable(table, tableModel, resource);
    var nodeInfo = new NodeInfo();

    var dataController = new PanelDataController(datatable, tableModel, resource, featureForm, frameParam, nodeInfo,
            deviceForm);

    dataController.setPosionValue(g_menuData.getBoardPosition());
    
    dataController.updateTable("FEATURE");

    // 初始化将焦点设置到关闭按钮上
    var closeBtn = window.xui.getWidget("btnClose");
    closeBtn.focus();
}


/**
 * 排序
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 */
function doSortHandler(evt)
{
    var table = window.xui.getWidget("Table");
    var colIds = table.getAllColumnIds();
    for (var i=0;i<colIds.length;i++)
    {
        if(evt.id != colIds[i])
        {
            table._updateSortSignOfOneColumn(colIds[i], "ASC");
        }
    }
    table.sortTableByColumn(evt.id, evt.order, jse.STRING);
}

/**
 * 获取当前选中面板的数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 */
function getMenuData()
{
    var parentWin = jse.getFromWin();
    if (null != parentWin)
    {
        var data = parentWin.pub_getMenuData();
        return data;
    }
}

/**
 * 初始化设置全局对象
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 * @return
 */
function initFeatureData(menuData)
{
    var deviceForm = new DeviceForm();
    deviceForm.deviceIp = menuData.getDeviceIP();
    deviceForm.deviceType = jse.topWin.deviceType;
    deviceForm.deviceVersion = jse.topWin.deviceVersion;
    deviceForm.type = menuData.getNeName();
    deviceForm.vrId = null;
    deviceForm.officeName = null;
    deviceForm.pnpForm= jse.topWin.pub_getClonePnpForm();
    deviceForm.viewType = "vmf";

    var featureForm = new FeatureForm();
    featureForm.featureName = menuData.getFeatureName();
    featureForm.xpath = menuData.getXpath();

    var frameParam = new FrameParam();
    frameParam.viewType = OperViewType.QUERY_VIEW;

    var globalData = new GlobalData();
    globalData.setDeviceForm(deviceForm);
    globalData.setFeatureForm(featureForm);
    globalData.setFrameParam(frameParam);

    return globalData;
}

/**
 * “关闭”按钮的事件处理：关闭对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-30
 */
function doClose(evt)
{
    jse.closeSelfView();
}

Event.observe(window, "load", init);