/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.online.service.web;

import com.huawei.vmf.qat.autogui.guiservice.DataTblColumn;
import com.huawei.vmf.qat.autogui.guiservice.DataTblGuiService;
import com.huawei.vmf.qat.autogui.service.ColumnProvider;
import com.huawei.vmf.qat.common.GlobalConstants;
import com.huawei.vmf.qat.common.MessageUtil;
import com.huawei.vmf.qat.common.domain.GUIType;
import com.huawei.vmf.qat.common.infomgr.CustomTabMgr;
import com.huawei.vmf.qat.common.json.JSONRPCContextHolder;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.common.rsp.OperResult;
import com.huawei.vmf.qat.common.rsp.OperResultType;
import com.huawei.vmf.qat.common.rsp.QatOperException;
import com.huawei.vmf.qat.common.timezone.DateTimeType;
import com.huawei.vmf.qat.common.timezone.TimeZoneUtil;
import com.huawei.vmf.qat.online.business.config.ExportFeatureDataService;
import com.huawei.vmf.qat.schemaprocessor.infomodel.AttributeType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.ComplexType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.DomainLayerType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.MOType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.PropertyType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.SchemaId;
import com.huawei.vmf.qat.service.cache.dao.SortInfo;
import com.huawei.vmf.qat.service.cache.dao.SortType;
import com.huawei.vmf.qat.service.config.ColumnCustomizer;
import com.huawei.vmf.qat.service.domain.DeviceForm;
import com.huawei.vmf.qat.service.domain.FeatureForm;
import com.huawei.vmf.qat.service.domain.FrameForm;
import com.huawei.vmf.qat.service.domain.HistoryConditions;
import com.huawei.vmf.qat.service.domain.cache.DataPage;
import com.huawei.vmf.qat.service.domain.cache.MOData;
import com.huawei.vmf.qat.service.domain.cache.MultiMOData;
import com.huawei.vmf.qat.service.domain.cache.TableId;
import com.huawei.vmf.qat.service.infomgr.domain.DevInstanceLayerInfo;
import com.huawei.vmf.qat.service.support.PubtypeCustomTypeFactory;
import com.huawei.vmf.qat.service.support.QueryService;
import com.huawei.vmf.qat.service.util.ConfigFrameUtil;
import com.huawei.vmf.qat.xmlprocessor.infomodel.LightMO;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.util.Assert;

public class SaveAsAction
implements ExportFeatureDataService {
    private static final Logger logger = RunLogger.getRunLogger();
    private ColumnCustomizer columnCustomizer;
    private CustomTabMgr customTabMgr;
    private DataTblGuiService guiService;
    private PubtypeCustomTypeFactory pubtypeCustomTypeFactory;
    private QueryService queryService;
    private static final char separator = ',';
    private static final char quotechar = '\"';
    private static final char escapechar = '\"';
    private static final String lineEnd = "\r\n";

    @Override
    public OperResult<String, String> saveAs(DeviceForm deviceForm, FeatureForm featureForm, FrameForm frameForm, SortInfo sortInfo, ZoneInfo zoneInfo, HistoryConditions historyConditions, String lang) throws IOException {
        featureForm.setGuiType(GUIType.QUERY);
        String featureName = featureForm.getFeatureName();
        String xpath = featureForm.getXpath();
        DeviceForm domainDeviceForm = ConfigFrameUtil.getDeviceFormByDomain((DeviceForm)deviceForm, (DomainLayerType)featureForm.getDomain());
        String deviceName = domainDeviceForm.getDeviceName();
        deviceName = this.encodeOutput(deviceName);
        OperResult operResult = new OperResult();
        File dir = new File(GlobalConstants.TMP_DATA_DIR);
        if (!dir.exists() && !dir.mkdir()) {
            operResult.setResultType(OperResultType.OPER_NOK);
            return operResult;
        }
        String name = xpath.substring(xpath.lastIndexOf("/") + 1, xpath.length());
        name = featureName.equals(name) ? "global" : name;
        String fileName = deviceName + "_" + featureName + "_" + name + "_" + TimeZoneUtil.getNoFormatUTCString();
        try {
            this.saveToCSVFile((OperResult<String, String>)operResult, fileName, historyConditions, sortInfo, deviceForm, featureForm, frameForm, zoneInfo, lang);
        }
        catch (Exception e) {
            operResult.setResultType(OperResultType.OPER_NOK);
            return operResult;
        }
        operResult.setResultType(OperResultType.OPER_OK);
        operResult.setReturnObj((Object)(fileName + ".csv"));
        logger.info("end SaveAsAction.writeHSSFCell");
        return operResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToCSVFile(OperResult<String, String> operResult, String fileName, HistoryConditions historyConditions, SortInfo sortInfo, DeviceForm deviceForm, FeatureForm featureForm, FrameForm frameForm, ZoneInfo zoneInfo, String lang) {
        logger.info("start SaveAsAction.writeHSSFCell");
        DeviceForm domainDeviceForm = ConfigFrameUtil.getDeviceFormByDomain((DeviceForm)deviceForm, (DomainLayerType)featureForm.getDomain());
        String deviceIp = domainDeviceForm.getDeviceIp();
        String deviceName = domainDeviceForm.getDeviceName();
        deviceName = this.encodeOutput(deviceName);
        SchemaId schemaId = ConfigFrameUtil.genSchemaId((DeviceForm)domainDeviceForm, (FeatureForm)featureForm);
        String csvFileName = fileName + ".csv";
        String filePath = GlobalConstants.TMP_DATA_DIR + File.separator + csvFileName;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(filePath);
        }
        catch (FileNotFoundException e) {
            logger.error("Catch FileNotFoundException!", (Throwable)e);
            operResult.setResultType(OperResultType.OPER_NOK);
            return;
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "GBK"));
            ArrayList<String> nextLine = new ArrayList<String>();
            StringBuffer buf = new StringBuffer();
            String tabResFileName = this.getSchemaTabResFileName(schemaId);
            String treeResFileName = this.getSchemaTreeResFileName(schemaId);
            if (featureForm.getTabId().indexOf("/") > -1) {
                buf.append(this.getConventedString((String)MessageUtil.getI18NTreeInfoMsgCollection((String)(treeResFileName + ".xml"), (String)lang).get("functree." + featureForm.getFuncnodeName() + "_d")));
                buf.append(" - ");
                buf.append(this.getConventedString(MessageUtil.getI18NTabtitleMsg((String)(tabResFileName + ".xml"), (String)featureForm.getTabId(), (String)lang)));
            } else {
                buf.append(this.getConventedString((String)MessageUtil.getI18NTreeInfoMsgCollection((String)(treeResFileName + ".xml"), (String)lang).get("functree." + featureForm.getFeatureName() + "_d")));
                buf.append(" - ");
                buf.append(this.getConventedString((String)MessageUtil.getI18NTreeInfoMsgCollection((String)(treeResFileName + ".xml"), (String)lang).get(this.getFuncnodeNameKey(featureForm, schemaId.getDeviceVersion()))));
            }
            nextLine.add(buf.toString());
            bufferedWriter.write(this.writeNext(nextLine) + lineEnd);
            nextLine.clear();
            nextLine.add(this.getNeName(deviceName, deviceIp));
            bufferedWriter.write(this.writeNext(nextLine) + lineEnd);
            nextLine.clear();
            nextLine.add(this.getSaveTime(zoneInfo));
            bufferedWriter.write(this.writeNext(nextLine) + lineEnd);
            List<MOData> moDataList = this.getMoDataList(sortInfo, deviceForm, featureForm, frameForm);
            if (null != moDataList && !moDataList.isEmpty()) {
                LightMO mo = moDataList.get(0).getMO();
                MOType primaryMotype = mo.getMOType();
                nextLine.clear();
                nextLine.add(MessageUtil.getI18NMsg((String)"file.saveas_condition"));
                bufferedWriter.write(this.writeNext(nextLine));
                nextLine.clear();
                nextLine.add(this.getSaveAsCondition(primaryMotype, historyConditions, lang));
                bufferedWriter.write(this.writeNext(nextLine) + lineEnd);
                nextLine.clear();
                nextLine.add(this.getRecordNums(moDataList.size()));
                bufferedWriter.write(this.writeNext(nextLine) + lineEnd);
                List<List<String>> cellsVals = this.getCellsVals(deviceForm, featureForm, frameForm, schemaId, moDataList, primaryMotype, zoneInfo, lang);
                if (null != cellsVals && !cellsVals.isEmpty()) {
                    for (List<String> rowCellsVals : cellsVals) {
                        bufferedWriter.write(this.writeNext(rowCellsVals));
                    }
                }
            }
            bufferedWriter.flush();
        }
        catch (IOException e) {
            logger.error("Catch IOException ", (Throwable)e);
            operResult.setResultType(OperResultType.OPER_NOK);
            return;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException e) {
                    logger.error("Catch IOException!", (Throwable)e);
                    operResult.setResultType(OperResultType.OPER_NOK);
                }
            }
        }
    }

    private String getConventedString(String str) {
        if (null == str) {
            return "";
        }
        return str;
    }

    private String getFuncnodeNameKey(FeatureForm featureForm, String deviceVersion) {
        String funcnodeNameKey = "";
        String funName = featureForm.getFuncnodeName();
        if (funName.indexOf("]") > -1) {
            String[] funcStr = funName.split("]");
            funcnodeNameKey = "functree." + funcStr[funcStr.length - 1] + "_d";
        } else {
            funcnodeNameKey = "functree." + funName + "_d";
        }
        return funcnodeNameKey;
    }

    private String writeNext(List<String> nextLine) {
        if (nextLine == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < nextLine.size(); ++i) {
            String nextElement;
            if (i != 0) {
                sb.append(',');
            }
            if ((nextElement = nextLine.get(i)) == null) continue;
            sb.append('\"');
            sb.append(this.stringContainsSpecialCharacters(nextElement) ? this.processLine(nextElement) : nextElement);
            sb.append('\"');
        }
        sb.append(lineEnd);
        return sb.toString();
    }

    private boolean stringContainsSpecialCharacters(String line) {
        return line.indexOf(34) != -1 || line.indexOf(34) != -1;
    }

    private StringBuilder processLine(String nextElement) {
        StringBuilder sb = new StringBuilder(128);
        for (int j = 0; j < nextElement.length(); ++j) {
            char nextChar = nextElement.charAt(j);
            if (nextChar == '\"') {
                sb.append('\"').append(nextChar);
                continue;
            }
            if (nextChar == '\"') {
                sb.append('\"').append(nextChar);
                continue;
            }
            sb.append(nextChar);
        }
        return sb;
    }

    private String getSchemaTabResFileName(SchemaId schemaId) {
        return schemaId.getDeviceType() + "_" + schemaId.getDeviceVersion() + "_" + "tabtitle";
    }

    private String getSchemaTreeResFileName(SchemaId schemaId) {
        return schemaId.getDeviceType() + "_" + schemaId.getDeviceVersion() + "_" + "treeinfo";
    }

    public void setColumnCustomizer(ColumnCustomizer columnCustomizer) {
        this.columnCustomizer = columnCustomizer;
    }

    public void setCustomTabMgr(CustomTabMgr customTabMgr) {
        this.customTabMgr = customTabMgr;
    }

    public void setGuiService(DataTblGuiService guiService) {
        this.guiService = guiService;
    }

    public void setPubtypeCustomTypeFactory(PubtypeCustomTypeFactory pubtypeCustomTypeFactory) {
        this.pubtypeCustomTypeFactory = pubtypeCustomTypeFactory;
    }

    public void setQueryService(QueryService queryService) {
        this.queryService = queryService;
    }

    private List<String> evaluateFileColumn(Map<String, LightMO> moMap, Map<String, LightMO> mulMoMap, List<String> subXpaths, List<String> columnXpathList, String tzOffset, String zonePattern, String tzId, String lang) {
        ArrayList<String> columnEvalList = new ArrayList<String>();
        columnEvalList.addAll(columnXpathList);
        this.getFileXML(moMap, mulMoMap, subXpaths, columnEvalList, columnXpathList, tzOffset, zonePattern, tzId, lang);
        return columnEvalList;
    }

    private String getAlarmResInfo(LightMO mo, String value) {
        SchemaId schemaId = mo.getMOType().getSchema().getSchemaId();
        String schemaName = schemaId.getName();
        if (!schemaName.equals("fm")) {
            return null;
        }
        String alarmResFileName = ConfigFrameUtil.getAlarmResFileName((SchemaId)schemaId);
        String alarmResInfo = MessageUtil.getI18NAlarmMsg((String)(alarmResFileName + ".xml"), (String)value);
        if (alarmResInfo == null || alarmResInfo.equals("")) {
            return null;
        }
        return alarmResInfo;
    }

    private String getAtrrValue(LightMO mo, AttributeType attr, String tzOffset, String zonePattern, String tzId, String columnXpath) {
        String value = "";
        if (null != attr) {
            value = attr.isCustomDispType() ? mo.getAttributeDisplayValue(columnXpath) : (attr.isPassword() ? "" : mo.getAttributeValue(columnXpath));
        }
        return value;
    }

    private String getAttributeValueByZoneInfo(LightMO mo, String tzOffset, String zonePattern, String tzId, String columnXpath) {
        String value = "";
        AttributeType attr = mo.getMOType().getAttrType(columnXpath);
        PropertyType propType = mo.getMOType().getPropType(columnXpath);
        if (null != attr) {
            value = this.getAtrrValue(mo, attr, tzOffset, zonePattern, tzId, columnXpath);
        }
        if (null != propType) {
            value = this.getPropValue(mo, propType, tzOffset, zonePattern, tzId, columnXpath);
        }
        return value;
    }

    private List<List<String>> getFileEvaXML(List<MOData> moDataList, List<MultiMOData> multiMODatas, DeviceForm deviceForm, FeatureForm featureForm, FrameForm frameForm, List<DataTblColumn> columnList, List<String> columnXpaths, ZoneInfo zoneInfo, String lang) {
        ArrayList<List<String>> rspXML = new ArrayList<List<String>>();
        if (null == multiMODatas || multiMODatas.isEmpty()) {
            return rspXML;
        }
        rspXML.add(this.getTblHead(deviceForm, columnXpaths, lang));
        Map<String, LightMO> moMap = this.getPrimaryMOMap(deviceForm, featureForm, frameForm, moDataList);
        List<String> subXpaths = this.getSubXpaths(moDataList, columnXpaths);
        List<Object> columnEval = new ArrayList();
        for (MultiMOData multiMOData : multiMODatas) {
            Map mulMoMap = multiMOData.getMoInfos();
            this.refreshMos(deviceForm, featureForm, frameForm, mulMoMap);
            columnEval = this.evaluateFileColumn(moMap, mulMoMap, subXpaths, columnXpaths, zoneInfo.tzOffset, zoneInfo.zonePattern, zoneInfo.tzId, lang);
            rspXML.add(columnEval);
        }
        return rspXML;
    }

    private void getFileXML(Map<String, LightMO> moMap, Map<String, LightMO> mulMoMap, List<String> subXpaths, List<String> parentXML, List<String> columnXpathList, String tzOffset, String zonePattern, String tzId, String lang) {
        String value = "";
        String isChoice = "";
        String columnXpath = "";
        int size = columnXpathList.size();
        LightMO primaryMo = null;
        LightMO mo = null;
        for (Map.Entry<String, LightMO> entry : mulMoMap.entrySet()) {
            LightMO moValue = entry.getValue();
            if (null == moValue || !moMap.containsKey(entry.getKey())) continue;
            primaryMo = moValue;
        }
        for (int i = 0; i < size; ++i) {
            columnXpath = columnXpathList.get(i);
            LightMO subMO = this.getSubMO(mulMoMap, columnXpath, subXpaths);
            PropertyType propType = primaryMo.getMOType().getPropType(columnXpath);
            mo = subXpaths.contains(columnXpath) && null != subMO && null == propType ? subMO : primaryMo;
            value = this.getAttributeValueByZoneInfo(mo, tzOffset, zonePattern, tzId, columnXpath);
            if ((null == value || "null".equals(value)) && this.hasAttrXpath(mo, columnXpath)) {
                value = "";
            }
            if (null == value) continue;
            String alarmResInfo = this.getAlarmResInfo(mo, value);
            if (alarmResInfo != null) {
                parentXML.set(i, alarmResInfo);
                continue;
            }
            isChoice = this.isChoice(mo, columnXpath);
            if (!isChoice.equals("false")) {
                String resFileName = ConfigFrameUtil.getSchemaResFileName((SchemaId)mo.getMOType().getSchema().getSchemaId());
                parentXML.set(i, MessageUtil.getI18NSchemaMsg((String)(resFileName + ".xml"), (String)("/" + isChoice + "/" + value + "_d"), (String)lang));
                continue;
            }
            if (this.isBoolean(mo, columnXpath)) {
                parentXML.set(i, MessageUtil.getI18NMsg((String)("isBoolean_" + value + "_d"), (String)lang));
                continue;
            }
            parentXML.set(i, value);
        }
    }

    private List<String> getNormalXpathList(MOType moType, DeviceForm deviceForm, FeatureForm featureForm) {
        ColumnProvider columnProvider = this.customTabMgr.hasCustomTabInfo(deviceForm.getDeviceType(), deviceForm.getDeviceVersion()) ? this.columnCustomizer.getTabColumnProvider(deviceForm, featureForm, false, false) : this.columnCustomizer.getColumnProvider(moType.getSchema().getSchemaId(), false);
        List columnList = this.guiService.genDataTblColums((ComplexType)moType, columnProvider, featureForm, deviceForm);
        ArrayList<String> normalXpathList = new ArrayList<String>();
        if (null != columnList) {
            for (int i = 0; i < columnList.size(); ++i) {
                DataTblColumn columnInfo = (DataTblColumn)columnList.get(i);
                normalXpathList.add(columnInfo.getXpath());
            }
        }
        return normalXpathList;
    }

    private Map<String, LightMO> getPrimaryMOMap(DeviceForm deviceForm, FeatureForm featureForm, FrameForm frameForm, List<MOData> moDataList) {
        HashMap<String, LightMO> moMap = new HashMap<String, LightMO>();
        ArrayList<LightMO> moLst = new ArrayList<LightMO>();
        for (int i = 0; i < moDataList.size(); ++i) {
            MOData moData = moDataList.get(i);
            if (null == moData) continue;
            LightMO mo = moData.getMO();
            moLst.add(mo);
            moMap.put(mo.getMOType().getXPath(), mo);
        }
        this.pubtypeCustomTypeFactory.customMOs(deviceForm, featureForm, frameForm, moLst);
        return moMap;
    }

    private String getPropValue(LightMO mo, PropertyType propType, String tzOffset, String zonePattern, String tzId, String columnXpath) {
        String value = "";
        String xpath = columnXpath.substring(0, columnXpath.lastIndexOf("/"));
        String propName = columnXpath.substring(columnXpath.lastIndexOf("/") + 1);
        value = mo.getAttributeProperty(xpath, propName);
        if (null != propType && propType.isPassword()) {
            value = "";
        }
        return value;
    }

    private AttributeType getRightAttribute(MOType motype, String xpath) {
        AttributeType attrType = null;
        List children = motype.getDirectChildrenMOType();
        if (children.size() <= 0) {
            return null;
        }
        MOType target = null;
        for (MOType child : children) {
            if (-1 == xpath.indexOf(child.getXPath())) continue;
            target = child;
        }
        if (null != target && null == (attrType = target.getAttrType(xpath))) {
            attrType = this.getRightAttribute(target, xpath);
        }
        return attrType;
    }

    private List<String> getTblHead(DeviceForm deviceForm, List<String> columnXpaths, String lang) {
        ArrayList<String> resFileNames = new ArrayList<String>();
        ArrayList<String> resValues = new ArrayList<String>();
        for (String columnXpath : columnXpaths) {
            resFileNames.add(this.getSchemaResFileName(deviceForm, columnXpath) + ".xml");
        }
        for (int i = 0; i < columnXpaths.size(); ++i) {
            resValues.add(MessageUtil.getI18NSchemaMsg((String)((String)resFileNames.get(i)), (String)(columnXpaths.get(i) + "_d"), (String)lang));
        }
        return resValues;
    }

    private String getSchemaResFileName(DeviceForm deviceForm, String columnXpath) {
        String featureName = columnXpath.substring(columnXpath.indexOf("/") + 1, columnXpath.indexOf("/", columnXpath.indexOf("/") + 1));
        String resFileName = deviceForm.getDeviceType() + "_" + deviceForm.getDeviceVersion() + "_" + featureName;
        return resFileName;
    }

    private LightMO getSubMO(Map<String, LightMO> mulMoMap, String columnXpath, List<String> subXpaths) {
        for (Map.Entry<String, LightMO> entry : mulMoMap.entrySet()) {
            LightMO subMO = entry.getValue();
            if (null == subMO) continue;
            for (String xpath : subXpaths) {
                if (null == subMO.getAttributeValue(xpath) || !columnXpath.equals(xpath)) continue;
                return subMO;
            }
        }
        return null;
    }

    private List<String> getSubXpaths(List<MOData> moDataList, List<String> columnXpaths) {
        ArrayList<String> subXpaths = new ArrayList<String>();
        LightMO mo = moDataList.get(0).getMO();
        for (String columnXpath : columnXpaths) {
            if (this.hasAttrXpath(mo, columnXpath)) continue;
            subXpaths.add(columnXpath);
        }
        return subXpaths;
    }

    private boolean hasAttrXpath(LightMO mo, String xpath) {
        MOType motype = mo.getMOType();
        List attrList = motype.getAllAttributeTypeList();
        if (null != attrList) {
            for (int i = 0; i < attrList.size(); ++i) {
                if (!((AttributeType)attrList.get(i)).getXPath().equals(xpath)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBoolean(LightMO mo, String xpath) {
        MOType motype = mo.getMOType();
        AttributeType attribute = motype.getAttrType(xpath);
        if (null == attribute) {
            return false;
        }
        boolean isBoolean = attribute.isBoolean();
        return isBoolean;
    }

    private String isChoice(LightMO mo, String xpath) {
        MOType motype = mo.getMOType();
        AttributeType attribute = motype.getAttrType(xpath);
        for (MOType parent = motype.getParent(); null == attribute && null != parent; parent = parent.getParent()) {
            attribute = parent.getAttrType(xpath);
        }
        if (null == attribute) {
            attribute = this.getRightAttribute(motype, xpath);
        }
        if (null != attribute && attribute.isChoice()) {
            String typeName = attribute.getTypeName();
            return typeName;
        }
        return "false";
    }

    private void refreshMos(DeviceForm deviceForm, FeatureForm featureForm, FrameForm frameForm, Map<String, LightMO> mulMoMap) {
        ArrayList<LightMO> moLst = new ArrayList<LightMO>();
        for (Map.Entry<String, LightMO> entry : mulMoMap.entrySet()) {
            LightMO mo = entry.getValue();
            if (null == mo) continue;
            moLst.add(mo);
        }
        this.pubtypeCustomTypeFactory.customMOs(deviceForm, featureForm, frameForm, moLst);
    }

    private String encodeOutput(String str) {
        if (null == str) {
            return str;
        }
        str = str.replaceAll("&#40;", "\\(");
        str = str.replaceAll("&#41;", "\\)");
        return str;
    }

    private String getNeName(String deviceName, String deviceIp) {
        StringBuffer buf = new StringBuffer();
        buf.append(MessageUtil.getI18NMsg((String)"file.saveas_devicename"));
        buf.append(deviceName);
        buf.append("-");
        buf.append(deviceIp);
        return buf.toString();
    }

    private String getSaveTime(ZoneInfo zoneInfo) {
        StringBuffer buf = new StringBuffer();
        buf.append(MessageUtil.getI18NMsg((String)"file.saveas_savetime"));
        buf.append(TimeZoneUtil.getLocalTime((String)TimeZoneUtil.getUTCString(), (String)zoneInfo.tzOffset, (String)zoneInfo.tzId, (String)zoneInfo.zonePattern, (DateTimeType)DateTimeType.DATETIME));
        return buf.toString();
    }

    private List<MOData> getMoDataList(SortInfo sortInfo, DeviceForm deviceForm, FeatureForm featureForm, FrameForm frameForm) {
        DeviceForm domainDeviceForm = ConfigFrameUtil.getDeviceFormByDomain((DeviceForm)deviceForm, (DomainLayerType)featureForm.getDomain());
        boolean isWorkspace = frameForm.isWorkspace();
        boolean sorted = sortInfo.isSorted();
        String attrPath = sortInfo.getAttrPath();
        SortType sortType = sortInfo.getSortType();
        TableId tableId = new TableId(JSONRPCContextHolder.getHttpSessionId(), domainDeviceForm.getOfficeName(), domainDeviceForm.getDeviceIp(), domainDeviceForm.getVrId(), featureForm.getFeatureName(), isWorkspace, String.valueOf(domainDeviceForm.getType()), featureForm.getXpath(), null, null, featureForm.getKeyrefXpath(), featureForm.getTabId());
        tableId.setInstanceLayer(new DevInstanceLayerInfo(domainDeviceForm, featureForm));
        DataPage dataPage = null;
        try {
            dataPage = sorted ? this.queryService.getPageAllRecords(tableId, attrPath, sortType) : this.queryService.getPageAllRecords(tableId, null, null);
        }
        catch (QatOperException e) {
            logger.error("get dataPage failed!", (Throwable)e);
        }
        Assert.notNull((Object)dataPage, (String)"dataPage must not be null.");
        return dataPage.getMoList();
    }

    private String getSaveAsCondition(MOType motype, HistoryConditions historyConditions, String lang) {
        StringBuffer buf = new StringBuffer();
        String resFileName = ConfigFrameUtil.getSchemaResFileName((SchemaId)motype.getSchema().getSchemaId()) + ".xml";
        String value = "";
        if (null == historyConditions) {
            value = MessageUtil.getI18NMsg((String)"combo.allrecord_d");
            buf.append(value);
        } else {
            buf.setLength(0);
            Map conditonMap = (Map)historyConditions.getConditions().get(0);
            for (Map.Entry iter : conditonMap.entrySet()) {
                String key = (String)iter.getKey();
                AttributeType attr = motype.getAttrType(key);
                value = (String)iter.getValue();
                buf.append(MessageUtil.getI18NSchemaMsg((String)resFileName, (String)(key + "_d"), (String)lang));
                buf.append(" = ");
                if (attr.isChoice()) {
                    buf.append(MessageUtil.getI18NSchemaMsg((String)resFileName, (String)("/" + attr.getTypeName() + "/" + value + "_d"), (String)lang));
                    continue;
                }
                buf.append(value);
            }
        }
        return buf.toString();
    }

    private String getRecordNums(int size) {
        StringBuffer buf = new StringBuffer();
        buf.append(MessageUtil.getI18NMsg((String)"file.saveas_recordnumber"));
        buf.append(size);
        buf.append(MessageUtil.getI18NMsg((String)"file.saveas_recordunit"));
        return buf.toString();
    }

    private List<List<String>> getCellsVals(DeviceForm deviceForm, FeatureForm featureForm, FrameForm frameForm, SchemaId schemaId, List<MOData> moDataList, MOType primaryMotype, ZoneInfo zoneInfo, String lang) {
        ColumnProvider columnProvider = this.customTabMgr.hasCustomTabInfo(deviceForm.getDeviceType(), deviceForm.getDeviceVersion()) ? this.columnCustomizer.getTabColumnProvider(deviceForm, featureForm, false, false) : this.columnCustomizer.getColumnProvider(schemaId, false);
        List columnList = this.guiService.genDataTblColums((ComplexType)primaryMotype, columnProvider, featureForm, deviceForm);
        List multiMODatas = this.queryService.queryRelatedFeatureDatas(deviceForm, featureForm, frameForm, columnList, moDataList);
        List<String> columnXpaths = this.getNormalXpathList(primaryMotype, deviceForm, featureForm);
        return this.getFileEvaXML(moDataList, multiMODatas, deviceForm, featureForm, frameForm, columnList, columnXpaths, zoneInfo, lang);
    }

    public static class ZoneInfo {
        String tzId;
        String tzOffset;
        String zonePattern;

        public void setTzId(String tzId) {
            this.tzId = tzId;
        }

        public void setTzOffset(String tzOffset) {
            this.tzOffset = tzOffset;
        }

        public void setZonePattern(String zonePattern) {
            this.zonePattern = zonePattern;
        }
    }
}

