/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.online.renovator.impl;

import com.huawei.vmf.qat.common.CommonUtil;
import com.huawei.vmf.qat.common.GlobalConstants;
import com.huawei.vmf.qat.common.file.FileProcessor;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.common.rsp.OperResult;
import com.huawei.vmf.qat.common.rsp.OperResultType;
import com.huawei.vmf.qat.common.rsp.QatOperException;
import com.huawei.vmf.qat.online.renovator.RenovatorService;
import com.huawei.vmf.qat.online.util.OnlineConstants;
import com.huawei.vmf.qat.schemaprocessor.infomodel.MOType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.Schema;
import com.huawei.vmf.qat.schemaprocessor.infomodel.SchemaBuilder;
import com.huawei.vmf.qat.schemaprocessor.infomodel.Type;
import com.huawei.vmf.qat.service.domain.DeviceForm;
import com.huawei.vmf.qat.service.domain.FeatureForm;
import com.huawei.vmf.qat.service.util.ConfigFrameUtil;
import com.huawei.vmf.qat.xmlprocessor.infomodel.LightMO;
import com.huawei.vmf.qat.xmlprocessor.infomodel.LightMOTree;
import com.huawei.vmf.qat.xmlprocessor.infomodel.MOXMLBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentException;
import org.slf4j.Logger;

public class RenovatorServiceImpl
implements RenovatorService {
    private static final Logger logger = RunLogger.getRunLogger();
    private static final String VALUE = "/refresh/motype/value";
    private static final String XPATH = "/refresh/motype/xpath";
    private FileProcessor fileProcessor;
    private String INRENOVATE = "0";
    private Map<String, String> intervalMap = new HashMap<String, String>();
    private MOXMLBuilder moXMLBuilder;
    private SchemaBuilder schemaBuilder;

    @Override
    public String getInterval(FeatureForm featureForm, DeviceForm deviceForm) throws FileNotFoundException, DocumentException, QatOperException {
        String featureXPath = featureForm.getXpath();
        String intervalStr = this.getIntervalFromMap(featureXPath);
        if (null != intervalStr) {
            return Integer.parseInt(intervalStr) + "";
        }
        this.initIntervalFromFile(featureForm, deviceForm);
        if (null == this.getIntervalFromMap(featureXPath)) {
            this.setIntervalToMap(featureXPath, this.INRENOVATE);
            return this.INRENOVATE;
        }
        return this.getIntervalFromMap(featureXPath);
    }

    @Override
    public OperResult<Void, Void> saveIntervalToXML(String interval, FeatureForm featureForm, DeviceForm deviceForm) throws FileNotFoundException, DocumentException, QatOperException {
        if (!CommonUtil.checkPara((Object[])new Object[]{featureForm.getFeatureName(), featureForm.getXpath(), interval})) {
            throw new QatOperException("featureName or value does not exist");
        }
        OperResult result = new OperResult();
        Schema schema = this.getIntervalSchema();
        String xmlURL = this.getIntervalXMLPath(deviceForm, featureForm);
        MOType motype = null;
        motype = schema.getMOType("/refresh/motype");
        if (!CommonUtil.exists((String)xmlURL)) {
            try {
                File fileFoder = new File(xmlURL.substring(0, xmlURL.lastIndexOf(File.separator)));
                String fileName = xmlURL.substring(xmlURL.lastIndexOf(File.separator) + 1);
                this.fileProcessor.createFile(fileFoder, fileName);
                LightMO intervalMO = this.getIntervalMO(interval, motype, featureForm.getXpath());
                this.writeIntervalToFile(intervalMO, xmlURL);
                this.setIntervalToMap(featureForm.getXpath(), interval);
            }
            catch (QatOperException e1) {
                result.setResultType(OperResultType.OPER_NOK);
                result.addError(1107525631);
                logger.error("file not exist! filename=" + xmlURL, (Throwable)e1);
                return result;
            }
        }
        LightMOTree moXML = null;
        LightMO rootMO = null;
        moXML = this.moXMLBuilder.buildMOXMLByURL(xmlURL, schema);
        rootMO = this.getRootMO(schema, moXML);
        try {
            this.setIntervalToMap(featureForm.getXpath(), interval);
            this.writeIntervalToFile(featureForm.getXpath(), motype, moXML, rootMO, xmlURL, interval);
            result.setResultType(OperResultType.OPER_OK);
        }
        catch (QatOperException e) {
            result.setResultType(OperResultType.OPER_NOK);
            result.addError(1107525631);
            logger.error("create file failed! filename=" + xmlURL, (Throwable)e);
        }
        return result;
    }

    public void setFileProcessor(FileProcessor fileProcessor) {
        this.fileProcessor = fileProcessor;
    }

    public void setMoXMLBuilder(MOXMLBuilder moXMLBuilder) {
        this.moXMLBuilder = moXMLBuilder;
    }

    public void setSchemaBuilder(SchemaBuilder schemaBuilder) {
        this.schemaBuilder = schemaBuilder;
    }

    private synchronized String getIntervalFromMap(String xpath) {
        return this.intervalMap.get(xpath);
    }

    private LightMO getIntervalMO(String interval, MOType motype, String xpath) {
        MOType parent = motype.getParent();
        LightMO intervalMO = this.moXMLBuilder.createMO((Type)parent);
        LightMO tmpMO = this.moXMLBuilder.createMO((Type)motype);
        intervalMO.addChild(tmpMO);
        tmpMO.setAttributeValue(XPATH, xpath);
        tmpMO.setAttributeValue(VALUE, interval);
        return intervalMO;
    }

    private Schema getIntervalSchema() throws QatOperException {
        String schemaURL = this.getIntervalSchemaPath();
        try {
            return this.schemaBuilder.parseSchema(schemaURL, null);
        }
        catch (com.huawei.vmf.qat.common.commonutil.QatOperException e) {
            throw new QatOperException(e);
        }
    }

    private String getIntervalSchemaPath() {
        return GlobalConstants.QAT_ROOT_DIR + File.separator + OnlineConstants.CUSTOMSCHEMA_PATH + File.separator + "intervalrefresh.xsd";
    }

    private String getIntervalXMLPath(DeviceForm deviceForm, FeatureForm featureForm) {
        return ConfigFrameUtil.getDefaultFolderPath((String)deviceForm.getPnpForm().getDeviceType(), (String)deviceForm.getPnpForm().getDeviceVersion()) + File.separator + "intervalrefresh" + File.separator + featureForm.getFeatureName() + "_intervalrefresh.xml";
    }

    private LightMO getRootMO(Schema schema, LightMOTree moXML) {
        LightMO rootMO = null;
        MOType rootMOType = null;
        List rootMOTypeList = null;
        rootMOTypeList = schema.getRootMOTypes();
        if (!CommonUtil.isEmpty((Collection)rootMOTypeList) && rootMOTypeList.size() > 0) {
            rootMOType = (MOType)rootMOTypeList.get(0);
            List rootMOList = null;
            rootMOList = moXML.getMOList(rootMOType);
            if (CommonUtil.checkPara((Object[])new Object[]{rootMOList}) && !CommonUtil.isEmpty((Collection)rootMOList)) {
                rootMO = (LightMO)rootMOList.get(0);
            }
        }
        return rootMO;
    }

    private void initIntervalFromFile(FeatureForm featureForm, DeviceForm deviceForm) throws FileNotFoundException, DocumentException, QatOperException {
        String xmlURL = this.getIntervalXMLPath(deviceForm, featureForm);
        if (!CommonUtil.exists((String)xmlURL)) {
            this.setIntervalToMap(featureForm.getXpath(), this.INRENOVATE);
            return;
        }
        Schema schema = this.getIntervalSchema();
        if (CommonUtil.checkPara((Object[])new Object[]{schema})) {
            MOType motype = schema.getMOType("/refresh/motype");
            LightMOTree commonMOXML = this.readIntervalFromFile(schema, xmlURL);
            List<Object> commonMOList = new ArrayList<LightMO>();
            if (CommonUtil.checkPara((Object[])new Object[]{commonMOXML})) {
                commonMOList = commonMOXML.getMOList(motype);
            }
            this.putIntervalToMap(commonMOList);
        }
    }

    private boolean isIntervalValueError(String intervalValue) {
        if (CommonUtil.isEmpty((CharSequence)intervalValue)) {
            return true;
        }
        return !intervalValue.matches("\\d+");
    }

    private synchronized void putIntervalToMap(List<LightMO> commonMOList) {
        String tmpIntervalValue = null;
        for (LightMO commonMO : commonMOList) {
            tmpIntervalValue = commonMO.getAttributeValue(VALUE);
            if (this.isIntervalValueError(tmpIntervalValue)) {
                tmpIntervalValue = this.INRENOVATE;
            }
            this.intervalMap.put(commonMO.getAttributeValue(XPATH), tmpIntervalValue);
        }
    }

    private synchronized LightMOTree readIntervalFromFile(Schema schema, String xmlURL) {
        LightMOTree commonMOXML = this.moXMLBuilder.buildMOXMLByURL(xmlURL, schema);
        return commonMOXML;
    }

    private synchronized void setIntervalToMap(String xpath, String intervalValue) {
        this.intervalMap.put(xpath, intervalValue);
    }

    private synchronized void writeIntervalToFile(LightMO rootMO, String xmlURL) throws QatOperException {
        this.moXMLBuilder.updateXMLByURL(rootMO, xmlURL);
    }

    private void writeIntervalToFile(String xpath, MOType motype, LightMOTree moXML, LightMO rootMO, String xmlURL, String value) throws QatOperException {
        if (!CommonUtil.checkPara((Object[])new Object[]{moXML, rootMO, motype})) {
            return;
        }
        List mos = rootMO.getAllChildren();
        boolean found = false;
        for (LightMO mo : mos) {
            if (!mo.getAttributeValue(XPATH).equals(xpath)) continue;
            mo.setAttributeValue(VALUE, value);
            found = true;
            break;
        }
        if (!found) {
            LightMO mo = this.moXMLBuilder.createMO((Type)motype);
            mo.setAttributeValue(XPATH, xpath);
            mo.setAttributeValue(VALUE, value);
            rootMO.addChild(mo);
        }
        this.writeIntervalToFile(rootMO, xmlURL);
    }
}

