/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.online.business.view.impl;

import com.huawei.vmf.qat.common.CommonUtil;
import com.huawei.vmf.qat.common.domain.GUIType;
import com.huawei.vmf.qat.common.json.JSONRPCContextHolder;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.common.rsp.OperErrorInfo;
import com.huawei.vmf.qat.common.rsp.OperResult;
import com.huawei.vmf.qat.common.rsp.OperResultType;
import com.huawei.vmf.qat.common.rsp.QatOperException;
import com.huawei.vmf.qat.common.xpath.XpathManager;
import com.huawei.vmf.qat.devicemgr.devinfo.SessionType;
import com.huawei.vmf.qat.online.business.view.AlarmViewFactory;
import com.huawei.vmf.qat.online.domain.AlarmCounts;
import com.huawei.vmf.qat.online.domain.AlarmLevel;
import com.huawei.vmf.qat.schemaprocessor.infomodel.DomainLayerType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.MOType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.SchemaId;
import com.huawei.vmf.qat.service.domain.DeviceForm;
import com.huawei.vmf.qat.service.domain.FeatureForm;
import com.huawei.vmf.qat.service.infomgr.SchemaInfoMgr;
import com.huawei.vmf.qat.service.infomgr.domain.DevInstanceLayerInfo;
import com.huawei.vmf.qat.service.support.GetExecutor;
import com.huawei.vmf.qat.service.support.RequestDataFactory;
import com.huawei.vmf.qat.service.util.ConfigFrameUtil;
import com.huawei.vmf.qat.xmlprocessor.infomodel.LightMO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class AlarmViewFactoryImpl
implements AlarmViewFactory {
    private static final String ALARM_COUNT = "fm_count";
    private static final String ALARM_STA = "fm_alarmSta";
    private static final String ALARM_LEVEL = "fm_level";
    private static final String FM_FEATURE_NAME = "fm";
    private static final Logger logger = RunLogger.getRunLogger();
    private GetExecutor getExecutor;
    private GUIType guiType;
    private RequestDataFactory requestDataFactory;
    private SchemaInfoMgr schemaInfoMgr;

    @Override
    public OperResult<AlarmCounts, Void> queryAlarmCounts(DeviceForm deviceForm) {
        LightMO alarmCountQueryMO = null;
        try {
            alarmCountQueryMO = this.composeAlarmCountQueryMo(deviceForm);
        }
        catch (QatOperException e) {
            logger.error("Get deviceForm error. deviceForm=" + deviceForm, (Throwable)e);
            OperResult operResult = new OperResult((Object)new AlarmCounts());
            operResult.setResultType(OperResultType.OPER_NOK);
            return operResult;
        }
        ArrayList<LightMO> queryMOList = new ArrayList<LightMO>();
        queryMOList.add(alarmCountQueryMO);
        FeatureForm featureForm = new FeatureForm();
        featureForm.setDomain(DomainLayerType.LR);
        OperResult operResult = this.getExecutor.batchCommitGet(JSONRPCContextHolder.getHttpSessionId(), deviceForm, featureForm, queryMOList, SessionType.ALARM);
        if (!operResult.getResultType().equals((Object)OperResultType.OPER_OK)) {
            QatOperException ex = new QatOperException(((OperErrorInfo)operResult.getErrors().get(0)).getErrorCode(), "Query Alarm error.");
            logger.error("Query Alarm error. errorcode=" + ex.getErrorCode(), (Throwable)ex);
            OperResult operResults = new OperResult((Object)new AlarmCounts());
            operResults.setResultType(OperResultType.OPER_NOK);
            return operResults;
        }
        return new OperResult((Object)this.parseAlarmCounts((List)operResult.getReturnObj()));
    }

    public void setGetExecutor(GetExecutor getExecutor) {
        this.getExecutor = getExecutor;
    }

    public void setGuiType(GUIType guiType) {
        this.guiType = guiType;
    }

    public void setRequestDataFactory(RequestDataFactory requestDataFactory) {
        this.requestDataFactory = requestDataFactory;
    }

    public void setSchemaInfoMgr(SchemaInfoMgr schemaInfoMgr) {
        this.schemaInfoMgr = schemaInfoMgr;
    }

    private LightMO composeAlarmCountQueryMo(DeviceForm deviceForm) throws QatOperException {
        String xpath;
        SchemaId schemaId = ConfigFrameUtil.genSchemaId((DeviceForm)deviceForm, (String)FM_FEATURE_NAME);
        MOType alarmCountMoType = this.schemaInfoMgr.getMOType(schemaId, new DevInstanceLayerInfo(deviceForm, DomainLayerType.LR), xpath = XpathManager.INSTANCE.getPnpXpath(schemaId.getDeviceType(), schemaId.getDeviceVersion(), ALARM_STA), this.guiType);
        if (null == alarmCountMoType) {
            throw new QatOperException("alarmCountMoType is null.");
        }
        return this.requestDataFactory.composeAllAttributesMO(alarmCountMoType);
    }

    private AlarmCounts parseAlarmCounts(List<LightMO> alarmCountMos) {
        if (CommonUtil.isEmpty(alarmCountMos)) {
            return new AlarmCounts();
        }
        String criticalAlarmCount = null;
        String majorAlarmCount = null;
        String minorAlarmCount = null;
        String warningAlarmCount = null;
        String tmpAlarmLevel = null;
        String tmpAlarmCount = null;
        for (LightMO alarmCountMo : alarmCountMos) {
            MOType motype = alarmCountMo.getMOType();
            SchemaId schemaId = motype.getSchema().getSchemaId();
            tmpAlarmLevel = alarmCountMo.getAttributeValue(XpathManager.INSTANCE.getPnpXpath(schemaId.getDeviceType(), schemaId.getDeviceVersion(), ALARM_LEVEL));
            tmpAlarmCount = alarmCountMo.getAttributeValue(XpathManager.INSTANCE.getPnpXpath(schemaId.getDeviceType(), schemaId.getDeviceVersion(), ALARM_COUNT));
            if (AlarmLevel.CRITICAL.getDescription().equals(tmpAlarmLevel)) {
                criticalAlarmCount = tmpAlarmCount;
                continue;
            }
            if (AlarmLevel.MAJOR.getDescription().equals(tmpAlarmLevel)) {
                majorAlarmCount = tmpAlarmCount;
                continue;
            }
            if (AlarmLevel.MINOR.getDescription().equals(tmpAlarmLevel)) {
                minorAlarmCount = tmpAlarmCount;
                continue;
            }
            if (!AlarmLevel.WARNING.getDescription().equals(tmpAlarmLevel)) continue;
            warningAlarmCount = tmpAlarmCount;
        }
        return new AlarmCounts(criticalAlarmCount, majorAlarmCount, minorAlarmCount, warningAlarmCount);
    }
}

