/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.online.business.config.impl;

import com.huawei.vmf.qat.common.json.JSONRPCContextHolder;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.common.rsp.OperResult;
import com.huawei.vmf.qat.common.rsp.OperResultType;
import com.huawei.vmf.qat.common.rsp.QatOperException;
import com.huawei.vmf.qat.online.business.config.WorkspaceService;
import com.huawei.vmf.qat.security.support.SessionDataHolder;
import com.huawei.vmf.qat.service.config.QueryDevService;
import com.huawei.vmf.qat.service.domain.enumeration.LRVRType;
import com.huawei.vmf.qat.service.support.Sender;
import org.slf4j.Logger;

public class WorkspaceServiceImpl
implements WorkspaceService {
    private static final Logger logger = RunLogger.getRunLogger();
    private QueryDevService queryDevService;
    private Sender sender;

    @Override
    public OperResult<Void, Void> createCDB(String neName, String neID, String isWorkspace, String deviceIp) {
        OperResult result = new OperResult();
        String sessionid = JSONRPCContextHolder.getHttpSessionId();
        SessionDataHolder.setIsWorkSpace((boolean)true);
        LRVRType type = LRVRType.LR;
        type = neName.equals("VR") ? LRVRType.VR : type;
        boolean createCdbRes = false;
        try {
            createCdbRes = this.queryDevService.createCDB(sessionid, neID, type, deviceIp);
        }
        catch (QatOperException e) {
            logger.warn("create cdb Exception.", (Throwable)e);
        }
        if (createCdbRes) {
            result.setResultType(OperResultType.OPER_OK);
        } else {
            result.setResultType(OperResultType.OPER_NOK);
            result.addError(1107525683, null);
        }
        return result;
    }

    @Override
    public OperResult<Void, String> discardChanges(boolean needLog, String neName, String neID, String devIP) {
        String sessionid = JSONRPCContextHolder.getHttpSessionId();
        OperResult result = this.sender.sendDiscardChanges(sessionid, null);
        return result;
    }

    @Override
    public OperResult<Void, String> discardCommit(String neName, String neID, String deviceIp) {
        String sessionid = JSONRPCContextHolder.getHttpSessionId();
        OperResult result = this.sender.sendDiacardCommit(sessionid, null);
        return result;
    }

    public void setQueryDevService(QueryDevService queryDevService) {
        this.queryDevService = queryDevService;
    }

    public void setSender(Sender sender) {
        this.sender = sender;
    }
}

