/**
 * 联想框控件
 */
var suggestText = null;

/**
 * 展开按钮
 */
var expandBtn = null;

/**
 * 收缩按钮
 */
var collapseBtn = null;

/**
 * 联想框默认关键词
 */
var suggesttextValue = null;

/**
 * 树对象
 */
var tree = null;

/**
 * 主窗体对象
 */
var fromWin = null;

/**
 * 保存从后台获取到的文本信息
 */
var text = null;

/**
 * text中的内容转换为DOM结构的对象 错误提示对话框使用
 */
var doc = null;

/**
 * 提示对话框对象
 */
var errorDlg = null;

/**
 * 后台返回的结果类型
 */
var resultType = null;

/**
 * 保存树中所有结点的ID的数组
 */
var matchNodeIDArray = null;

/**
 * 保存树上结点信息的数组,key为ID，content为文本内容
 */
var treeNodeArrary = null;

/**
 * 被选中结点的ID
 */
var selectedNodeID = null;

/**
 * 设备面板URL
 */
var devicePanelURL = null;

/**
 * 设备面板结点ID
 */
var devicePanelID = null;

/**
 * 定制URL
 */
var customURL = null;

/**
 * 定制URL节点ID
 */
var customURLID = null;



/**
 * 设备类型
 */
var deviceType = null;

/**
 * 设备版本
 */
var deviceVersion = null;

/**
 * 是否是工作区
 */
var isWorkspaceState = null;

/**
 * 特性名称数组
 */
var featureArray = null;

/**
 * 特性名MAP
 */
var featureNamesMap = null;

/**
 * 各个特性域的标识列表
 */
var domainMap = null;

/**
 * 提示对话框
 */
var vmtalert = null;

/**
 *  存放树节点信息
 */
var g_treeNodes = [];

/**
 * 存放节点的展开状态
 */
var g_treeNodeStatus = [];

/**
 * 存放父结点ID，key为结点ID，value为父ID
 */
var g_treeNodeParentIDs = [];

/**
 * 是否全部展开过
 */
var g_hasExpandAll = false;

/**
 * 管理员功能树数据
 */
var g_adminTreeData = null;

/**
 * 是否支持LR划分
 */
var g_isSupLRPartition = null;

/**
 * 是否支持功能树定制标题
 */
var g_isSupExtRes = null;

/**
 * XUI文件的事件处理函数映射表
 */
var signalMap =
{
    on_load_ui :doLoad,
    doFilter :doFilter,
    onExpand :onExpand,
    onCollapse :onCollapse,
    doSelChange :doSelChange
};

/**
 * 初始化加载XUI
 */
function init()
{
    logger.log("enter functree init");
    fromWin = window.parent;
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/capabilitymgr/functree/functree.xui", signalMap);
    logger.log("exit functree init");
}

/**
 * 向界面中添加数据
 */
function doLoad()
{
    logger.log("enter functree doLoad");

    featureArray = new Array();
    featureNamesMap = new Map();
    // 获取树的控件
    tree = window.xui.getWidget("Tree1");
    tree.setNodeGap(4);
    tree.ondblclick = doDBClick;
    tree.onexpanded = expandedHandle;

    expandBtn = window.xui.getWidget("Button3");
    var expandall = jse.getI18nValue("qat:public", "toolbar.expandall_d");
    expandBtn.setTooltip(expandall);

    collapseBtn = window.xui.getWidget("Button4");
    var collapseall = jse.getI18nValue("qat:public", "toolbar.collapseall_d");
    collapseBtn.setTooltip(collapseall);
    
    suggesttextValue = jse.getI18nValue("qat:public", "suggesttext.text_d");
    var suggestTextID = "SuggestText2";
    //jse实现有限制，浮动组件是window级别的，需要对id进行区分动态定义
    changeSuggestTextID(suggestTextID);
    
    isWorkspaceState = fromWin.isWorkspace;    
    g_adminTreeData = new AdminTreeData();
    
    // 若是预加载，则不进行逻辑处理
    if (preLoadFlag)
    {
        return;
    }
    
    sendGetFunctionTreeCmd();
}

/**
 * 变换suggestText组件ID，解决切换vr时联想框失效
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 * @param suggestTextID 联想框组件ID
 */
function changeSuggestTextID(suggestTextID)
{
	jse.require("jse.widget.suggesttext");
    jse.require("jse.widget.box");
	jse.require("jse.widget.grid");
	
	var rootBox = window.xui.getWidget("Box1");	 
    var suggestGrid = window.xui.getWidget("Grid2");  
    window.xui.removeWidget(suggestTextID);
    
    var gridLayoutData = suggestGrid.getLayoutData();
    gridLayoutData.preferHeight = 20;
    suggestGrid.setLayoutData(gridLayoutData);
    
    var suggestLayoutData = new jse.widget.grid.GridData();
    suggestLayoutData.preferHeight = 20;
    suggestLayoutData.preferWidth = 200;
    suggestLayoutData.columnIndex = 1;
    suggestLayoutData.rowIndex = 0;
    var suggestPObj =
    {
        jsObj :suggestGrid,
        layoutData :suggestLayoutData
    }; 
    
    var dynamicId = (neTag== "LR") ? suggestTextID : neName + suggestTextID;
    suggestText = new jse.widget.suggesttext.SuggestText(suggestPObj, dynamicId);
    suggestText.setText(suggesttextValue);
	
    suggestText.oncloseup = doCloseUp;
    suggestText.onkeyup = doKeyUp;
    suggestText.onfocus = doSuggestTextFocus;
    suggestText.onblur = doSuggestTextBlur;
    suggestText.onfilter = doFilter;
    rootBox.pack();
    
    // 注册tab键切换事件
    Tabkeyprocess.registKeyDown(tree, Tabkeyprocess.TREE, suggestText, Tabkeyprocess.SUGGESTTEXT);
}

/**
 * 外部接口：加载功能树信息，提供给集成版本预加载流程使用
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-6-28
 * @param deviceName 设备名称
 * @param vrId vrid信息
 * @param NEFlag 设备标识
 * @param isSupportPartition 是否支持划分
 * @param isWorkspace 是否是工作区
 * @param selNodeID 要选择的节点id
 */
function pub_loadDynamicContent(deviceName, vrId, NEFlag, isSupportPartition, isWorkspace)
{
    //设置动态参数
    neName = deviceName;
    neID = vrId;
    neTag = NEFlag;
    isSupPartition = isSupportPartition;
    isWorkspace = isWorkspace;
    
    sendGetFunctionTreeCmd();
}

/**
 * 下发获取功能树命令
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-6-28
 */
function sendGetFunctionTreeCmd()
{
    
    // 离线配置场景请求功能树
    if ("true" == isOffline)
    {
        // 向后台请求功能树的数据
        var req = jse.RpcRequest
                .create(handleEncodingUrl(CommonUtil.getRootPath() + "/vmt/ct/capability/FunctionTreeNavAction.do?methodID=functiontreeoffline&deviceIP="
                        + deviceIP
                        + "&officeName="
                        + encodeURIComponent(officeName)
                        + "&deviceType="
                        + deviceType_offline
                        + "&deviceVersion="
                        + deviceVersion_offline
                        + "&vrId="
                        + vrId
                        + "&isSupportPartition=" + isSupPartition + "&isOffline=" + "true"));
    }
    // 在线配置场景请求功能树
    else
    {
        var pnpForm = jse.topWin.pub_getClonePnpForm();
        var boardCapTypes = jse.topWin.pub_getDeviceWin().pub_getBoardCapTypes();
        var boarTypePara = (boardCapTypes != null) ? "&boardCapTypes=" + boardCapTypes : ""; 
        // 向后台请求功能树的数据
        var req = jse.RpcRequest
                .create(handleEncodingUrl(CommonUtil.getRootPath() + "/vmt/ct/capability/FunctionTreeNavAction.do?methodID=functiontree&neName="
                        + neTag
                        + "&neID="
                        + neID
                        + "&isWorkspace="
                        + isWorkspace
                        + "&isSupportPartition="
                        + isSupPartition
                        + "&isOffline="
                        + "false"
                        + "&pnpDeviceType="
                        + pnpForm.deviceType
                        + "&pnpDeviceVersion=" + pnpForm.deviceVersion + "&compatible=" + pnpForm.compatible + boarTypePara));
    }
    logger.log("enter functree doLoad invoke");
    req.invoke(handleResult, [ "funcTreeHandler();" ]);
}

//不选中节点时的处理,只展开根节点的处理
function expandRootNode()
{
    //展开根节点
    tree.expandNode(Constants.FUNCTREEROOTID);
    
    //去掉三段式其他的Tab页处理，添加一个默认的空Tab页
    addFeatureViewBySelNode();
}


/**
 * 展开第一个配置对象
 * 
 * @return
 */
function expendFirstNode()
{
    var childID = tree.getFirstChildNodeId(Constants.FUNCTREEROOTID);
    var focusID = null;

    if (null != childID)
    {
        focusID = getFirstConfigNodeID(childID);
    }
    if (null != focusID)
    {
        setSelNodeAddFeatureView(focusID);
    }
}

/**
 * 获取第一个可配置结点
 * 
 * @param nodeID
 * @return
 */
function getFirstConfigNodeID(nodeID)
{
    //展开该层节点
    if(null == g_treeNodeStatus[nodeID] || !g_treeNodeStatus[nodeID])
    {
        addFunctionTreeNodes(nodeID, g_treeNodes[nodeID]);
        g_treeNodeStatus[nodeID] = true;
    }
    
    var childID = tree.getFirstChildNodeId(nodeID);
    if (null != childID)
    {
        var nodeType = getNodeTypeByID(childID);
        if (nodeType == "CONTENT" || nodeType == "URL")
        {
            return childID;
        }
        else
        {
            return getFirstConfigNodeID(childID);
        }
    }
    return childID;
}

/**
 * 
 * 鼠标点击“请输入关键字”文本框时，内容自动清除
 */
function doSuggestTextFocus(evt)
{
    var currText = suggestText.getText();
    if (currText == suggesttextValue)
    {
        suggestText.setText("");
    }
}
/**
 * 
 * 当内容为空并失去焦点时，自动填充“请输入关键字”
 * 
 */
function doSuggestTextBlur(evt)
{
    var currText = suggestText.getText();
    if (currText == "")
    {
        suggestText.setText(suggesttextValue);
    }
}

/**
 * 功能树节点
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-6-28
 * @param nodeID 节点id
 * @param parentID 父节点id
 * @param nodeType 节点类型
 * @param domain 域信息
 * @param resNodeId 资源信息id
 * @param imageType 图标类型
 * @param unSupportedVR 特性结点在LR上不支持的实例
 * @param unSupportedLR 特性结点在VR上不支持的实例
 */
function FunctionTreeNode(nodeID, parentID, nodeType, domain, resNodeId, imageType, unSupportedLR, unSupportedVR, appearOnce)
{
    this.nodeID = nodeID;
    this.parentID = parentID;
    this.nodeType = nodeType;
    this.domain = domain;
    this.resNodeId = resNodeId;
    this.imageType = imageType;
    this.nodeText = null;
    this.appearOnce = appearOnce;
    this.unSupportedVR = unSupportedVR;
    this.unSupportedLR = unSupportedLR;
}


/*
 * 当请求返回时，处理返回的数据，并对返回的数据应用规则加载到设备功能树中
 */
function funcTreeHandler()
{

    logger.log("enter functree funcTreeHandler");

    domainMap = [];

    if("OPER_OK" != resultType)
    {
        // 显示错误信息
        VMTError("win.errorClose();");
    }
    
    // 取出中英文资源对应的文件名
    var versionNode = jse.selectSingleNode("/response/data/resFileName", doc);
    var versionValue = versionNode.getAttribute("value");

    isSupLRPartitionValue = jse.selectSingleNode("/response/data/isSupportLRPartition", doc).getAttribute("value");
    g_isSupLRPartition = ("true" == isSupLRPartitionValue) ? true : false;
    g_adminTreeData._isAdminTreeFileExist = jse.selectSingleNode("/response/data/isAdminTreeFileExist", doc).getAttribute("value");
    //是否支持定制功能树标题
    g_isSupExtRes = (jse.selectSingleNode("/response/data/extRes", doc).getAttribute("value") == "true") ? true : false;
    
    var devInfo = versionValue.split("_");
    deviceType = devInfo[0];
    deviceVersion = devInfo[1];

    if ("true" != isOffline)
    {
        var top = jse.topWin;
        top.pub_setDeviceInfo(deviceType, deviceVersion, top.resID);
        jse.topWin.pub_setAlarmPanelInterval();
    }
    
    //支持LR划分则显示管理员功能树
    var lrRole = jse.topWin.g_lrRole;
    if("LR" == neTag &&　"true" == g_adminTreeData._isAdminTreeFileExist && (!jse.topWin.pub_getDeviceWin().pub_isSelectBoardNode()))
    {
    	if(lrRole.toLowerCase() == InstanceType.ADMIN && (g_isSupLRPartition || isSupPartition))
    	{
    		addAdminTreeRootNode();
    	}
    	else if(lrRole.toLowerCase() == InstanceType.COMMON && isSupPartition)
    	{
    		addAdminTreeRootNode();
    	}
    }
    
    //解析功能树
    analyseAndLoadFunctionTree();
    
    if ("true" == isOffline)
    {
        var featureNames = "";
        var featureNameWithVersions = "";
        for(var i = 0; i < featureArray.length; i += 2)
        {
            featureNames += featureArray[i] + "@fe_fe@";
        }  
        for(var i = 1; i < featureArray.length; i += 2)
        {
            featureNameWithVersions += featureArray[i] + "@fe_fe@";
        }  
        var featureForms = getFeatureForms(Constants.FUNCTREEROOTID, null);
        fromWin.createConfigFile(featureNames,featureForms);
    }

    //加载fm菜单
    setTimeout("loadFmMenus()", 300)

    if ("true" == isOffline)
    {
        // 在特性树加载结束之后，使能设备树选择
        fromWin.pub_enableSelDevs(true);
    }
}

/**
 * 添加树结点
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 * @param parentID 父节点ID
 * @param nodeID 节点ID
 * @param nodeText 节点显示信息
 * @param image 图片信息
 * @param tooltip tooltip信息
 * @param fethchedStatus 节点前是否添加加号
 */
function addTreeNode(parentID, nodeID, nodeText, image, tooltip, fethchedStatus)
{
    tree.addNode(parentID, nodeID,
    {
        text : nodeText,
        image :
        {
            as : image
        },
        tooltip : tooltip,
        fetched : fethchedStatus
    });
}

/**
 * 解析并加载功能树
 */
function analyseAndLoadFunctionTree()
{
	addFuncTreeRootNode();
	
    // 判断树上结点的个数,如果不为0，就向树上添加结点。否则只添加根结点
    var treenodeNumNode = jse.selectSingleNode("/response/data/funcTreeNodeNum", doc);
    var treenodeNumValue = treenodeNumNode.getAttribute("value");
    if (treenodeNumValue != "0")
    {
        // 向树中添加结点
        var treeList = jse.selectNodes("/response/data/object", doc);
        
        for ( var i = 0, size = treeList.length; i < size; i++)
        {
            var treeNode = treeList[i];
            var node = getFunctionTreeNodeByDoc(treeNode);
            domainMap[node.nodeID] = node.domain;
            g_treeNodeParentIDs[node.nodeID] = node.parentID;

            if(null == g_treeNodes[node.parentID])
            {
                g_treeNodes[node.parentID] = [node];
            }
            else
            {
                g_treeNodes[node.parentID].push(node);
            }
            
            
        }
        logger.log("exit analyseTree");
        
        //添加节点
        var managerNodes = g_treeNodes[Constants.FUNCTREEROOTID];
        var firstChildId = managerNodes[0].nodeID;
        
        addFunctionTreeNodes(Constants.FUNCTREEROOTID, managerNodes);
        addFunctionTreeNodes(firstChildId, g_treeNodes[firstChildId]);
        
        //记录这两个节点展开过
        g_treeNodeStatus[Constants.FUNCTREEROOTID] = true;
        g_treeNodeStatus[firstChildId] = true;

        // 设置选中结点,并加载对应的特性Tab页
        if (selNodeID != null)
        {
            // 设置被选中的树结点，并加载对应的特性Tab页
            setSelNodeAddFeatureView(selNodeID);
        }
        else
        {
            if (neTag == "LR" && !isWorkspaceState && devicePanelID != null)
            {
                logger.log("enter functree setSelNodeAddFeatureView");
                // 设置选中树上的面板结点，并加载面板的URL
                setSelNodeAddFeatureView(devicePanelID);
                var title = F1HelpUtil.getF1HelpID("pannel");
                F1HelpUtil.resetF1PageTitle(title);                
            }
            else
            {
                var panelWin = jse.topWin.pub_getPanelWin();
                if(null != panelWin && null != panelWin.devicePanel)
                {
                    var panelMenuStatus = panelWin.devicePanel.menuStatus;
                    var jumpToFuncTreeNodeId = panelMenuStatus.getJumpToFuncTreeNodeId();
                    if(null != jumpToFuncTreeNodeId)
                    {
                        panelMenuStatus.setJumpToFuncTreeNodeId(null); 
                        selectSpecicalNode(jumpToFuncTreeNodeId); 
                        return; 
                    }
                }
                expandRootNode();
//                expendFirstNode();
            }
        }

    }
}

/**
 * 根据报文中结点内容组装成前台树结点结构
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 * @param docNode
 * @return
 */
function getFunctionTreeNodeByDoc(docNode)
{
    var nodeID = docNode.getAttribute("name");
    var nodeParentID = docNode.getAttribute("parentName");
    var type = docNode.getAttribute("nodeType");
    var appearOnce = docNode.getAttribute("appearOnce");
    var domain = docNode.getAttribute("domain");
    var unSupportedLR = docNode.getAttribute("unSupportedLR");
    var unSupportedVR = docNode.getAttribute("unSupportedVR");
    return new FunctionTreeNode(nodeID, nodeParentID, type, domain, null, "", unSupportedLR, unSupportedVR, appearOnce);
 
}

/**
 * 添加功能树根结点
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 */
function addFuncTreeRootNode()
{
	// 添加树的根结点，---------其中“功能树”需要对应为中英文资源，tooltip和文本内容
    var imageType = CommonUtil.getRootPath() + "/vmt/image/folder.gif";
//    var funcRootText = neName + Resource.getResource("qat:public", "tree.functiontree_d");
//    var funcRootTips = neName + Resource.getResource("qat:public", "tree.functiontree_t");
    var funcRootText = Resource.getResource("qat:public", "tree.functiontree_d");
    var funcRootTips = Resource.getResource("qat:public", "tree.functiontree_t");
    addTreeNode(null, Constants.FUNCTREEROOTID, funcRootText, imageType, funcRootTips, false);
    tree.setNodeEnableSelected(Constants.FUNCTREEROOTID, false);
}

/**
 * 添加管理员功能树根结点
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 */
function addAdminTreeRootNode()
{
	// 添加树的根结点，---------其中“功能树”需要对应为中英文资源，tooltip和文本内容
    var imageType = CommonUtil.getRootPath() + "/vmt/image/folder.gif";
    var rootNodeText = Resource.getResource("qat:public", "tree.admintree_d");
    var rootNodeTips = Resource.getResource("qat:public", "tree.admintree_t");
    addTreeNode(null, Constants.ADMINTREEROOTID, rootNodeText, imageType, rootNodeTips, true);
    tree.setNodeEnableSelected(Constants.ADMINTREEROOTID, false);
}

/**
 * 加载fm菜单
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-6-22
 * @return
 */
function loadFmMenus()
{
    var top = jse.topWin;
    if ("undefined" != typeof (top.addFaultMenuItems))
    {
        // 故障管理的菜单项的ID数组和文本数组
        var faultItemIds = [];
        var faultItemTexts = [];
        
        for(var parentNodeId in g_treeNodes)
        {
            if (parentNodeId.lastIndexOf("]fm") == parentNodeId.length -3)
            {
                var childs = g_treeNodes[parentNodeId];
                for(var index in childs)
                {
                    var node = getNodeResId(childs[index]);
                    var nodeInfo = Resource.getTreeInfoResource(node.resNodeId + Constants.SUFFIX_D);
                    faultItemIds.push(node.nodeID);
                    faultItemTexts.push(nodeInfo);
                }
                break;
            }
        }
        
        top.addFaultMenuItems(faultItemIds, faultItemTexts);
    }
}
/**
 * 获取包括结点资源和图片信息的结点结构
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24 
 * @param nodeInfo
 * @return 
 */
function getAdminResNode(nodeInfo)
{
    var type = nodeInfo.nodeType;
    var nodeID = nodeInfo.nodeID;
    var nodeText = nodeID.split("]");
    var resNode = nodeText.length == 1 ? nodeID : Constants._PREFIX + nodeText[nodeText.length - 1];
    
    if (type == "CONTENT")
    {
        imageType = CommonUtil.getRootPath() + "/vmt/image/folderLeaf.gif";
    }
    else
    {
        imageType = CommonUtil.getRootPath() + "/vmt/image/folder.gif";
        
        if (type == "FEATURE")
        {
            featureArray.push(nodeText[nodeText.length - 1]);
            featureNamesMap.put(nodeID, nodeText[nodeText.length - 1]);
        }
    }
    
    nodeInfo.imageType = imageType;
    nodeInfo.resNodeId = resNode;    
    return nodeInfo;
}

/**
 * 解析节点id信息
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-6-22
 * @param nodeInfo 节点信息
 * @return
 */
function getNodeResId(nodeInfo)
{
    var type = nodeInfo.nodeType;
    var nodeID = nodeInfo.nodeID;
    var nodeText = nodeID.split("]");
    var imageType;

    var resNode = null;
    if (type == "CONTENT")
    {
        imageType = CommonUtil.getRootPath() + "/vmt/image/folderLeaf.gif";

        if (nodeText.length > 1)
        {
            resNode = nodeText[nodeText.length - 1];
        }
        else if (nodeText.length == 1)
        {
            resNode = nodeID;
        }
        if (g_isSupExtRes)
        {
            resNode = nodeID;
        }     
    }
    else if (type == "URL")
    {
        imageType = CommonUtil.getRootPath() + "/vmt/image/folderLeaf.gif";
        var paneInfo = nodeText[nodeText.length - 1].split("@");
        devicePanelURL = CommonUtil.addRootPathToPrefix(paneInfo[paneInfo.length - 1]);
        devicePanelID = nodeID;

        resNode = paneInfo[paneInfo.length - 2];
    }
    else if (type == "CUSTOMURL")
    {
        imageType = CommonUtil.getRootPath() + "/vmt/image/folderLeaf.gif";
        var paneInfo = nodeText[nodeText.length - 1].split("@");
        customURL = CommonUtil.addRootPathToPrefix(paneInfo[paneInfo.length - 1]);
        customURLID = nodeID;
        resNode = paneInfo[paneInfo.length - 1];
    }
    else
    {
        if (type == "FEATURE")
        {
            featureArray.push(nodeText[nodeText.length - 1]);
            featureNamesMap.put(nodeID, nodeText[nodeText.length - 1]);
        }

        imageType = CommonUtil.getRootPath() + "/vmt/image/folder.gif";

        if (nodeText.length > 1)
        {
            resNode = nodeText[nodeText.length - 1];
        }
        else if (nodeText.length == 1)
        {
            resNode = nodeID;
        }
                 
    }
    
    nodeInfo.imageType = imageType;
    nodeInfo.resNodeId = resNode;
    
    return nodeInfo;
}

/**
 * 向功能树添加指定节点下的子节点
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-6-22
 * @param parentId 父节点id
 * @param nodes 子节点
 */
function addFunctionTreeNodes(parentId, nodes)
{
    for(var index in nodes)
    {
        var node = nodes[index];
        if(isFuncTreeNodeCut(node))
        {
        	continue;
        }
        node = getNodeResId(node);
        var nodeInfo = null;
        var nodeTips = null;
        if (g_isSupExtRes)
        {
            nodeInfo = Resource.getTreeInfoResource(node.nodeID + Constants.SUFFIX_D);
            nodeTips = Resource.getTreeInfoResource(node.nodeID + Constants.SUFFIX_T);
        }
        else
        {
            nodeInfo = Resource.getTreeInfoResource(node.resNodeId + Constants.SUFFIX_D);
            nodeTips = Resource.getTreeInfoResource(node.resNodeId + Constants.SUFFIX_T);
        }
        
        var isfetched = false;
        if(null != g_treeNodes[node.nodeID])
        {
            //如果有子节点，则有加号标记
            isfetched = true;
        }
      addTreeNode(parentId, node.nodeID, nodeInfo, node.imageType, nodeTips, isfetched);
      if (((node.nodeType == "FEATURE") || (node.nodeType == "MANAGER")))
      {
          tree.setNodeEnableSelected(node.nodeID, false);
      }
    }
}

/**
 * 展开或收缩局点时结点图片替换方法
 * 
 * @param evt
 * @return
 */
function expandedHandle(evt)
{
    if(evt.isExpanded)
    {
	    loadTreeNodes(evt.id);
        tree.expandNode(evt.id);
    }
    
    dealNodeImage(evt.id);
}

/**
 * 加载树结点
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 * @param nodeId
 */
function loadTreeNodes(nodeId)
{
    var rootId = getRootNodeId(nodeId);
    
    if(Constants.FUNCTREEROOTID == rootId)
    {    	
	    if(null == g_treeNodeStatus[nodeId] || !g_treeNodeStatus[nodeId])
	    {
	        addFunctionTreeNodes(nodeId, g_treeNodes[nodeId]);
	        g_treeNodeStatus[nodeId] = true;
	    }
    }
    else if(Constants.ADMINTREEROOTID == rootId)
    {
    	g_adminTreeData._expandNodeId = nodeId;
    	loadAdminTreeNodes();
    }
    
}

/**
 * 加载管理员树结点
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 */
function loadAdminTreeNodes()
{
	if(g_adminTreeData._isAdminTreeLoaded)
	{
		addAdminTreeNode(true);
	}
	else
	{
		g_adminTreeData._currentOperType = AdminTreeOperType.EXPAND;
		requestAdminTreeDatas();
	}
}

/**
 * 添加管理员树结点
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 */
function addAdminTreeNode(isExpand)
{
	if(null == g_adminTreeData._expandNodeId)
	{
		return;
	}
	
	nodeId = g_adminTreeData._expandNodeId;
	if(null == g_adminTreeData._adminTreeNodeStatus[nodeId] || !g_adminTreeData._adminTreeNodeStatus[nodeId])
	{
		addAdminTreeSubNodes(nodeId, g_adminTreeData._adminTreeNodes[nodeId]);
		g_adminTreeData._adminTreeNodeStatus[nodeId] = true;
	}
	if(isExpand)
	{
		tree.expandNode(nodeId);
		dealNodeImage(nodeId);		
	}
}

/**
 * 添加管理员功能树上全部结点
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 */
function addAllAdminTreeNodes()
{
	for(var index in g_adminTreeData._adminTreeNodes)
	{
	    //表示未展开过
	    if(null == g_adminTreeData._adminTreeNodeStatus[index]) 
	    {
	    	g_adminTreeData._expandNodeId = index;
	        addAdminTreeSubNodes(index, g_adminTreeData._adminTreeNodes[index]);
	    }
	}
	expandAllNodesAfterLoaded();
	g_adminTreeData._adminHasExpandAll= true;
}

/**
 * 根据结点ID添加子结点
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 * @param parentId
 * @param nodes
 */
function addAdminTreeSubNodes(parentId, nodes)
{
	for(var index in nodes)
    {
        var node = nodes[index];       
        if(isAdminTreeNodeCut(parentId, node))
        {
        	continue;
        }
        node = getAdminResNode(node);
        var nodeInfo = Resource.getAdminTreeInfoResource(node.resNodeId + Constants.SUFFIX_D);
        var nodeTips = Resource.getAdminTreeInfoResource(node.resNodeId + Constants.SUFFIX_T);
        var isfetched = false;
        if(null != g_adminTreeData._adminTreeNodes[node.nodeID])
        {
            //如果有子节点，则有加号标记
            isfetched = true;
        }
      addTreeNode(g_adminTreeData._expandNodeId, node.nodeID, nodeInfo, node.imageType, nodeTips, isfetched);
      if (((node.nodeType == "FEATURE") || (node.nodeType == "MANAGER")))
      {
          tree.setNodeEnableSelected(node.nodeID, false);
      }
    }
}

/**
 * 是否cut掉管理员功能树上该结点
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 * @param node
 * @return {Boolean}
 */
function isAdminTreeNodeCut(parentId, node)
{
	var lrRole = jse.topWin.g_lrRole;
	if(parentId == Constants.ADMINTREEROOTID)
	{
		//LR0
		if(lrRole.toLowerCase() == InstanceType.ADMIN)
		{
			if(!g_isSupLRPartition && AdminTreeType.PRADMIN ==node.domain)
			{
				return true;
			}
			else if(!isSupPartition && AdminTreeType.LRADMIN ==node.domain)
			{
				return true;
			}
		}
		//LRn
		else if(lrRole.toLowerCase() == InstanceType.COMMON)
		{
			if((!isSupPartition && AdminTreeType.LRADMIN ==node.domain) || AdminTreeType.PRADMIN ==node.domain)
			{
				return true;
			}
		}
	}
	
	//对domain信息处理
	if("null" == node.unSupportedLR)
	{
		return false;
	}	
	if(lrRole.toLowerCase() == InstanceType.ADMIN)
    {
    	return node.unSupportedLR == InstanceType.ADMIN;
    }
    else if(lrRole.toLowerCase() == InstanceType.COMMON)
    {
    	return node.unSupportedLR == InstanceType.COMMON;
    }
}

/**
 * 是否cut掉功能树上该结点
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 * @param node
 * @return {Boolean}
 */
function isFuncTreeNodeCut(node)
{
	var lrRole = jse.topWin.g_lrRole;
	if("LR" == neTag)
	{
		if("null" == node.unSupportedLR)
		{
			return false;
		}
		if(lrRole.toLowerCase() == InstanceType.ADMIN)
		{
			return node.unSupportedLR == InstanceType.ADMIN || node.unSupportedLR == InstanceType.ANY;
		}
		else if(lrRole.toLowerCase() == InstanceType.COMMON)
		{
			return node.unSupportedLR == InstanceType.COMMON || node.unSupportedLR == InstanceType.ANY;
		}
	}
	else
	{
		if("null" == node.unSupportedVR)
		{
			return false;
		}
		return node.unSupportedVR == InstanceType.COMMON || node.unSupportedVR == InstanceType.ANY;
	}
}

/**
 * 请求管理员功能树数据
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 */
function requestAdminTreeDatas()
{
	var pnpForm = jse.topWin.pub_getClonePnpForm();
	// 向后台请求功能树的数据
    var req = jse.RpcRequest
            .create(handleEncodingUrl(CommonUtil.getRootPath() + "/vmt/ct/capability/FunctionTreeNavAction.do?methodID=admintree&pnpDeviceType="
                    + pnpForm.deviceType + "&pnpDeviceVersion=" + pnpForm.deviceVersion + "&compatible=" + pnpForm.compatible));
    req.invoke(handleResult, [ "adminTreeHandler();" ]);
}

/**
 * 处理后台返回的管理员功能树数据
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 */
function adminTreeHandler()
{
	if("OPER_OK" != resultType)
    {
        // 显示错误信息
        VMTError("win.errorClose();");
    }
    
    g_adminTreeData._isAdminTreeLoaded = true;
	var treenodeNum = jse.selectSingleNode("/response/data/funcTreeNodeNum", doc).getAttribute("value");
    if (treenodeNum != "0")
    {
    	// 向树中添加结点
        var treeList = jse.selectNodes("/response/data/object", doc);        
        for ( var i = 0, size = treeList.length; i < size; i++)
        {
        	var treeNode = treeList[i];
            var node = getFunctionTreeNodeByDoc(treeNode);
            domainMap[node.nodeID] = node.domain;
            g_adminTreeData._adminTreeNodeParentIDs[node.nodeID] = node.parentID;
            
            if(null == g_adminTreeData._adminTreeNodes[node.parentID])
            {
                g_adminTreeData._adminTreeNodes[node.parentID] = [node];
            }
            else
            {
                g_adminTreeData._adminTreeNodes[node.parentID].push(node);
            }
        }
    }
    
    switch(g_adminTreeData._currentOperType)
    {
    	case AdminTreeOperType.EXPANDALL:
    		addAllAdminTreeNodes();
    		break;
    	case AdminTreeOperType.EXPAND:
    		addAdminTreeNode(true);
    		break;
    	case AdminTreeOperType.FILTER:
    	    getAdminTreeTextArray();
    	    getFuncTreeTextArray();
    	    setMatchsToSuggestText();
    	    //联想框前后台交互，第一次不显示下拉列表，暂时主动调用jse未暴露接口规避该问题
    	    suggestText.showMask();
    	    break;
    }
}

/**
 * 根据结点ID获取树的根结点
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 * @param {} nodeId
 * @return {}
 */
function getRootNodeId(nodeId)
{
	var parentId = tree.getParentNodeId(nodeId);
	if(null == parentId)
	{
		return nodeId;
	}
	return getRootNodeId(parentId);
}

/**
 * 判断该结点的所有父结点是否已展开
 */
function isAllPathExpanded(id)
{
    var parentID = tree.getParentNodeId(id);
    if (tree.isExpanded(id) && isAllPathExpanded(parentID))
    {
        return true;
    }
     return false;
}

/**
 * 处理结点的图片是否需要替换
 * 
 * @param id
 * @return
 */
function dealNodeImage(id)
{
    var nodeType = getNodeTypeByID(id);
    if (id == Constants.FUNCTREEROOTID || id == Constants.ADMINTREEROOTID           
         || "FEATURE" == nodeType || "MANAGER" == nodeType)
    {
        replaceImage(id);
    }

}

/**
 * 替换图片
 * 
 * @param id
 * @return
 */
function replaceImage(id)
{
    if (tree.isExpanded(id))
    {
        tree.setNodeImage(id, "as", CommonUtil.getRootPath() + "/vmt/image/folder_open.gif");
    }
    else
    {
        tree.setNodeImage(id, "as", CommonUtil.getRootPath() + "/vmt/image/folder.gif");
    }
}

/**
 * 根据结点的ID获取结点的类型
 * 
 * @param id
 * @return
 */
function getNodeTypeByID(id)
{
	var node = getTreeNode(id);
	if(null == node)
	{
		return null;
	}
	return node.nodeType;
}

/**
 * 错误对话框回调函数
 * 
 * @return
 */
function errorClose()
{
    // errorDlg.dispose();
}

/**
 * 清除树上选中结点
 * 
 * @return
 */
function pub_clearSelectNode()
{
    tree.clearSelection();
}

/**
 * 设置错误对话框大小
 * 
 * @param width
 * @param height
 */
function setPreferSize(width, height)
{
    errorDlg.setPreferSize(width, height);
}
/**
 * 
 * 当树上某个结点被选中时的事件处理
 */
function doSelChange(evt)
{
	//切换功能树时，加下蒙板，防止用户快速切换功能树，导致js界面响应问题报错
	if (jse.topWin.g_mask.isInitingMask())
	{
	    return;	
	}
	jse.topWin.g_mask.createMask();
	
    refreshByClickFuncTree(evt);
    
//    var tabViewCtrl = jse.topWin.pub_getFeatureTabViewCtrl();
//    var viewManager = tabViewCtrl.getViewManager();
//    //获取二段表格
//    var dataCtrl = null
//    var DataTable = null;
//    if (tabViewCtrl.getCurrentTabId() == null)
//    {
//        refreshByClickFuncTree(evt);
//    }   
//    else
//    {
//        if (tabViewCtrl.getCurrentTabId() == "feature")
//        {
//            dataCtrl = viewManager.getWindowById("feature").pub_getDataController();
//        }
//        else
//        {
//            dataCtrl = viewManager.getWindowById(tabViewCtrl.getCurrentTabId()).pub_getDataController();
//        }
//        //获取三段数据 
//        var detailDataChange = false;
//        var detailCtrl = dataCtrl.getDetailCtrl();
//        
//        for(var child in detailCtrl._customChildTabIds)
//        {
//            var customTab = detailCtrl._customChildTabIds[child];
//            if (customTab.tabId.indexOf("@URL")>-1)
//            {
//                
//            }
//            else
//            {
//                var detailTable = detailCtrl.getViewManager().getWindowById(customTab.tabId).getDetailTable();
//                if (detailTable.hasModifyCell())
//                {
//                    detailDataChange = true;
//                    break;
//                }
//            }    
//             
//        }  
//        if (detailDataChange)
//        {
//            var message = Resource.getResource("qat:public", "dataTable.update_d");
//            CommonDlgReq.openAlertDialog(message, refreshByClickFuncTree, null, [ evt ]);
//        }   
//        else if (dataCtrl.getTable().hasModifiedCell())
//        {
//            var message = Resource.getResource("qat:public", "dataTable.update_d");
//            CommonDlgReq.openAlertDialog(message, refreshByClickFuncTree, null, [ evt ]);
//        }
//        else
//        {
//            
//        }    
//        refreshByClickFuncTree(evt);
//    }    
 
    // 功能树切换完毕，清除蒙板
    jse.topWin.g_mask.disposeMask();
}


/**
 * 点击左侧功能树刷新页面
 * 
 * @param evt 
 * @returns
 */
function refreshByClickFuncTree(evt)
{
	
    if (!evt.isAdjusting)
    {
        var selIDs = tree.getSelection();
        if (selIDs.length == 1)
        {
            // 根据已经选中的树结点，加载对应的特性Tab页
            setTreeSelectedNode(evt.id);
        }
    }
    else
    {
        var selIDs = tree.getSelection();
        if (selIDs.length > 1 || selIDs.length == 0)
        {
            tree.setCurrentSelection(selectedNodeID);
            return;
        }
    }


}

/**
 * 设置结点ID为选中状态 提供给主窗体调用
 */
function setSelNode(nodeid)
{
    // 设置结点为选中状态（展开）
    selectedNodeID = nodeid;
    tree.expandNode(nodeid);
    tree.setCurrentSelection(nodeid);
    setNodeImagebyID(nodeid);
}

/**
 * 设置选中节点并加载特性Tab 提供给主窗体调用
 */
function setSelNodeAddFeatureView(nodeid)
{
    logger.log("enter setSelNodeAddFeatureView");
    // 设置结点的选中状态（展开）
    // selectedNodeID = nodeid;
    tree.expandNode(nodeid);
    tree.setCurrentSelection(nodeid);
    setNodeImagebyID(nodeid);

    // 根据已经选中的结点，加载对应的特性Tab页
    if (!preLoadFlag)
    {
        setTreeSelectedNode(nodeid);
    }
    
    logger.log("end setSelNodeAddFeatureView");
}

/**
 * 获取树中被选中的结点的ID，并加载对应的特性Tab页 提供给主窗体调用
 */
function addFeatureViewBySelNode()
{
    // 获取当前被选中的结点
    var nodeSelected = tree.getCurrentSelection();
    var title = F1HelpUtil.getF1HelpID("root");
    F1HelpUtil.resetF1PageTitle(title);
//    resetMainFrameTitle();
    if (null == nodeSelected)
    {
        fromWin.pub_addFeatureViewWithCondition(null, null,null, null, null, false, "query", "", null, null);
    }
    else
    {
        tree.expandNode(nodeSelected);
        selectedNodeID = null;
        // 根据树中被选中的结点的ID加载对应的特性Tab页
        setTreeSelectedNode(nodeSelected);
    }

}
/**
 * 获取树节点
 * 
 * @param id
 * @return
 */
function getTreeNode(id)
{
	if(id == Constants.ADMINTREEROOTID || id == Constants.FUNCTREEROOTID)
	{
		return null;
	}
	var parentID = tree.getParentNodeId(id); 
	var isAdminTreeNode = isAdminTreeNodeId(id);
	var node = null;
	if(null != parentID)
	{
		var childs = isAdminTreeNode ? g_adminTreeData._adminTreeNodes[parentID] : g_treeNodes[parentID];

		for(var index in childs)
	 	{
	 		if(id == childs[index].nodeID)
	 		{
	 			node = childs[index];
	 			break;
	 		}
	 	}		
	}
    return node;
		
}

/**
 * 获取树上只出现一次结点所属的MOType结点的Xpath
 * 
 * @param treeNodeID
 * @return
 */
function getGroupBelongMotypeXpath(treeNodeID)
{
    var node = getTreeNode(treeNodeID);
    var parentID = node.parentID;

    // 获取其父节点对象
    var parentNode = getTreeNode(parentID);
    var nodeType = parentNode.nodeType;
    var appearOnce = parentNode.appearOnce;

    if (nodeType == "CONTENT" && appearOnce == "false")
    {
        var nodeInfoList = parentID.split("]");
        return nodeInfoList[nodeInfoList.length - 1];
    }
    else if (nodeType == "CONTENT" && appearOnce == "true")
    {
        return getGroupBelongMotypeXpath(parentID);
    }
}
/**
 * 根据节点ID获得对应特性的父的节点的名称，直至根
 * 
 * @param nodeId 节点id
 * @return 父的节点的名称
 */
function getFeatureParentNodeTexts(nodeId)
{
	var parentIds = new Array();
	var parentNodeId = tree.getParentNodeId(nodeId);
	while(null != parentNodeId && parentNodeId.indexOf("]") >0)
	{
		parentIds.push(tree.getNodeText(parentNodeId));
		parentNodeId = tree.getParentNodeId(parentNodeId);
	}
	return parentIds;
}

/**
 * 根据已经选中的树结点，加载对应的特性Tab页 去掉选中相同节点返回条件分支的原因是：告警板跳转时，节点相同但查询条件不同
 * 
 */
function setTreeSelectedNode(treeNodeID, condition)
{
	var parentNodeTexts = getFeatureParentNodeTexts(treeNodeID);
	var title = F1HelpUtil.getF1HelpID("root");
    F1HelpUtil.resetF1PageTitle(title);
//    resetMainFrameTitle();
    window.document.title = fucntreeType;
    var isFeatureNode = null;
    var nodeVersion = null;
    var title = null;
    var pnpForm = jse.topWin.pub_getClonePnpForm();
    selectedNodeID = treeNodeID;
    // 获取该结点的文本信息
    var selectedNodeText = tree.getNodeText(treeNodeID);

    // 获取右边tab页的title
    title = Constants.TIELESEPRATOR + selectedNodeText;

    // 判断结点类型
    if (treeNodeID == Constants.FUNCTREEROOTID)
    {
        // 离线情况下对点击功能树跟结点的处理
        if ("true" == isOffline)
        {
            isFeatureNode = false;

            var featureForms = getFeatureForms(treeNodeID, nodeType);
            fromWin.pub_addMultiFeatureView(featureForms, title);
            isFeatureNode = false;
            return;
        }
        else
        {
            isFeatureNode = false;
            return;
        }

    }
    else
    {
        var node = getTreeNode(treeNodeID);
        if(node == null)
        {
        	return;
        }
        var nodeType = node.nodeType;
        if (nodeType == "CONTENT")
        {
            var title = F1HelpUtil.getF1HelpID("root");
            F1HelpUtil.resetF1PageTitle(title);
//            changeMainFrameTitle("root");
	        var nodeIDSplits = treeNodeID.split("]");
        	var xpath = nodeIDSplits[nodeIDSplits.length - 1];
            jsonrpc.invoke("typeCustomJudgement", "setChoosedTreeNode", [xpath]);
        	
            isFeatureNode = true;

            // 获取要传递给featureMgr的特性的版本信息
//            var selectedNode = jse.selectSingleNode("/response/data/object[@name='" + treeNodeID + "']", doc);
            var appearOnce = node.appearOnce;
            var groupMOtypeXpath = null;

            if (appearOnce == "true")
            {
                // 获取该Group类型结点所属的MOType结点的Xpath
                groupMOtypeXpath = getGroupBelongMotypeXpath(treeNodeID);
            }

            if (null != fromWin)
            {
                // 将消息路由到主窗体，添加右侧界面的表格
                var queryCondition = typeof (condition) != "undefined" ? condition : "";
                var fileName = "treeinfo:" + pnpForm.deviceType + "_" + pnpForm.deviceVersion + "_treeinfo";
                fromWin
                        .pub_addFeatureViewWithCondition(domainMap[treeNodeID], treeNodeID,parentNodeTexts, null, fileName,
                                isFeatureNode, "query", queryCondition, groupMOtypeXpath, appearOnce, deviceVersion,
                                deviceType);
            }
        }
        else if (nodeType == "URL")
        {
            var title = F1HelpUtil.getF1HelpID("pannel");
            F1HelpUtil.resetF1PageTitle(title);
//            changeMainFrameTitle("pannel");

            var nodeID = node.nodeID;
            var nodeText = nodeID.split("]");
            var paneInfo = nodeText[nodeText.length - 1].split("@");
            var url = paneInfo[paneInfo.length - 1];

            var title = Resource.getTreeInfoResource(paneInfo[paneInfo.length - 2] + Constants.SUFFIX_D);

            if (null != fromWin)
            {
                // 将消息路由到主窗体，添加右侧设备面板界面
                 logger.log("enter setTreeSelectedNode pub_addDevicePanelView");
                // fromWin.pub_addDevicePanelView(deviceIP,deviceType,deviceVersion,isDenpence,resID,url,title);
                window.document.title = "panel";
                fromWin.pub_addDevicePanelView(treeNodeID, deviceType, deviceVersion, CommonUtil.addRootPathToPrefix(url), title);
            }
        }
        else if (nodeType == "CUSTOMURL")
        {
            var title = F1HelpUtil.getF1HelpID("root");
            F1HelpUtil.resetF1PageTitle(title);
//            changeMainFrameTitle("root");

            var nodeID = node.nodeID;
            var nodeText = nodeID.split("]");
            var paneInfo = nodeText[nodeText.length - 1].split("@");
            var url = paneInfo[paneInfo.length - 1];

            var title = Resource.getTreeInfoResource(paneInfo[paneInfo.length - 1] + Constants.SUFFIX_D);

            if (null != fromWin)
            {
                logger.log("enter setTreeSelectedNode pub_addDevicePanelView");
                window.document.title = "customurl";
                fromWin.pub_addCustomUrlView(treeNodeID, deviceType, deviceVersion, CommonUtil.addRootPathToPrefix(url), title);
            }
        }    
        else if (nodeType == "FEATURE")
        {
            nodeVersion = "";
            isFeatureNode = false;

            if ("true" == isOffline)
            {
                if (null != fromWin)
                {
                    // 将消息路由到主窗体，添加右侧界面的表格

                    var featureForms = getFeatureForms(treeNodeID, nodeType);
                    fromWin.pub_addMultiFeatureView(featureForms, title);
                }
            }

        }
        else if (nodeType == "MANAGER")
        {
            nodeVersion = "";
            isFeatureNode = false;

            if ("true" == isOffline)
            {
                if (null != fromWin)
                {
                    // 将消息路由到主窗体，添加右侧界面的表格
                    var featureForms = getFeatureForms(treeNodeID, nodeType);
                    fromWin.pub_addMultiFeatureView(featureForms, title);
                }
            }
        }
    }
}

function getFeatureForms(nodeID, type)
{
    var featureForms = [];
    if (type == "FEATURE")
    {
        // 特性节点
        putFeatutreInfoMap(nodeID, featureForms);
    }
    else
    {
        // 管理节点和根节点
        var featureNodeIds = tree.getChildNodeIds(nodeID);

        for ( var i = 0; i < featureNodeIds.length; i++)
        {
            var featureNodeId = featureNodeIds[i];
            putFeatutreInfoMap(featureNodeId, featureForms);
        }
    }
    return featureForms;
}

function putFeatutreInfoMap(nodeID, featureForms)
{
    // 自身是特性节点
    if (isFeatureNode(nodeID))
    {
        var featureForm = new FeatureForm();
        featureForm.featureName = featureNamesMap.get(nodeID);
        featureForm.domain = domainMap[nodeID];
        featureForms.push(featureForm);
        // featureNamesMap.get(nodeID));
        return;
    }

    // 获取子
    var featureNodeIds = tree.getChildNodeIds(nodeID);

    for ( var i = 0; i < featureNodeIds.length; i++)
    {
        var featureNodeId = featureNodeIds[i];
        putFeatutreInfoMap(featureNodeId, featureForms);
    }
}
function isFeatureNode(nodeId)
{
    var featureName = featureNamesMap.get(nodeId);
    if (null != featureName)
    {
        return true;
    }
    return false;
}

/**
 * 获取content类型的结点在资源文件中的key
 * 
 * @param nodeID
 * @return
 */
function getContentKey(nodeID, nodeType)
{
    var messageTooltip = "";
    var nodeText = nodeID.split("]");
    if ("CONTENT" == nodeType)
    {
        if (nodeText.length > 1)
        {
            messageTooltip = Resource.getTreeInfoResource(nodeText[nodeText.length - 1] + Constants.SUFFIX_T);
        }
        else if (nodeText.length == 1)
        {
            messageTooltip = Resource.getTreeInfoResource(nodeID + Constants.SUFFIX_T);
        }
    }
    else if ("URL" == nodeType)
    {
        var paneInfo = nodeText[nodeText.length - 1].split("@");
        messageTooltip = Resource.getTreeInfoResource(paneInfo[paneInfo.length - 2] + Constants.SUFFIX_T);
    }
    else if ("FEATURE" == nodeType)
    {
        if (nodeText.length > 1)
        {
            messageTooltip = Resource.getTreeInfoResource(nodeText[nodeText.length - 1] + Constants.SUFFIX_T);
        }
        else if (nodeText.length == 1)
        {
            messageTooltip = Resource.getTreeInfoResource(nodeID + Constants.SUFFIX_T);
        }
    }
    return messageTooltip;
}

/**
 * 将树全部展开
 */
function onExpand()
{
	if(!g_hasExpandAll)
    {
        for(var index in g_treeNodes)
        {
            //表示未展开过
            if(null == g_treeNodeStatus[index]) 
            {
                addFunctionTreeNodes(index, g_treeNodes[index]);
            }
        }
        
        g_hasExpandAll = true;
    }
    
    if(tree.hasNode(Constants.ADMINTREEROOTID))
    {
    	if(g_adminTreeData._isAdminTreeLoaded)
    	{    		
	    	addAllAdminTreeNodes();	    	
    	}
    	else
    	{
    		g_adminTreeData._currentOperType = AdminTreeOperType.EXPANDALL;
    		requestAdminTreeDatas();
    	}
    }
    else
    {
	    expandAllNodesAfterLoaded();
    }
}

/**
 * 展开树上全部结点
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 */
function expandAllNodesAfterLoaded()
{
	tree.expandAll();
    setAllTreeNodeImage(Constants.FUNCTREEROOTID);
    if(tree.hasNode(Constants.ADMINTREEROOTID))
    {
	    setAllTreeNodeImage(Constants.ADMINTREEROOTID);
    }

    tree.setCurrentSelection(selectedNodeID);
}

/**
 * 将树全部收缩
 */
function onCollapse()
{
    tree.expandAll();
    collapseNode(Constants.FUNCTREEROOTID);
    setAllTreeNodeImage(Constants.FUNCTREEROOTID);
    if(tree.hasNode(Constants.ADMINTREEROOTID))
    {
	     collapseNode(Constants.ADMINTREEROOTID);
	     setAllTreeNodeImage(Constants.ADMINTREEROOTID);
    }
}

/**
 * 收缩树上指定结点及该结点下所有结点
 * 
 * @param node
 * @return
 */
function collapseNode(node)
{
    var nodes = tree.getChildNodeIds(node);
    for ( var i = 0; i < nodes.length; i++)
    {
        collapseNode(nodes[i]);
    }
    tree.collapseNode(node);
}

/**
 * 设置树上所有结点的图片
 * 
 * @param nodeID
 * @return
 */
function setAllTreeNodeImage(nodeID)
{
    dealNodeImage(nodeID);
    var nodes = tree.getChildNodeIds(nodeID);
    for ( var i = 0; i < nodes.length; i++)
    {
        setAllTreeNodeImage(nodes[i]);
    }
}

/**
 * 设置某个结点及其所有父结点的图片
 * 
 * @return
 */
function setNodeImagebyID(nodeID)
{
    dealParentNodeImage(nodeID);
}

/**
 * 设置指定结点及其所有父结点的图片
 * 
 * @param nodeID
 * @return
 */
function dealParentNodeImage(nodeID)
{
    dealNodeImage(nodeID);
    var parentID = tree.getParentNodeId(nodeID);
    if (parentID == Constants.FUNCTREEROOTID || parentID == Constants.ADMINTREEROOTID)
    {
        dealNodeImage(parentID);
    }
    else
    {
        dealParentNodeImage(parentID);
    }
}

/**
 * 捕获联想框中的回车事件
 * 
 * @return
 */
function doKeyUp(evt)
{
    if (evt.keyCode == Event.KEY_RETURN)
    {
        querySearchNode(evt);
    }
}

/**
 * 双击树上结点时展开该结点
 * 
 * @param evt
 * @return
 */
function doDBClick(evt)
{
    if (tree.isNodeEnableSelected(evt.id))
    {
        return;
    }
    if (tree.isExpanded(evt.id))
    {
        tree.collapseNode(evt.id);
    }
    else
    {
    	loadTreeNodes(evt.id);        
        tree.expandNode(evt.id);
    }
    dealNodeImage(evt.id);
}

/**
 * 联系框中的过滤事件处理
 */
function doFilter()
{
    // 清空联想框中下拉框中的文本信息
    suggestText.removeAll();

    // 根据输入的内容进行过滤后的数组
    if ("" == suggestText.getText())
    {
        return;
    }
 	filterContent();    
}

/**
 * 自定义联想框中的过滤操作
 * 
 * @param filterText 过滤内容
 * @return
 */
function filterContent()
{
    //获取资源信息
    if(null == treeNodeArrary)
    {
        treeNodeArrary = [];
        //如果存在管理员功能树才解析
        if(tree.hasNode(Constants.ADMINTREEROOTID))
        {        	
	        //处理管理员功能树
	       	if(!g_adminTreeData._isAdminTreeLoaded)
			{
				g_adminTreeData._currentOperType = AdminTreeOperType.FILTER;
				requestAdminTreeDatas();
				return;
			}
			getAdminTreeTextArray();
        }
        getFuncTreeTextArray();
    }
    setMatchsToSuggestText();    
}

/**
 * 获取功能树结点资源，添加到treeNodeArrary中
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 */
function getFuncTreeTextArray()
{
	for(var parentId in g_treeNodes)
    {
        var childNodes = g_treeNodes[parentId];
        for(var index in childNodes)
        {
            if ((childNodes[index].nodeType == "CONTENT" || childNodes[index].nodeType == "URL") && (!isFuncTreeNodeCut(childNodes[index])))
            {
                var node = getNodeResId(childNodes[index]);
                treeNodeArrary[childNodes[index].nodeID] = Resource.getTreeInfoResource(node.resNodeId + Constants.SUFFIX_D);
            }
        }
    }
}

/**
 * 获取管理员功能树结点资源，添加到treeNodeArrary中
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 */
function getAdminTreeTextArray()
{
	var cutNodeIdLst = [];
	for(var parentId in g_adminTreeData._adminTreeNodes)
    {
        var childNodes = g_adminTreeData._adminTreeNodes[parentId];
        
        for(var index in childNodes)
        {
	    	//如果父结点被裁减，子孙结点不需要考虑,主要是解决裁减PR管理员功能树或LR管理员功能树
    	   if(CommonArray.contains(cutNodeIdLst, parentId) || isAdminTreeNodeCut(parentId, childNodes[index]))
	       {
	       	    cutNodeIdLst.push(childNodes[index].nodeID);
	        	continue;
	       }
            if (childNodes[index].nodeType == "CONTENT")
            {
            	var node = getNodeResId(childNodes[index]);
                treeNodeArrary[childNodes[index].nodeID] = Resource.getTreeInfoResource(node.resNodeId + Constants.SUFFIX_D);
            }
        }
    }
}

/**
 * 添加过滤后的资源到联想框中
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 */
function setMatchsToSuggestText()
{
	matchNodeIDArray = [];
	var filterArray = [];
	var filterNum = 0;
    var filterLowText = suggestText.getText().toLowerCase();
    
    for(var index in treeNodeArrary)
    {
    	var filterText = treeNodeArrary[index];
    	if (filterText.toLowerCase().indexOf(filterLowText) != -1)
        {
            filterArray[filterNum] = filterText;
            matchNodeIDArray[filterNum] = index;
            filterNum++;
        }
    }
    
    // 将过滤后的文本内容添加到联想框中
    suggestText.setItems(filterArray);
}

/**
 * 联想框的下拉框关闭时的处理事件
 */
function doCloseUp(evt)
{
    var curId = tree.getCurrentSelection();
    if (curId == selectedNodeID)
    {
        return;
    }
    else
    {
        querySearchNode(evt);
    }

}

/**
 * 搜索树上的结点，搜索到之后就选中该结点并加载对应的特性Tab页
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-7-15
 * @param evt
 * @return
 */
function querySearchNode(evt)
{
	var index = 0;
	var selTextNodeID = null;
	if(null!= evt.target.isSelectListItem && evt.target.isSelectListItem)
	{
		//为了可以定位重复text使用了jse内部数据结构，后续要提接口修改
		var items = evt.target.items;
		var curID = evt.target._list.curSelection;
		for(var id in items)
		{
			var text = treeNodeArrary[matchNodeIDArray[index]];
			if(id == curID && items[id]== text)
			{
				selTextNodeID = matchNodeIDArray[index];
				break;
			}
			index++;
		}
	}
	else
	{
		for(var id in treeNodeArrary)
		{
			if(suggestText.getText() == treeNodeArrary[id])
			{
				selTextNodeID = id;
				break;
			}
		}
	}
	
    // 选中树上结点
	if(null != selTextNodeID)
	{		
	    loadSpeicalFeatureNode(selTextNodeID);
	    tree.expandNode(tree.getParentNodeId(selTextNodeID));
	    tree.setCurrentSelection(selTextNodeID);
	    setNodeImagebyID(selTextNodeID);
	
	    // 弹出对应的特性Tab页
	    setTreeSelectedNode(selTextNodeID);
	}
}

/**
 * 选择特定的节点
 */
function selectSpecicalNode(selNodeID) 
{
    if(selNodeID == tree.getCurrentSelection())
    {
        return;
    }
    
    // 选中树上结点
    if(null != selNodeID)
    {       
        loadSpeicalFeatureNode(selNodeID);
        tree.expandNode(tree.getParentNodeId(selNodeID));
        tree.setCurrentSelection(selNodeID);
        setNodeImagebyID(selNodeID);
    
        // 弹出对应的特性Tab页
        setTreeSelectedNode(selNodeID); 
    }
}

/**
 * 设置树上的当前选中结点
 */
function setTreeNode(id)
{
    selectedNodeID = id;
    tree.setCurrentSelection(id);
    setNodeImagebyID(id);
}

function getFeatureArray()
{
    return featureArray;
}

/**
 * 将当前选中设置为设备面板,供集成使用
 * 
 * @return
 */
function pub_setCurSelDevicePanel()
{
    var curId = tree.getCurrentSelection();
    if (curId != devicePanelID)
    {
        // 如果当前不是设备面板页面，切换页面
        tree.setCurrentSelection(devicePanelID);
        selectedNodeID = devicePanelID;
        setNodeImagebyID(devicePanelID);

        setTreeSelectedNode(devicePanelID);
    }

    // 设置设备面板页面的resid
    fromWin.pub_setPanelResID();

}

/**
 * 设置板颜色
 * 
 * @param color
 * @return
 */
function pub_setBoardNormalColor(color)
{
    var curId = tree.getCurrentSelection();
    if (curId == devicePanelID)
    {
        // 如果当前不是设备面板页面，切换页面
        fromWin.pub_setPanelBoardNormalColor(color);
    }
}

/**
 * 将当前选中设置为故障管理的某个特性子节点
 * 
 * @return
 */
function pub_setCurSelFaultItem(faultItem, condition)
{
    loadSpeicalFeatureNode(faultItem);
    
    tree.setCurrentSelection(faultItem);
    tree.expandNode(tree.getParentNodeId(faultItem));
    setTreeSelectedNode(faultItem, condition);
}

/**
 * 加载制定的特性节点接口（异步加载使用）
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-6-30
 * @param nodeId 节点id
 */
function loadSpeicalFeatureNode(nodeId)
{
    var isAdminTreeNode = isAdminTreeNodeId(nodeId);
    var parentIds = searchUnloadParentNode(nodeId, isAdminTreeNode);
    
    for(var i = parentIds.length - 1; i >= 0; i--)
    {
    	if(isAdminTreeNode)
    	{
    		g_adminTreeData._expandNodeId = parentIds[i];
    		addAdminTreeNode(false);
    	}
    	else
    	{
	    	//普通功能树结点,从祖先开始添加
	        addFunctionTreeNodes(parentIds[i], g_treeNodes[parentIds[i]]);
	        g_treeNodeStatus[parentIds[i]] = true;
    	}
    }
}



/**
 * 是否为管理员功能树结点
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 */
function isAdminTreeNodeId(nodeId)
{
	return nodeId.indexOf(Constants._PREFIX) == 0;
}

/**
 * 查找制定节点的未加载的父节点信息,顺序是从子孙到祖先
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2011-6-29
 * @param nodeId 节点id
 * @return 未加载的父节点信息
 */
function searchUnloadParentNode(nodeId, isAdminTreeNode)
{
    var parentIds = [];

    do
    {
    	var parentId = isAdminTreeNode ? g_adminTreeData._adminTreeNodeParentIDs[nodeId] : g_treeNodeParentIDs[nodeId];
    	if(null == parentId)
    	{
    		break;    		
    	}
    	var nodeStatus = isAdminTreeNode ? g_adminTreeData._adminTreeNodeStatus[parentId] : g_treeNodeStatus[parentId];
    	if(null == nodeStatus)
    	{
    		parentIds.push(parentId);
            nodeId = parentId;
    	}
    	else
    	{
    		break;
    	}        
    }while(true)
        
    return parentIds;
    
}


/**
 * 集成情况下，对于面板节点，修改主界面的title，响应F1
 */
//function changeMainFrameTitle(title)
//{
//    var parentWin = window.parent;
//    if (parentWin.isWorkspace == "true")
//    {
//        return;
//    }
//    var independFlag = jse.topWin.independence;
//    if ("undefined" != typeof (independFlag) && independFlag == "false")
//    {
//        var titlePrefix;
//        switch(moduleName)
//        {
//            case ModuleName.V8PTN:
//            {
//                titlePrefix = "ptn79v8";
//            }
//            case 
//            {
//                titlePrefix = "vmf.";
//            }
//            default:
//            {
//                titlePrefix = "vmf.";
//            }
//        }
//        
//        jse.topWin.document.title = titlePrefix + "nemg." + title;
//    }
//}

/**
 * 集成情况下，切换到非面板节点，恢复主界面的title，响应F1
 */
//function resetMainFrameTitle()
//{
//    var parentWin = window.parent;
//    if (parentWin.isWorkspace == "true")
//    {
//        return;
//    }
//    var independFlag = jse.topWin.independence;
//    if ("undefined" != typeof (independFlag) && independFlag == "false")
//    {
//        jse.topWin.document.title = "vmf.nemg.root";
//    }
//}

/**
 * 管理员树数据结构
 * 
 * @author z00133566
 * @since iManager U2000 V1R7,2011-11-24
 */
function AdminTreeData()
{
	/**
	 * adminTree数据是否已加载
	 */
	this._isAdminTreeLoaded = false;

	/**
	 * 存放节点的展开状态
	 */
	this._adminTreeNodeStatus = [];
	
	/**
	 * 存放树节点信息
	 */
	this._adminTreeNodes = [];
	
	/**
	 * 存放结点的父结点ID，key为结点ID，value为父结点ID
	 */
	this._adminTreeNodeParentIDs = [];
	
	/**
	 * 是否全部展开过
	 */
	this._adminHasExpandAll = false;
	
	/**
	 * 展开结点ID
	 */
	this._expandNodeId = null;
	
	/**
	 * 当前操作类型
	 */
	this._currentOperType = null;
	
	/**
	 * 管理员功能树文件是否存在
	 */
	this._isAdminTreeFileExist = false;
	
}

/**
 * 常量引用表
 */
var Constants = new Constants();

/**
 * 常量列表
 */
function Constants()
{
	/**
	 * 普通功能树的根结点的ID
	 */
	this.FUNCTREEROOTID = "0";
	
	/**
	 * 管理员功能树的根结点的ID
	 */
	this.ADMINTREEROOTID = "admin;0";
	
	/**
	 * 后缀
	 */
	this.SUFFIX_D = "_d";
	
	/**
	 * 后缀
	 */
	this.SUFFIX_T = "_t";
	
	/**
 	 * 字符串"-",用于参数传递时的title中用到的分隔符
 	 */
	this.TIELESEPRATOR = "-";
	
	/**
	 * admin树前缀 
	 */
	this._PREFIX = "admin;";
}

/**
 * 管理员功能树类型
 */
var AdminTreeType =
{
	PRADMIN : "PR_ADMIN",
	LRADMIN : "LR_ADMIN"
}

/**
 * 实例类型
 */
var InstanceType = 
{
	COMMON : "common",
	ADMIN : "admin",
	ANY : "any"
}

/**
 * 操作管理员功能树类型
 */
var AdminTreeOperType =
{
    EXPAND :"expand",
    EXPANDALL :"expandAll",
    FILTER :"filter"
}

Event.observe(window, "load", init);