jse.require("jse.widget.dialog");

/**
 * 存放List控件的对象
 */
var listContent = null;

var updatedContent = null;

/**
 * 主窗体对象
 */
var fromWin = null;

/**
 * 保存List控件中所添加的checkbox的个数
 */
var checkNumber = null;

/**
 * 保存“全选”checkbox控件的对象
 */
var allCheck = null;

/**
 * 保存不更新对话框对象
 */
var noUpdatingDialog = null;

/**
 * 保存List控件中checkbox的所有ID
 */
var idArray = null;

/**
 * 保存传进来的参数的Document对象
 */
var docFile = null;

/**
 * 从docFile中获取到的file标签的对象
 */
var files = null;

/**
 * 保存不完全更新对话框对象
 */
var noAllUpdatingDialog = null;

/**
 * 等待更新对话框对象
 */
var waitingDialog = null;

/**
 * List控件中被选中的checkbox对象的所有ID
 */
var itemIds = null;

/**
 * 根据用户选中的checkbox对象所得到的需要更新的文件列表数目，需要将该参数传到后台去
 */
var updatingFileList = null;

/**
 * 对话框宽度
 */
var DAILOG_WIDTH = 800;

/**
 * 对话框高度
 */
var DAILOG_HEIGHT = 180;

/**
 * 失败提示对话框对象
 */
var failDialog = null;

/**
 * 保存更新后从后台返回的文本的DOM对象
 */
var doc = null;

/**
 * 保存更新后从后台返回的文本对象
 */
var textInfo = null;

/**
 * 中英文资源显示时后缀
 */
var d = "_d";

/**
 * 中英文资源tooltips时后缀
 */
var t = "_t";

/**
 * 中英文资源前缀
 */
var pkgsinfo = "pkgsinfo.";
/**
 * 警告对话框
 */
var vmtwarning = null;
/**
 * 错误对话框
 */
var devErrorDlg = null;

/**
 * 更新按钮控件
 */
var btnUpdate = null;

var windowFlag = null;

var signalMap =
{
    on_load_ui :doLoad,
    doOK :doOK,
    doCancel :doCancel,
    doAllChange :doAllChange
};

/**
 * 初始化加载xui文件，并向Label控件和List控件中添加数据
 * 
 * @return
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/capabilitymgr/devsuppkg/devsuppkg.xui", signalMap);
    window.document.onkeydown = KeyDown;

    listContent = window.xui.getWidget("List2");
    updatedContent = window.xui.getWidget("List22");

    info = window.parent.pub_getPkgInfo();

    // 初始化界面中的List中的内容
    initList(info);

    // 更新按钮
    btnUpdate = window.xui.getWidget("btnOK");

    // 设置List中复选框的事件处理
    listContent.onchecked = function(evt)
    {
        allCheck = window.xui.getWidget("CheckBox2");
        itemIds = listContent.getChecked();

        if (itemIds.length == checkNumber)
        {
            allCheck.setChecked(true);
            btnUpdate.setEnabled(true);
        }
        else if ((itemIds.length < checkNumber) && (itemIds.length > 0))
        {
            allCheck.setChecked(false);
            btnUpdate.setEnabled(true);
        }
        else if (itemIds.length == 0)
        {
            allCheck.setChecked(false);
            btnUpdate.setEnabled(false);
        }
    }

    setAllCheckTrueState();
}

/**
 * 初始加载数据
 * 
 * @return
 */
function doLoad()
{
    fromWin = jse.getFromWin();
}

function initList(info)
{
    docFile = jse.loadXML(info);

    // 向Label中添加数据
    var messageNode = jse.selectSingleNode("/response/data/message", docFile);
    var messageValue = messageNode.getAttribute("value");
    var messageInfo = null;
    if (messageValue == "update")
    {
        messageInfo = jse.getI18nValue("qat:public:", "label.devsup" + d);
    }
    else if (messageValue == "fail")
    {
        messageInfo = jse.getI18nValue("qat:public:", "label.updatefail" + d);
    }
    var labelContent = window.xui.getWidget("Label1");
    labelContent.setText(messageInfo);

    // 取出中英文资源对应的文件名
    versionNode = jse.selectSingleNode("/response/data/resFileName", docFile);
    versionValue = versionNode.getAttribute("value");
    versionInfo = "pkgsinfo:" + versionValue;

    // 向未更新支持包的Tab页中的List添加复选框按钮
    checkNumber = 0;
    idArray = new Array();

    files = jse.selectNodes("//failurefile", docFile);

    var fileIndex = 0;
    var fileSize = files.length;
    checkNumber = fileSize;
    for (; fileIndex < fileSize; fileIndex++)
    {
        var file = files[fileIndex];
        var fileName = file.getAttribute("name");
        var filesNodeText = jse.getI18nValue(versionInfo, "pkgsinfo." + fileName + d);
        var tooltipsText = jse.getI18nValue(versionInfo, "pkgsinfo." + fileName + t);

        var updateFlag = file.getAttribute("defaultUpdateFalg");

        listContent.addItem(fileName,
        {
            text :filesNodeText,
            tooltip :tooltipsText
        });
        if (updateFlag == "true")
        {
            listContent.setItemEnabled(fileName, false);
        }
        idArray[fileIndex] = fileName;
    }

    // 向已更新支持包的Tab页中的Lable中添加内容
    var objNodeFile = jse.selectSingleNode("/response/data/succeedFileNumber", docFile);
    var succeedNum = objNodeFile.getAttribute("value");
    var updatedMessage = null;
    var updatedLabelContent = window.xui.getWidget("Label21");
    if (0 == succeedNum)
    {
        updatedMessage = jse.getI18nValue("qat:public:", "label.nosuppkg" + d);
        updatedLabelContent.setText(updatedMessage);
    }
    else
    {
        updatedMessage = jse.getI18nValue("qat:public:", "label.updatedsuppkg" + d);
        updatedLabelContent.setText(updatedMessage);

        // 向已更新支持包的Tab页中的List添加复选框按钮
        var succeedFiles = jse.selectNodes("//succeedfile", docFile);
        var succeedIndex = 0;
        var succeedSize = succeedFiles.length;
        for (; succeedIndex < succeedSize; succeedIndex++)
        {
            var succeedFile = succeedFiles[succeedIndex];
            var succeedFileName = succeedFile.getAttribute("name");
            var succeedFileNodeText = jse.getI18nValue(versionInfo, "pkgsinfo." + succeedFileName + d);
            var tooltipsText = jse.getI18nValue(versionInfo, "pkgsinfo." + succeedFileName + t);
            updatedContent.addItem(succeedFileName,
            {
                text :succeedFileNodeText,
                tooltip :tooltipsText
            });
        }
    }
}

/**
 * 用户点击“取消”按钮时的处理事件
 * 
 * @return
 */
function doCancel()
{
    pub_showNoUpdatingDialog()
}

/**
 * 用户点击“确定”按钮时的处理事件
 * 
 * @return
 */
function doOK()
{
    itemIds = listContent.getChecked();

    if (itemIds.length == checkNumber)
    {
        // 处理用户的更新请求
        pub_doUpdating();

    }
    else if ((itemIds.length < checkNumber) && (itemIds.length > 0))
    {
        // 当用户只选择了部分文件时弹出的提示对话框
        pub_showNoAllUpdatingDialog();

    }
    else if (itemIds.length == 0)
    {
        // 当用户没有选择文件时弹出的提示对话框
        pub_showNoUpdatingDialog();
    }

}

/**
 * 当用户只选择了部分文件时弹出的提示对话框
 * 
 * @return
 */
function pub_showNoAllUpdatingDialog()
{
    // 当用户只选择了部分文件时弹出的提示对话框
    var notAllUpdateDialogTip = jse.getI18nValue("qat:public", "dialog.prompt_d");
    var content = jse.getI18nValue("qat:public", "label.partupdate_d");

    // 当用户只选择了部分文件时弹出的提示对话框
    var width = 400;
    var height = width * 0.4;
    VMTWarning(content, pub_doPartUpdating, width, height, notAllUpdateDialogTip);
}

/**
 * 当用户没有选择文件时弹出的提示对话框
 */
function pub_showNoUpdatingDialog()
{
    var noUpdateDialogTip = jse.getI18nValue("qat:public", "dialog.prompt_d");
    var content = jse.getI18nValue("qat:public", "label.cancelupdate_d");

    // 当用户没有选择了部分文件时弹出的提示对话框
    var width = 400;
    var height = width * 0.4;
    VMTWarning(content, pub_closeNoUpdatingDialog, width, height, noUpdateDialogTip);

}

/**
 * “全选”的checkbox的事件处理
 * 
 * @return
 */
function doAllChange()
{
    var ids = null;
    var isUpdateEnable = true;
    var allCheck = window.xui.getWidget("CheckBox2");
    if (allCheck.isChecked())
    {
        for ( var j = 0; j < idArray.length; j++)
        {
            var id = idArray[j];
            listContent.setItemChecked(id, true);
        }
        isUpdateEnable = true;
    }
    else
    {
        listContent.clearChecked();
        isUpdateEnable = false;
    }

    // 设置“更新”按钮状态
    btnUpdate.setEnabled(isUpdateEnable);
}

/**
 * 当用户选择更新部分支持包时处理用户的更新请求
 */
function pub_doPartUpdating()
{
    // 向后台发请求进行文件更新的处理
    // 计算需要更新的文件
    updating();
}

/**
 * 处理用户的更新请求
 */
function pub_doUpdating()
{
    // 先测试一下后台服务是否已停止 ，如果未停止需要更新支持包
    testServerState("updating();");

}

/**
 * 更新选中的支持包 向后台发请求进行文件更新的处理，计算需要更新的文件
 * 
 * @return
 */
function updating()
{
    windowFlag = fromWin.pub_getWindowTag();
    if (windowFlag == "deviceTree")
    {
        fromWin.pub_setUpdateTag();
        fromWin.pub_clearVRStatusInfo();
    }

    // 向后台发请求进行文件更新的处理
    // 计算需要更新的文件
    updatingFileList = "";
    var index = 0;
    var length = itemIds.length;
    for (; index < length; index++)
    {
        var fileItem = itemIds[index];
        var fileNode = jse.selectSingleNode("//failurefile[@name='" + fileItem + "']", docFile);
        var filePath = fileNode.getAttribute("value");
        updatingFileList = updatingFileList + "<file>" + fileItem + "," + filePath;
    }

    // 弹出等待更新的对话框，并向后台发出更新请求
    updateFile(updatingFileList);
}

/**
 * 弹出等待更新的对话框，并向后台发出更新请求
 */
function updateFile(fileList)
{
    // 弹出等待更新的对话框
    var waitingDialogTip = jse.getI18nValue("qat:public:", "dialog.update_d");
    var message = jse.getI18nValue("qat:public","label.wait_d");

    if (null == waitingDialog)
    {
        var length = 400;
        if(jse.topWin.lang == "en_US")
        {
            length = 650;
        }
        
        waitingDialog = CommonDlgReq.openWaitDialogWithPos(length,200,waitingDialogTip,message,"waiting_bar",null,null);
    }

    waitingDialog.show();

    // 向后台发出更新请求
    var req = jse.RpcRequest
            .create(handleEncodingUrl(CommonUtil.getRootPath() + "/vmt/ct/capability/DevSupPkgAction.do?methodID=updatesuppkg"
                    + "&updatingFileList=" + fileList + "&windowTag=" + windowFlag));

    req.invoke(handleResult, [ "devSupPkgHandler(request);" ]);

}

/**
 * 当请求返回时，回调函数处理返回的数据
 */
function devSupPkgHandler(request)
{
    waitingDialog.hide();
    // 获取请求过来的文本内容
    var text = request.responseText;

    var responseIndex = text.indexOf("<response>");

    var responsetext = text.substring(responseIndex, text.length);

    // 将 xml字符串解析为 DOM 对象
    doc = jse.loadXML(responsetext);

    // 获取节点
    var node = jse.selectSingleNode("/response/operResultType", doc);

    // 获取节点 resultType 属性值
    var resultType = node.getAttribute("resultType");
    textInfo = text;

    if ("OPER_OK" == resultType)
    {
        // setTimeout("closewaitingDialog()",0);
        closewaitingDialog();
    }
    else
    {
        VMTError("win.doCloseErrorDlg();");
    }
}

function doCloseErrorDlg(evt)
{
    listContent.removeAll();
    updatedContent.removeAll();
    initList(textInfo);
    setAllCheckTrueState();

    return true;
}

/**
 * 获取错误对话框中的Label值
 * 
 * @return
 */
function getSupPkgLabelText()
{
    var rootNodeText = jse.getI18nValue("qat:public", "label.update_error_d");
    return rootNodeText;
}

/**
 * 错误对话框的“关闭”按钮事件处理
 * 
 * @return
 */
function pub_errorDlgClose()
{
    devErrorDlg.hide();

    // 弹出含有失败文件列表的对话框，供用户重新选择
    listContent.removeAll();
    updatedContent.removeAll();
    initList(textInfo);
    setAllCheckTrueState();

    // 关闭错误对话框
    devErrorDlg.dispose();
    devErrorDlg = null;

}

function setAllCheckTrueState()
{
    var allChecks = window.xui.getWidget("CheckBox2");
    allChecks.setChecked(true);
    doAllChange();
}
/**
 * 设置错误对话框大小
 * 
 * @param width 对话框宽度
 * @param height 对话框高度
 */
function setPreferSize(width, height)
{
    devErrorDlg.setPreferSize(width, height);
}

/**
 * 关闭等待更新的对话框,弹出更新成功的提示对话框
 * 
 * @return
 */
function closewaitingDialog()
{
    // 关闭等待更新的对话框
    // pub_closeWaitingDialog();
    waitingDialog.dispose();
    waitingDialog = null;

    // 弹出更新成功的提示对话框
    fromWin.pub_showUpdateSuccessDialog();

    jse.closeSelfView();
}

/**
 * 关闭不更新时弹出的对话框
 * 
 * @return
 */
function pub_closeNoUpdatingDialog()
{
    var windowFlag = fromWin.pub_getWindowTag();
    if (windowFlag == "window")
    {
        pub_addDeviceTreeList();
    }

    jse.closeSelfView();

}

/**
 * 关闭等待更新的对话框
 * 
 * @return
 */
function pub_closeWaitingDialog()
{
    waitingDialog.dispose();
    waitingDialog = null;
}

/**
 * 弹出设备树列表
 */
function pub_addDeviceTreeList()
{
    // 弹出设备树列表
    fromWin.pub_displayDeviceTree();
}

/**
 * 用户点击右上角的"关闭"时的处理
 */
function stop()
{
    jse.closeSelfView();
}

Event.observe(window, "load", init);