/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.capabilitymgr.web;

import com.huawei.vmf.common.pnp.domain.PnpForm;
import com.huawei.vmf.common.pnp.domain.PnpResult;
import com.huawei.vmf.common.pnp.service.PnpHandler;
import com.huawei.vmf.qat.capabilitymgr.functreemgr.FunctionTreeMgr;
import com.huawei.vmf.qat.common.SystemConfiguration;
import com.huawei.vmf.qat.common.check.HttpReqParaExceptionHandler;
import com.huawei.vmf.qat.common.check.HttpReqParaInvalidateException;
import com.huawei.vmf.qat.common.log.PerfLogger;
import com.huawei.vmf.qat.common.rsp.OperResult;
import com.huawei.vmf.qat.common.rsp.OperResultType;
import com.huawei.vmf.qat.security.support.DispatchAction;
import com.huawei.vmf.qat.security.support.HttpReqParaInfoEnum;
import com.huawei.vmf.qat.security.support.MethodInfo;
import com.huawei.vmf.qat.security.support.PrimaryDeviceHolder;
import com.huawei.vmf.qat.security.util.HttpReqUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;

public class FunctionTreeNavAction
extends DispatchAction {
    private static final String HANDLEFUNCTIONTREEOFFLINEREQUEST = "handleFunctionTreeOfflineRequest";
    private static final String HANDLEFUNCTIONTREEREQUEST = "handleFunctionTreeRequest";
    private static final String HANDLEADMINTREEREQUEST = "handleAdminTreeRequest";
    private static final String HANDLEFUNTIONTREE_IDENTIFIER = "functiontree";
    private static final String HANDLEADMINTREEREQUEST_IDENTIFIER = "admintree";
    private static final String HANDLEFUNTIONTREEOFFLINE_IDENTIFIER = "functiontreeoffline";
    private static final String HANDLETEMPLATETREE_IDENTIFIER = "templettree";
    private static final String HANDLETEMPLATETREEREQUEST = "handleTemplateTreeRequest";
    private FunctionTreeMgr functionTreeMgr;
    private Map<String, MethodInfo> map = new HashMap<String, MethodInfo>();
    private PnpHandler pnpHandler;

    public Map<String, MethodInfo> getMethodInfoMap() {
        return this.map;
    }

    public void handleFunctionTreeOfflineRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String isSupPartition = null;
        String deviceType = null;
        String deviceVersion = null;
        String deviceIp = null;
        String vrId = null;
        try {
            isSupPartition = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.IS_SUPPORT_PARTITION, (HttpServletRequest)request);
            deviceType = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.DEVICE_TYPE, (HttpServletRequest)request);
            deviceVersion = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.DEVICE_VERSION, (HttpServletRequest)request);
            deviceIp = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.DEVICE_IP, (HttpServletRequest)request);
            vrId = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.VR_ID, (HttpServletRequest)request);
        }
        catch (HttpReqParaInvalidateException e) {
            HttpReqParaExceptionHandler.invalidSession((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        boolean isSupportPartition = isSupPartition.equals("true");
        String neFlag = null;
        neFlag = vrId.equals("null") ? "LR" : "VR";
        OperResult<String, Void> operResult = new OperResult<String, Void>();
        PrintWriter out = response.getWriter();
        StringBuffer functionTree = new StringBuffer();
        boolean existPackage = this.pnpHandler.existPackage(deviceType, deviceVersion);
        if (!existPackage) {
            operResult.setResultType(OperResultType.OPER_NOK);
            operResult.addError(1107525800);
            out.append(operResult.toRspString());
            return;
        }
        PnpResult hasPnpPackage = this.pnpHandler.getPackage(deviceType, deviceVersion, deviceIp, SystemConfiguration.getProperty((String)"pnpVersion"));
        int hasPnpResult = hasPnpPackage.getResult();
        if (hasPnpResult != 0) {
            operResult.setResultType(OperResultType.OPER_NOK);
            operResult.addError(hasPnpResult);
            out.append(operResult.toRspString());
            return;
        }
        PnpForm pnpForm = new PnpForm(deviceType, deviceVersion, false);
        operResult = this.functionTreeMgr.getFunctionTree(pnpForm, neFlag, deviceType, deviceVersion, vrId, "true", isSupportPartition);
        functionTree.append(operResult.toRspString());
        if (OperResultType.OPER_OK == operResult.getResultType()) {
            functionTree.append("<data>");
            functionTree.append((String)operResult.getReturnObj());
            functionTree.append("</data>");
        }
        out.append(functionTree.toString());
    }

    public void handleFunctionTreeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PerfLogger.debug((String)"enter handleFunctionTreeRequest");
        String sessionID = request.getSession().getId();
        String neFlag = null;
        String neID = null;
        String isWorkSpace = null;
        String pnpDeviceType = null;
        String pnpDeviceVersion = null;
        String isCompatible = null;
        String boardCapTypes = null;
        try {
            neFlag = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.NE_NAME, (HttpServletRequest)request);
            neID = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.NE_ID, (HttpServletRequest)request);
            isWorkSpace = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.IS_WORKSPACE, (HttpServletRequest)request);
            pnpDeviceType = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.PNP_DEVICE_TYPE, (HttpServletRequest)request);
            pnpDeviceVersion = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.PNP_DEVICE_VERSION, (HttpServletRequest)request);
            isCompatible = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.IS_COMPATIBLE, (HttpServletRequest)request);
            boardCapTypes = request.getParameter("boardCapTypes");
        }
        catch (HttpReqParaInvalidateException e) {
            HttpReqParaExceptionHandler.invalidSession((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        PnpForm pnpForm = new PnpForm(pnpDeviceType, pnpDeviceVersion, Boolean.valueOf(isCompatible).booleanValue());
        OperResult<String, Void> operResult = this.functionTreeMgr.getFunctionTree(pnpForm, neFlag, sessionID, neID, isWorkSpace, PrimaryDeviceHolder.getDeviceIp(), boardCapTypes);
        PrintWriter out = response.getWriter();
        StringBuffer functionTree = new StringBuffer();
        functionTree.append(operResult.toRspString());
        if (OperResultType.OPER_OK == operResult.getResultType()) {
            functionTree.append("<data>");
            functionTree.append((String)operResult.getReturnObj());
            functionTree.append("</data>");
        }
        out.append(functionTree.toString());
        PerfLogger.debug((String)"exit handleFunctionTreeRequest");
    }

    public void handleAdminTreeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PerfLogger.debug((String)"enter handleAdminTreeRequest");
        String pnpDeviceType = null;
        String pnpDeviceVersion = null;
        String isCompatible = null;
        try {
            pnpDeviceType = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.PNP_DEVICE_TYPE, (HttpServletRequest)request);
            pnpDeviceVersion = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.PNP_DEVICE_VERSION, (HttpServletRequest)request);
            isCompatible = HttpReqUtil.getPara((HttpReqParaInfoEnum)HttpReqParaInfoEnum.IS_COMPATIBLE, (HttpServletRequest)request);
        }
        catch (HttpReqParaInvalidateException e) {
            HttpReqParaExceptionHandler.invalidSession((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        PnpForm pnpForm = new PnpForm(pnpDeviceType, pnpDeviceVersion, Boolean.valueOf(isCompatible).booleanValue());
        OperResult<String, Void> operResult = this.functionTreeMgr.getAdminTree(pnpForm);
        PrintWriter out = response.getWriter();
        StringBuffer functionTree = new StringBuffer();
        functionTree.append(operResult.toRspString());
        if (OperResultType.OPER_OK == operResult.getResultType()) {
            functionTree.append("<data>");
            functionTree.append((String)operResult.getReturnObj());
            functionTree.append("</data>");
        }
        out.append(functionTree.toString());
        PerfLogger.debug((String)"exit handleAdminTreeRequest");
    }

    public void init(BundleContext context) {
        this.functionTreeMgr = (FunctionTreeMgr)context.getService(context.getServiceReference(FunctionTreeMgr.class.getName()));
        this.pnpHandler = (PnpHandler)context.getService(context.getServiceReference(PnpHandler.class.getName()));
        this.map = new HashMap<String, MethodInfo>();
        this.map.put(HANDLEFUNTIONTREE_IDENTIFIER, new MethodInfo(HANDLEFUNCTIONTREEREQUEST, 0L));
        this.map.put(HANDLEADMINTREEREQUEST_IDENTIFIER, new MethodInfo(HANDLEADMINTREEREQUEST, 0L));
        this.map.put(HANDLETEMPLATETREE_IDENTIFIER, new MethodInfo(HANDLETEMPLATETREEREQUEST, 11544623L));
        this.map.put(HANDLEFUNTIONTREEOFFLINE_IDENTIFIER, new MethodInfo(HANDLEFUNCTIONTREEOFFLINEREQUEST, 0L));
    }

    public void setFunctionTreeMgr(FunctionTreeMgr functionTreeMgr) {
        this.functionTreeMgr = functionTreeMgr;
    }
}

