/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.capabilitymgr.util;

import com.huawei.vmf.qat.capabilitymgr.functreemgr.TreeType;
import com.huawei.vmf.qat.capabilitymgr.util.CapabilityMgrConstants;
import com.huawei.vmf.qat.common.log.RunLogger;
import java.io.File;
import org.slf4j.Logger;

public class Util {
    private static Logger logger = RunLogger.getRunLogger();

    public static String getFunctreeFilePath(String deviceType, String deviceVersion, TreeType type, String boardCapTypes) {
        String funcTreeFilePath = "";
        switch (type) {
            case WORKSPACE: {
                funcTreeFilePath = CapabilityMgrConstants.DEVICE_ROOT_PATH + File.separator + deviceType + File.separator + deviceVersion + File.separator + "workspacetree.xml";
                break;
            }
            case WINDOW: {
                funcTreeFilePath = CapabilityMgrConstants.DEVICE_ROOT_PATH + File.separator + deviceType + File.separator + deviceVersion + File.separator + "treeinfo.xml";
                break;
            }
            case ADMIN: {
                funcTreeFilePath = CapabilityMgrConstants.DEVICE_ROOT_PATH + File.separator + deviceType + File.separator + deviceVersion + File.separator + "admintreeinfo.xml";
                break;
            }
            case BOARD: {
                funcTreeFilePath = CapabilityMgrConstants.DEVICE_ROOT_PATH + File.separator + deviceType + File.separator + deviceVersion + File.separator + "boardtreeinfo.xml";
                break;
            }
            default: {
                logger.debug("no control");
            }
        }
        return funcTreeFilePath;
    }

    public static String getPafFilePath(String deviceType, String deviceVersion, String neFlag) {
        return CapabilityMgrConstants.DEVICE_ROOT_PATH + File.separator + deviceType + File.separator + deviceVersion + File.separator + "paf" + File.separator + neFlag + "paf" + ".xml";
    }

    public static String getPkgsinfoXMLPath(String deviceType, String deviceVersion) {
        return CapabilityMgrConstants.PKG_ROOT_PATH + File.separator + "device" + File.separator + deviceType + File.separator + deviceVersion + File.separator + "pkgsinfo.xml";
    }

    public static String getPkgsJarPath(String deviceType, String deviceVersion) {
        return CapabilityMgrConstants.PKG_JAR_PATH + File.separator + "device" + File.separator + deviceType + File.separator + deviceVersion + File.separator + "pkgsinfo.jar";
    }

    public static String getTreeinfoJarPath(String deviceType, String deviceVersion) {
        return CapabilityMgrConstants.PKG_JAR_PATH + File.separator + "device" + File.separator + deviceType + File.separator + deviceVersion + File.separator + "treeinfo.jar";
    }

    public static String getTreeinfoXMLPath(String deviceType, String deviceVersion) {
        return CapabilityMgrConstants.PKG_ROOT_PATH + File.separator + "device" + File.separator + deviceType + File.separator + deviceVersion + File.separator + "treeinfo.xml";
    }

    public static String getWorkspaceTreeXMLPath(String deviceType, String deviceVersion) {
        return CapabilityMgrConstants.PKG_ROOT_PATH + File.separator + deviceType + File.separator + deviceVersion + File.separator + "workspacetree.xml";
    }
}

