/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.capabilitymgr.pnpservice.impl;

import com.huawei.uflight.threadpool.ThreadPool;
import com.huawei.vmf.common.pnp.constants.PnpConstants;
import com.huawei.vmf.common.pnp.domain.PnpForm;
import com.huawei.vmf.common.pnp.domain.PnpResult;
import com.huawei.vmf.common.pnp.service.PnpHandler;
import com.huawei.vmf.extendpoint.framework.IApplyDifference;
import com.huawei.vmf.extendpoint.register.FrameExtendPointServiceMgr;
import com.huawei.vmf.qat.capabilitymgr.domain.PnpModel;
import com.huawei.vmf.qat.capabilitymgr.harddiff.HardSpecDiffMgr;
import com.huawei.vmf.qat.capabilitymgr.pnpservice.LoadPnpFinishListener;
import com.huawei.vmf.qat.capabilitymgr.pnpservice.PnpService;
import com.huawei.vmf.qat.common.SystemConfiguration;
import com.huawei.vmf.qat.common.commonutil.QatOperException;
import com.huawei.vmf.qat.common.json.JSONRPCContextHolder;
import com.huawei.vmf.qat.common.log.PerfLogger;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.common.rsp.OperResult;
import com.huawei.vmf.qat.common.rsp.OperResultType;
import com.huawei.vmf.qat.devicemgr.devinfo.DeviceInfo;
import com.huawei.vmf.qat.devicemgr.devmgr.DeviceMgr;
import com.huawei.vmf.qat.schemaprocessor.infomodel.SchemaBuilder;
import com.huawei.vmf.qat.security.support.SessionDataHolder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class PnpServiceImpl
implements PnpService {
    public static final String PRE_ANALYSE_FEATURENAMES = "preAnalyseFeatureNames";
    protected static final Logger logger = RunLogger.getRunLogger();
    private DeviceMgr deviceMgr;
    private HardSpecDiffMgr hardSpecMgr;
    private List<LoadPnpFinishListener> listenerList = new ArrayList<LoadPnpFinishListener>();
    private PnpHandler pnpHandler;
    private SchemaBuilder schemaBuilder;

    @Override
    public synchronized void addLoadPnpFinishListener(LoadPnpFinishListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    @Override
    public OperResult<PnpModel, Void> existPnpPackage(String deviceType, String deviceVersion, String deviceIp) {
        PerfLogger.debug((String)"enter existPnpPackage()");
        logger.info("existPnpPackage, deviceType={}, deviceVersion={}, deviceIp={}, HttpSessionId={}", new Object[]{deviceType, deviceVersion, deviceIp, JSONRPCContextHolder.getHttpSessionId()});
        DeviceInfo currentDeviceInfo = this.getCurrentDeviceInfo(deviceType, deviceVersion, deviceIp);
        String devType = currentDeviceInfo.getDeviceType();
        String devVersion = currentDeviceInfo.getDeviceVersion();
        boolean isExist = this.pnpHandler.existPackage(devType, devVersion);
        PnpForm pnpForm = null;
        logger.info("exit existPackage(), devType={}, devVersion={}, isExist={}", new Object[]{devType, devVersion, isExist});
        PerfLogger.debug((String)"exit existPackage()");
        if (isExist) {
            pnpForm = this.pnpHandler.getPackage(devType, devVersion, deviceIp, SystemConfiguration.getProperty((String)"pnpVersion")).getPnpForm();
            PerfLogger.debug((String)"exit getPackage()");
        }
        boolean bl = isExist = null != pnpForm;
        if (isExist) {
            try {
                this.hardSpecMgr.queryHardSpecIndexList(devType, devVersion, deviceIp);
            }
            catch (Exception e) {
                logger.error("queryHardSpecIndexList has exception", (Throwable)e);
            }
            this.procAfterLoadPnp(deviceType, deviceVersion, deviceIp);
        }
        PerfLogger.debug((String)"exit existPnpPackage()");
        return new OperResult((Object)new PnpModel(isExist, pnpForm));
    }

    public DeviceMgr getDeviceMgr() {
        return this.deviceMgr;
    }

    @Override
    public Map<String, List<String>> getDeviceTypesAndVersions() {
        return this.pnpHandler.getDeviceTypesAndVersions();
    }

    public HardSpecDiffMgr getHardSpecMgr() {
        return this.hardSpecMgr;
    }

    @Override
    public OperResult<PnpModel, String> loadPnpPackage(String deviceType, String deviceVersion, String deviceIp) {
        logger.info("loadPnpPackage, deviceType={}, deviceVersion={}, deviceIp={}, HttpSessionId={}", new Object[]{deviceType, deviceVersion, deviceIp, JSONRPCContextHolder.getHttpSessionId()});
        OperResult operResult = new OperResult();
        DeviceInfo currentDeviceInfo = this.getCurrentDeviceInfo(deviceType, deviceVersion, deviceIp);
        logger.info("getCurrentDeviceInfo finish, deviceType={}, deviceVersion={}, deviceIp={}", new Object[]{currentDeviceInfo.getDeviceType(), currentDeviceInfo.getDeviceVersion(), deviceIp});
        PnpResult pnpResult = this.pnpHandler.getPackage(currentDeviceInfo.getDeviceType(), currentDeviceInfo.getDeviceVersion(), deviceIp, SystemConfiguration.getProperty((String)"pnpVersion"));
        if (0 == pnpResult.getResult()) {
            operResult.setReturnObj((Object)new PnpModel(pnpResult.getPnpForm()));
            operResult.addError(pnpResult.getPnpForm().getCompatibleReasonId(), (Object)deviceIp, pnpResult.getReason());
            try {
                this.hardSpecMgr.queryHardSpecIndexList(deviceType, deviceVersion, deviceIp);
            }
            catch (Exception e) {
                logger.error("queryHardSpecIndexList has exception", (Throwable)e);
            }
            this.deviceMgr.updateDevInStub(deviceIp, 0, deviceType, deviceVersion);
            this.procAfterLoadPnp(deviceType, deviceVersion, deviceIp);
        } else {
            operResult.setResultType(OperResultType.OPER_NOK);
            operResult.addError(pnpResult.getResult(), (Object)deviceIp, pnpResult.getReason());
        }
        return operResult;
    }

    public void setDeviceMgr(DeviceMgr deviceMgr) {
        this.deviceMgr = deviceMgr;
    }

    public void setHardSpecMgr(HardSpecDiffMgr hardSpecMgr) {
        this.hardSpecMgr = hardSpecMgr;
    }

    public void setPnpHandler(PnpHandler pnpHandler) {
        this.pnpHandler = pnpHandler;
    }

    public void setSchemaBuilder(SchemaBuilder schemaBuilder) {
        this.schemaBuilder = schemaBuilder;
    }

    private DeviceInfo getCurrentDeviceInfo(String deviceType, String deviceVersion, String deviceIp) {
        DeviceInfo currentDeviceInfo = this.deviceMgr.getCurrentDeviceInfo(JSONRPCContextHolder.getHttpSessionId(), deviceIp);
        if (null == currentDeviceInfo) {
            currentDeviceInfo = new DeviceInfo();
            currentDeviceInfo.setDeviceType(deviceType);
            currentDeviceInfo.setDeviceVersion(deviceVersion);
        }
        return currentDeviceInfo;
    }

    private void procAfterLoadPnp(final String deviceType, final String deviceVersion, final String deviceIp) {
        IApplyDifference appDiff = (IApplyDifference)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(IApplyDifference.class);
        if (null != appDiff) {
            appDiff.procAfterLoadPnp(deviceType, deviceVersion, deviceIp);
            return;
        }
        if (SessionDataHolder.isIndependence()) {
            return;
        }
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                String[] nameArray;
                for (LoadPnpFinishListener listener : PnpServiceImpl.this.listenerList) {
                    logger.info("begin " + listener.getClass().getSimpleName() + " loadPnpFinish()");
                    listener.loadPnpFinish(deviceType, deviceVersion, deviceIp);
                    logger.info("end " + listener.getClass().getSimpleName() + " loadPnpFinish()");
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    logger.info("This err can not happen." + e);
                }
                File pnpDir = new File(PnpConstants.PNP_DIR + File.separator + deviceType + File.separator + deviceVersion + File.separator + "schema");
                if (!pnpDir.exists()) {
                    return;
                }
                for (String fatureName : nameArray = SystemConfiguration.getProperty((String)PnpServiceImpl.PRE_ANALYSE_FEATURENAMES, (String)"").split(",")) {
                    String schemaFilePath = this.getSchemaFilePath(deviceType, deviceVersion, fatureName);
                    try {
                        PnpServiceImpl.this.schemaBuilder.preLoadXSModelByThread(schemaFilePath);
                    }
                    catch (QatOperException e) {
                        logger.error("load xsd model error." + (Object)((Object)e));
                    }
                }
            }

            private String getSchemaFilePath(String deviceType2, String deviceVersion2, String featureName) {
                return this.getSchemaParentDir(deviceType2, deviceVersion2) + File.separator + featureName + ".xsd";
            }

            private String getSchemaParentDir(String deviceType2, String deviceVersion2) {
                return PnpConstants.PNP_DIR + File.separator + deviceType2 + File.separator + deviceVersion2 + File.separator + "schema";
            }
        });
    }
}

