/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.capabilitymgr.info.impl;

import com.huawei.commextend.frameutil.CommonDBInfoUtil;
import com.huawei.vmf.common.pnp.constants.PnpConstants;
import com.huawei.vmf.common.pnp.domain.PnpForm;
import com.huawei.vmf.qat.capabilitymgr.domain.PnpModel;
import com.huawei.vmf.qat.capabilitymgr.functreemgr.TreeType;
import com.huawei.vmf.qat.capabilitymgr.info.CapabilityInfoMgr;
import com.huawei.vmf.qat.capabilitymgr.info.NECapabilityInfo;
import com.huawei.vmf.qat.capabilitymgr.info.impl.NECapaInfoList;
import com.huawei.vmf.qat.capabilitymgr.pnpservice.PnpService;
import com.huawei.vmf.qat.capabilitymgr.util.Util;
import com.huawei.vmf.qat.common.SystemConfiguration;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.common.rsp.OperResult;
import com.huawei.vmf.qat.common.rsp.OperResultType;
import com.huawei.vmf.qat.common.rsp.QatOperException;
import com.huawei.vmf.qat.devicemgr.devnavigator.LRVRCapabilityMgr;
import com.huawei.vmf.qat.schemaprocessor.infomodel.CapaOperType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.FeatureCapaInfo;
import com.huawei.vmf.qat.schemaprocessor.infomodel.ValueType;
import com.huawei.vmf.qat.security.support.SessionDataHolder;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class CapabilityInfoMgrImpl
implements CapabilityInfoMgr,
LRVRCapabilityMgr {
    private static final String KEY_ISSUPPORTMULTILR = "isSupportMultiLR";
    private static final String KEY_ISSUPPORTMULTIVR = "isSupportMultiVR";
    private static Logger logger = RunLogger.getRunLogger();
    private Map<String, CapaOperType> capaOperTypeMap;
    private Map<String, NECapaInfoList> pafInfoForOfflinTeempletMap;
    private PnpService pnpService;
    private Map<String, ValueType> valueTypeMap = new HashMap<String, ValueType>();

    public CapabilityInfoMgrImpl() {
        this.valueTypeMap.put("max", ValueType.MAXVALUE);
        this.valueTypeMap.put("min", ValueType.MINVALUE);
        this.valueTypeMap.put("default", ValueType.DEFAULTVALUE);
        this.capaOperTypeMap = new HashMap<String, CapaOperType>();
        this.capaOperTypeMap.put("funcclass", CapaOperType.CLASSCTRL);
        this.capaOperTypeMap.put("funcfield", CapaOperType.PROPERTYCTRL);
        this.capaOperTypeMap.put("resfield", CapaOperType.PROPERTYVALUERANGE);
        this.capaOperTypeMap.put("resinstance", CapaOperType.CLASSINSTANCENUM);
        this.capaOperTypeMap.put("resrelation", CapaOperType.CLASSRELATIONINSTANCENUM);
        this.pafInfoForOfflinTeempletMap = new HashMap<String, NECapaInfoList>();
    }

    @Override
    public FeatureCapaInfo getFeatureLcsCapaInfo(String featureFileName, String sessionId, String neId) throws QatOperException {
        if (StringUtils.isBlank((String)sessionId) || StringUtils.isBlank((String)featureFileName)) {
            throw new IllegalArgumentException("[CapabilityInfoMgrImpl:getFeatureLcsCapaInfo]The parameter is error.");
        }
        OperResult<NECapabilityInfo, Void> operResult = this.getNELicCapa(sessionId, neId);
        OperResultType resultType = operResult.getResultType();
        if (OperResultType.OPER_OK == resultType) {
            NECapabilityInfo neCapa = (NECapabilityInfo)operResult.getReturnObj();
            return this.queryFeatureCapa(featureFileName, neCapa);
        }
        throw new QatOperException(1107525658);
    }

    @Override
    public synchronized FeatureCapaInfo getFeaturePafCapaInfo(String featureFileName, String sessionId, String neId) throws QatOperException {
        return new FeatureCapaInfo(featureFileName);
    }

    @Override
    public FeatureCapaInfo getFeaturePafForOffTmp(String featureFileName, String devType, String devVersion, String neFlag) throws QatOperException {
        String devInfo = devType + devVersion;
        NECapabilityInfo pafCapa = null;
        FeatureCapaInfo featureCapa = null;
        NECapaInfoList pafCapaList = this.pafInfoForOfflinTeempletMap.get(devInfo);
        if (null != pafCapaList && null != (pafCapa = pafCapaList.getNECapaInfo(neFlag))) {
            logger.info("get PAF succeed from memory for offline or templet!");
            featureCapa = this.queryFeatureCapa(featureFileName, pafCapa);
            return featureCapa;
        }
        pafCapa = this.getPafCapaFromFile(neFlag, "static", Util.getPafFilePath(devType, devVersion, neFlag));
        this.addCapaInfoForOfflineTmp(devInfo, pafCapa, neFlag);
        return this.queryFeatureCapa(featureFileName, pafCapa);
    }

    @Override
    public synchronized OperResult<NECapabilityInfo, Void> getNELicCapa(String sessionId, String neId) {
        OperResult operResult = new OperResult();
        operResult.setResultType(OperResultType.OPER_OK);
        operResult.setReturnObj((Object)new NECapabilityInfo());
        return operResult;
    }

    public String getPnpExistInfo(String deviceType, String deviceVersion, String deviceIp) {
        OperResult<PnpModel, Void> result = this.pnpService.existPnpPackage(deviceType, deviceVersion, deviceIp);
        PnpModel model = (PnpModel)result.getReturnObj();
        StringBuilder buf = new StringBuilder();
        buf.append("<pnpInfo");
        buf.append(" isExist=\"").append(model.isExist()).append("\"");
        PnpForm pnpForm = model.getPnpForm();
        if (null != pnpForm) {
            buf.append(" compatible=\"").append(pnpForm.isCompatible()).append("\"");
            buf.append(" compatibleReasonId=\"").append(pnpForm.getCompatibleReasonId()).append("\"");
            buf.append(" deviceType=\"").append(pnpForm.getDeviceType()).append("\"");
            buf.append(" deviceVersion=\"").append(pnpForm.getDeviceVersion()).append("\"");
        }
        buf.append("/>");
        return buf.toString();
    }

    public boolean isAdminTreeFileExist(String deviceType, String deviceVersion) {
        String adminTreeFilePath = Util.getFunctreeFilePath(deviceType, deviceVersion, TreeType.ADMIN, null);
        File xmlFile = new File(adminTreeFilePath);
        return xmlFile.exists();
    }

    public boolean isSupportMultiLR(String deviceType, String deviceVersion) {
        if (SessionDataHolder.isIndependence()) {
            return Boolean.valueOf(SystemConfiguration.getProperty((String)SystemConfiguration.IS_SUPPORT_MULTI_LR, (String)"true"));
        }
        return Boolean.valueOf(CommonDBInfoUtil.getUserCfgInfo((String)"NEMGR_VMF", (String)KEY_ISSUPPORTMULTILR));
    }

    public boolean isSupportMultiVR(String deviceType, String deviceVersion) {
        String vsFilePath = PnpConstants.PNP_DIR + File.separator + deviceType + File.separator + deviceVersion + File.separator + "schema" + File.separator + "vs.xsd";
        File vsDir = new File(vsFilePath);
        if (!vsDir.exists()) {
            logger.info("devType=" + deviceType + ",deviceVersion=" + deviceVersion + ", vs schema file in pnp package is not exist,so NE manager not support Multi VR");
            return false;
        }
        if (SessionDataHolder.isIndependence()) {
            return Boolean.valueOf(SystemConfiguration.getProperty((String)SystemConfiguration.IS_SUPPORT_MULTI_VR, (String)"true"));
        }
        return Boolean.valueOf(CommonDBInfoUtil.getUserCfgInfo((String)"NEMGR_VMF", (String)KEY_ISSUPPORTMULTIVR));
    }

    public void setPnpService(PnpService pnpService) {
        this.pnpService = pnpService;
    }

    private void addCapaInfoForOfflineTmp(String devInfo, NECapabilityInfo nePAFCapa, String neFlag) {
        NECapaInfoList neCapaInfoList = this.pafInfoForOfflinTeempletMap.get(devInfo);
        if (null != neCapaInfoList) {
            neCapaInfoList.addNECapaInfo(nePAFCapa, neFlag);
        } else {
            neCapaInfoList = new NECapaInfoList();
            neCapaInfoList.addNECapaInfo(nePAFCapa, neFlag);
            this.pafInfoForOfflinTeempletMap.put(devInfo, neCapaInfoList);
        }
    }

    private NECapabilityInfo getPafCapaFromFile(String neFlag, String capaType, String pafFilePath) throws QatOperException {
        return new NECapabilityInfo();
    }

    private FeatureCapaInfo queryFeatureCapa(String featureFileName, NECapabilityInfo pafCapa) {
        FeatureCapaInfo featureCapa = null;
        Map<String, FeatureCapaInfo> licCapaMap = pafCapa.getNECapaInfoMap();
        featureCapa = licCapaMap.containsKey(featureFileName) ? licCapaMap.get(featureFileName) : new FeatureCapaInfo(featureFileName);
        return featureCapa;
    }
}

