/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.capabilitymgr.harddiff.impl;

import com.huawei.vmf.common.pnp.constants.PnpConstants;
import com.huawei.vmf.common.pnp.domain.PnpForm;
import com.huawei.vmf.common.tool.StringUtil;
import com.huawei.vmf.qat.capabilitymgr.domain.AttributePara;
import com.huawei.vmf.qat.capabilitymgr.domain.HardSpecDiffData;
import com.huawei.vmf.qat.capabilitymgr.domain.HardSpecEntity;
import com.huawei.vmf.qat.capabilitymgr.domain.NEHardSpecIndex;
import com.huawei.vmf.qat.capabilitymgr.harddiff.HardSpecConfigInfoFactory;
import com.huawei.vmf.qat.capabilitymgr.harddiff.HardSpecDiffMgr;
import com.huawei.vmf.qat.capabilitymgr.harddiff.HardSpecIndexDataFactory;
import com.huawei.vmf.qat.common.CommonUtil;
import com.huawei.vmf.qat.common.json.JSONRPCContextHolder;
import com.huawei.vmf.qat.common.log.PerfLogger;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.common.rsp.OperResult;
import com.huawei.vmf.qat.common.rsp.OperResultType;
import com.huawei.vmf.qat.common.xpath.XpathManager;
import com.huawei.vmf.qat.devicemgr.cmdsender.CommandSender;
import com.huawei.vmf.qat.devicemgr.devmgr.DeviceMgr;
import com.huawei.vmf.qat.devicemgr.netconfmgr.NetConfManager;
import com.huawei.vmf.qat.schemaprocessor.infomodel.MOType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.Schema;
import com.huawei.vmf.qat.schemaprocessor.infomodel.SchemaBuilder;
import com.huawei.vmf.qat.schemaprocessor.infomodel.Type;
import com.huawei.vmf.qat.xmlprocessor.infomodel.LightMO;
import com.huawei.vmf.qat.xmlprocessor.infomodel.MOXMLBuilder;
import com.huawei.vmf.qat.xmlprocessor.util.XMLTools;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class HardSpecDiffMgrImpl
implements HardSpecDiffMgr {
    private static final String HARDDIFF_XPATH_KEY = "fei_hardDiff";
    private CommandSender commandSender;
    private DeviceMgr deviceMgr = null;
    private Map<String, MOType> hardDiffMOTypes = new HashMap<String, MOType>();
    private Logger logger = RunLogger.getRunLogger();
    private MOXMLBuilder moXMLBuilder = null;
    private NetConfManager netConfManager = null;
    private Map<String, DiffDataQueryInfo> preQureyDiffData = new ConcurrentHashMap<String, DiffDataQueryInfo>();
    private Hashtable<String, Boolean> queryHardSpecIndexThreadFlagTable = new Hashtable();
    private SchemaBuilder schemaBuilder = null;

    public CommandSender getCommandSender() {
        return this.commandSender;
    }

    public DeviceMgr getDeviceMgr() {
        return this.deviceMgr;
    }

    public MOXMLBuilder getMoXMLBuilder() {
        return this.moXMLBuilder;
    }

    public NetConfManager getNetConfManager() {
        return this.netConfManager;
    }

    public SchemaBuilder getSchemaBuilder() {
        return this.schemaBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperResult<List<HardSpecDiffData>, String> queryHardSpecDiffDataList(PnpForm pnpForm, String deviceIp, HardSpecEntity hsEntity, boolean isPreQuery, String lrvrType, String vrId) {
        PerfLogger.debug((String)("start queryHardSpecDiffDataList isPreQuery is " + isPreQuery));
        OperResult operResult = new OperResult();
        operResult.setResultType(OperResultType.OPER_NOK);
        String deviceType = pnpForm.getDeviceType();
        String deviceVersion = pnpForm.getDeviceVersion();
        String httpSessionID = JSONRPCContextHolder.getHttpSessionId();
        String hardDiffSchemaFilePath = PnpConstants.PNP_DIR + File.separator + deviceType + File.separator + deviceVersion + File.separator + "schema" + File.separator + "fei" + ".xsd";
        if (!CommonUtil.exists((String)hardDiffSchemaFilePath)) {
            this.logger.info("The FEI file don't exist,the file path is " + hardDiffSchemaFilePath);
            operResult.setResultType(OperResultType.OPER_OK);
            operResult.setReturnObj(new ArrayList());
            return operResult;
        }
        List<HardSpecDiffData> hsDiffDataList = this.getDiffDataFromCache(deviceIp, hsEntity, isPreQuery);
        if (null != hsDiffDataList) {
            operResult.setResultType(OperResultType.OPER_OK);
            operResult.setReturnObj(hsDiffDataList);
            PerfLogger.debug((String)"**************end queryHardSpecDiffDataList from cache");
            return operResult;
        }
        hsDiffDataList = new ArrayList<HardSpecDiffData>();
        try {
            LightMO queryHardSpecDiffMO = this.getQueryHardSpecDiffLightMO(pnpForm.getDeviceType(), pnpForm.getDeviceVersion(), hsEntity);
            String queryContent = this.moXMLBuilder.parseMOToQueryXML(queryHardSpecDiffMO);
            LightMO logQueryHardSpecDiffMO = XMLTools.getRoot((LightMO)((LightMO)queryHardSpecDiffMO.createHeavyClone()));
            logQueryHardSpecDiffMO.resetPasswordAttributeValue();
            String logQueryContent = this.moXMLBuilder.parseMOToQueryXML(logQueryHardSpecDiffMO);
            PerfLogger.debug((String)"end parseMOToQueryXML");
            String rspContent = this.commandSender.sendGetCommand(httpSessionID, deviceIp, queryContent, logQueryContent, lrvrType, vrId);
            PerfLogger.debug((String)"end sendGetCommand");
            List mos = this.moXMLBuilder.createMos(rspContent, this.getHardDiffMOType(deviceType, deviceVersion), true);
            PerfLogger.debug((String)"end moXMLBuilder.createMos");
            hsDiffDataList = this.getNEHardSpecDiffDataList(deviceType, deviceVersion, mos);
            operResult.setResultType(OperResultType.OPER_OK);
        }
        catch (Exception e) {
            this.logger.error("HardSpecDiffMgrImpl.queryHardSpecDiffDataList", (Throwable)e);
        }
        if (isPreQuery) {
            String keyString = this.getKeyString(deviceIp, hsEntity);
            Map<String, DiffDataQueryInfo> map = this.preQureyDiffData;
            synchronized (map) {
                DiffDataQueryInfo diffData = this.preQureyDiffData.get(keyString);
                if (null != diffData) {
                    this.preQureyDiffData.put(keyString, new DiffDataQueryInfo(true, hsDiffDataList));
                }
            }
        }
        operResult.setReturnObj(hsDiffDataList);
        PerfLogger.debug((String)"end queryHardSpecDiffDataList");
        return operResult;
    }

    @Override
    public void queryHardSpecIndexList(final String deviceType, final String deviceVersion, final String deviceIp) {
        this.logger.info("enter queryHardSpecIndexList");
        final String httpSessionID = JSONRPCContextHolder.getHttpSessionId();
        String hardDiffSchemaFilePath = PnpConstants.PNP_DIR + File.separator + deviceType + File.separator + deviceVersion + File.separator + "schema" + File.separator + "fei" + ".xsd";
        if (!CommonUtil.exists((String)hardDiffSchemaFilePath)) {
            this.logger.info("The FEI file don't exist,the file path is " + hardDiffSchemaFilePath);
            return;
        }
        if (HardSpecIndexDataFactory.getInstance().isExistHardSpecIndexData(deviceType, deviceVersion)) {
            try {
                HardSpecIndexDataFactory.getInstance().parseHardSpecIndexFile(deviceType, deviceVersion);
                this.getHardDiffMOType(deviceType, deviceVersion);
            }
            catch (Exception e) {
                this.logger.info("HardSpecDiffMgrImpl.queryHardSpecIndexList", (Throwable)e);
            }
            return;
        }
        Runnable queryHardSpecIndexRunable = new Runnable(){

            @Override
            public void run() {
                HardSpecDiffMgrImpl.this.logger.info("start queryHardSpecIndexList");
                HardSpecDiffMgrImpl.this.queryHardSpecIndexThreadFlagTable.put(httpSessionID + "_" + deviceType + "_" + deviceVersion, Boolean.FALSE);
                try {
                    LightMO queryHardSpecIndexMO = HardSpecDiffMgrImpl.this.getQueryHardSpecIndexLightMO(deviceType, deviceVersion);
                    String queryContent = HardSpecDiffMgrImpl.this.moXMLBuilder.parseMOToQueryXML(queryHardSpecIndexMO);
                    LightMO logQueryHardSpecIndexMO = XMLTools.getRoot((LightMO)((LightMO)queryHardSpecIndexMO.createHeavyClone()));
                    logQueryHardSpecIndexMO.resetPasswordAttributeValue();
                    String logQueryContent = HardSpecDiffMgrImpl.this.moXMLBuilder.parseMOToQueryXML(logQueryHardSpecIndexMO);
                    String rspContent = HardSpecDiffMgrImpl.this.commandSender.sendGetCommand(httpSessionID, deviceIp, queryContent, logQueryContent, "LR", null);
                    List mos = HardSpecDiffMgrImpl.this.moXMLBuilder.createMos(rspContent, HardSpecDiffMgrImpl.this.getHardDiffMOType(deviceType, deviceVersion), true);
                    HardSpecIndexDataFactory.getInstance().addHardSpecIndexMOList(deviceType, deviceVersion, mos);
                    HardSpecDiffMgrImpl.this.queryHardSpecIndexThreadFlagTable.put(httpSessionID + "_" + deviceType + "_" + deviceVersion, Boolean.TRUE);
                    HardSpecDiffMgrImpl.this.logger.info("end queryHardSpecIndexList");
                }
                catch (Exception e) {
                    HardSpecDiffMgrImpl.this.logger.error("HardSpecDiffMgrImpl.queryHardSpecIndexList", (Throwable)e);
                }
            }
        };
        Thread queryHardSpecIndexThread = new Thread(queryHardSpecIndexRunable, HardSpecDiffMgrImpl.class.getName());
        queryHardSpecIndexThread.start();
    }

    @Override
    public List<NEHardSpecIndex> queryNEHardSpecIndexList(String currentDeviceType, String currentDeviceVersion, MOType moType, String[] xpathList) {
        String httpSessionID = JSONRPCContextHolder.getHttpSessionId();
        String key = httpSessionID + "_" + currentDeviceType + "_" + currentDeviceVersion;
        if (this.queryHardSpecIndexThreadFlagTable.get(key) == Boolean.FALSE) {
            return new ArrayList<NEHardSpecIndex>();
        }
        List<NEHardSpecIndex> hsIndexList = HardSpecIndexDataFactory.getInstance().getNEHardSpecIndexList(currentDeviceType, currentDeviceVersion, moType.getSchema().getRootName(), xpathList);
        return hsIndexList;
    }

    public void setCommandSender(CommandSender commandSender) {
        this.commandSender = commandSender;
    }

    public void setDeviceMgr(DeviceMgr deviceMgr) {
        this.deviceMgr = deviceMgr;
    }

    public void setMoXMLBuilder(MOXMLBuilder moXMLBuilder) {
        this.moXMLBuilder = moXMLBuilder;
    }

    public void setNetConfManager(NetConfManager netConfManager) {
        this.netConfManager = netConfManager;
    }

    public void setSchemaBuilder(SchemaBuilder schemaBuilder) {
        this.schemaBuilder = schemaBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HardSpecDiffData> getDiffDataFromCache(String deviceIp, HardSpecEntity hsEntity, boolean isPreQuery) {
        int DEFAULT_MAX_WAIT_TIME = 3000;
        int SLEEP_INTERVAL = 100;
        DiffDataQueryInfo diffdataInfo = null;
        String keyString = this.getKeyString(deviceIp, hsEntity);
        if (isPreQuery) {
            this.preQureyDiffData.put(keyString, new DiffDataQueryInfo());
        } else {
            diffdataInfo = this.preQureyDiffData.get(keyString);
            if (null != diffdataInfo && !diffdataInfo.isHasFinishQueried()) {
                int time = 0;
                do {
                    try {
                        Thread.sleep(SLEEP_INTERVAL);
                    }
                    catch (InterruptedException e) {
                        this.logger.error("sleep exception ", (Throwable)e);
                    }
                } while (!(diffdataInfo = this.preQureyDiffData.get(keyString)).isHasFinishQueried() && (time += SLEEP_INTERVAL) <= DEFAULT_MAX_WAIT_TIME);
                PerfLogger.debug((String)("end waiting time = " + time));
            }
            Map<String, DiffDataQueryInfo> map = this.preQureyDiffData;
            synchronized (map) {
                this.preQureyDiffData.remove(keyString);
            }
        }
        return null == diffdataInfo ? null : diffdataInfo.getDiffDatas();
    }

    private MOType getHardDiffMOType(String deviceType, String deviceVersion) {
        PerfLogger.debug((String)"start getHardDiffMOType");
        String key = deviceType + "_" + deviceVersion;
        MOType moType = this.hardDiffMOTypes.get(key);
        if (null == moType) {
            Schema schema = this.schemaBuilder.buildSchema(PnpConstants.PNP_DIR + File.separator + deviceType + File.separator + deviceVersion + File.separator + "schema" + File.separator + "fei" + ".xsd");
            moType = schema.getMOType(XpathManager.INSTANCE.getPnpXpath(deviceType, deviceVersion, HARDDIFF_XPATH_KEY));
            this.hardDiffMOTypes.put(key, moType);
        }
        PerfLogger.debug((String)"end getHardDiffMOType");
        return moType;
    }

    private String getKeyString(String deviceIp, HardSpecEntity hsEntity) {
        return deviceIp + JSONRPCContextHolder.getHttpSessionId() + hsEntity.getKeyString();
    }

    private List<HardSpecDiffData> getNEHardSpecDiffDataList(String deviceType, String deviceVersion, List<LightMO> mos) {
        ArrayList<HardSpecDiffData> hsDiffList = new ArrayList<HardSpecDiffData>();
        List<AttributePara> returnDiffAttriParaList = HardSpecConfigInfoFactory.getInstance().getHardSpecDiffReturnParaMap(deviceType, deviceVersion);
        String attriValue = null;
        String attriParaName = null;
        String attriParaXpath = null;
        String methodName = null;
        for (LightMO mo : mos) {
            HardSpecDiffData hsDiffData = new HardSpecDiffData();
            for (AttributePara attriPara : returnDiffAttriParaList) {
                attriParaName = attriPara.getName();
                attriParaXpath = attriPara.getXpath();
                attriValue = mo.getAttributeValue(attriParaXpath);
                try {
                    methodName = "set" + StringUtil.toDefaultLocaleUpperCase((String)(attriParaName.toCharArray()[0] + "")) + attriParaName.substring(1);
                    hsDiffData.getClass().getMethod(methodName, String.class).invoke((Object)hsDiffData, attriValue);
                }
                catch (Exception e) {
                    this.logger.error("HardSpecDiffMgrImpl.getNEHardSpecDiffDataList", (Throwable)e);
                }
            }
            hsDiffList.add(hsDiffData);
        }
        return hsDiffList;
    }

    private LightMO getQueryHardSpecDiffLightMO(String deviceType, String deviceVersion, HardSpecEntity hsEntity) {
        MOType hardDiffMOType = this.getHardDiffMOType(deviceType, deviceVersion);
        LightMO hardDiffMO = this.moXMLBuilder.createMO((Type)hardDiffMOType);
        List<AttributePara> returnAttriParaList = HardSpecConfigInfoFactory.getInstance().getHardSpecDiffReturnParaMap(deviceType, deviceVersion);
        this.setMOQueryAttribute(hardDiffMO, returnAttriParaList);
        String attriParaName = null;
        String attriParaXpath = null;
        String methodName = null;
        String value = "";
        List<AttributePara> conditionAttriParaList = HardSpecConfigInfoFactory.getInstance().getHardSpecDiffConditionParaMap(deviceType, deviceVersion);
        for (AttributePara attriPara : conditionAttriParaList) {
            attriParaName = attriPara.getName();
            attriParaXpath = attriPara.getXpath();
            methodName = "get" + StringUtil.toDefaultLocaleUpperCase((String)(attriParaName.toCharArray()[0] + "")) + attriParaName.substring(1);
            try {
                value = (String)hsEntity.getClass().getMethod(methodName, new Class[0]).invoke((Object)hsEntity, new Object[0]);
                hardDiffMO.setAttributeValue(attriParaXpath, value);
            }
            catch (Exception e) {
                this.logger.error("HardSpecDiffMgrImpl.getQueryHardSpecDiffLightMO", (Throwable)e);
            }
        }
        return hardDiffMO;
    }

    private LightMO getQueryHardSpecIndexLightMO(String deviceType, String deviceVersion) {
        MOType hardDiffMOType = this.getHardDiffMOType(deviceType, deviceVersion);
        LightMO hardDiffMO = this.moXMLBuilder.createMO((Type)hardDiffMOType);
        List<AttributePara> queryAttriParaList = HardSpecConfigInfoFactory.getInstance().getHardSpecIndexQueryParaMap(deviceType, deviceVersion);
        this.setMOQueryAttribute(hardDiffMO, queryAttriParaList);
        return hardDiffMO;
    }

    private void setMOQueryAttribute(LightMO mo, List<AttributePara> attriParaList) {
        for (AttributePara attriPara : attriParaList) {
            mo.setAttributeValue(attriPara.getXpath(), attriPara.getValue());
        }
    }

    private class DiffDataQueryInfo {
        private List<HardSpecDiffData> diffDatas = null;
        private boolean hasFinishQueried = false;

        private DiffDataQueryInfo() {
        }

        private DiffDataQueryInfo(boolean hasFinishQueried, List<HardSpecDiffData> diffDatas) {
            this.hasFinishQueried = hasFinishQueried;
            this.diffDatas = diffDatas;
        }

        public List<HardSpecDiffData> getDiffDatas() {
            return this.diffDatas;
        }

        public boolean isHasFinishQueried() {
            return this.hasFinishQueried;
        }
    }
}

