/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.capabilitymgr.harddiff;

import com.huawei.vmf.common.tool.IOUtil;
import com.huawei.vmf.common.tool.StringUtil;
import com.huawei.vmf.qat.capabilitymgr.domain.AttributePara;
import com.huawei.vmf.qat.capabilitymgr.domain.NEHardSpecIndex;
import com.huawei.vmf.qat.capabilitymgr.harddiff.HardSpecConfigInfoFactory;
import com.huawei.vmf.qat.capabilitymgr.util.CapabilityMgrConstants;
import com.huawei.vmf.qat.common.CommonUtil;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.xmlprocessor.infomodel.LightMO;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HardSpecIndexDataFactory {
    private static HardSpecIndexDataFactory instance = new HardSpecIndexDataFactory();
    private Map<String, Map<String, List<NEHardSpecIndex>>> hardSpecIndexMap = new HashMap<String, Map<String, List<NEHardSpecIndex>>>();
    private Logger logger = RunLogger.getRunLogger();

    public static HardSpecIndexDataFactory getInstance() {
        return instance;
    }

    public void addHardSpecIndexMOList(String deviceType, String deviceVersion, List<LightMO> hsIndexMOList) {
        if (CommonUtil.isEmpty(hsIndexMOList)) {
            return;
        }
        ArrayList<NEHardSpecIndex> hsIndexList = new ArrayList<NEHardSpecIndex>();
        for (LightMO mo : hsIndexMOList) {
            hsIndexList.add(this.getHardSpecIndex(deviceType, deviceVersion, mo));
        }
        HashMap<String, List<NEHardSpecIndex>> hsIndexMap = new HashMap<String, List<NEHardSpecIndex>>();
        String featureName = null;
        ArrayList<NEHardSpecIndex> hsIndexGroup = null;
        for (NEHardSpecIndex hsIndex : hsIndexList) {
            featureName = hsIndex.getSchemaName();
            hsIndexGroup = (ArrayList<NEHardSpecIndex>)hsIndexMap.get(featureName);
            if (hsIndexGroup == null) {
                hsIndexGroup = new ArrayList<NEHardSpecIndex>();
                hsIndexMap.put(featureName, hsIndexGroup);
            }
            hsIndexGroup.add(hsIndex);
        }
        this.hardSpecIndexMap.put(deviceType + "_" + deviceVersion, hsIndexMap);
        this.saveHardSpecIndexListToFile(deviceType, deviceVersion, hsIndexMap);
    }

    public List<NEHardSpecIndex> getNEHardSpecIndexList(String deviceType, String deviceVersion, String schemaName, String[] attriXpathList) {
        this.parseHardSpecIndexFile(deviceType, deviceVersion);
        Map<String, List<NEHardSpecIndex>> hsIndexMap = this.hardSpecIndexMap.get(deviceType + "_" + deviceVersion);
        if (CommonUtil.isEmpty(hsIndexMap)) {
            return new ArrayList<NEHardSpecIndex>();
        }
        ArrayList<NEHardSpecIndex> matchMhsIndexList = new ArrayList<NEHardSpecIndex>();
        if (!CommonUtil.isEmpty(hsIndexMap)) {
            List<NEHardSpecIndex> mhsIndexList = hsIndexMap.get(schemaName);
            if (CommonUtil.isEmpty(mhsIndexList)) {
                return new ArrayList<NEHardSpecIndex>();
            }
            block0: for (NEHardSpecIndex mhsIndex : mhsIndexList) {
                for (String attriXpath : attriXpathList) {
                    if (!mhsIndex.isMatchWithXpath(attriXpath)) continue;
                    matchMhsIndexList.add(mhsIndex);
                    continue block0;
                }
            }
        }
        return matchMhsIndexList;
    }

    public boolean isExistHardSpecIndexData(String deviceType, String deviceVersion) {
        Map<String, List<NEHardSpecIndex>> hsIndexMap = this.hardSpecIndexMap.get(deviceType + "_" + deviceVersion);
        if (hsIndexMap != null && hsIndexMap.size() > 0) {
            return true;
        }
        return CommonUtil.exists((String)(CapabilityMgrConstants.HARDSPECINDEX_FILE_PARENT_DIR + deviceType + File.separator + deviceVersion + File.separator + "hardSpecIndex.xml"));
    }

    public void parseHardSpecIndexFile(String deviceType, String deviceVersion) {
        Map<String, List<NEHardSpecIndex>> hsIndexMap = this.hardSpecIndexMap.get(deviceType + "_" + deviceVersion);
        if (!CommonUtil.isEmpty(hsIndexMap)) {
            return;
        }
        String hsIndexFilePath = CapabilityMgrConstants.HARDSPECINDEX_FILE_PARENT_DIR + deviceType + File.separator + deviceVersion + File.separator + "hardSpecIndex.xml";
        if (!CommonUtil.exists((String)hsIndexFilePath)) {
            return;
        }
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = builder.parse(hsIndexFilePath);
            Element root = document.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            List<Element> schemaElementList = this.getElementList(childNodes);
            HashMap<String, List<NEHardSpecIndex>> hsSpecIndexMap = new HashMap<String, List<NEHardSpecIndex>>();
            this.hardSpecIndexMap.put(deviceType + "_" + deviceVersion, hsSpecIndexMap);
            for (Element schemaElement : schemaElementList) {
                this.parseSchemaElement(schemaElement, hsSpecIndexMap);
            }
        }
        catch (Exception e) {
            this.logger.error("HardSpecIndexDataFactory.parseHardSpecIndexFile", (Throwable)e);
        }
    }

    private List<Element> getElementList(NodeList nodeList) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        Node node = null;
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            elementList.add((Element)node);
        }
        return elementList;
    }

    private NEHardSpecIndex getHardSpecIndex(String deviceType, String deviceVersion, LightMO mo) {
        String schemaName = mo.getMOType().getSchema().getRootName();
        NEHardSpecIndex ehsIndex = new NEHardSpecIndex();
        ehsIndex.setSchemaName(schemaName);
        List<AttributePara> hsIndexRetureAttriParaList = HardSpecConfigInfoFactory.getInstance().getHardSpecIndexReturnParaMap(deviceType, deviceVersion);
        if (CommonUtil.isEmpty(hsIndexRetureAttriParaList)) {
            return ehsIndex;
        }
        String attriParaValue = null;
        for (AttributePara attriPara : hsIndexRetureAttriParaList) {
            attriParaValue = mo.getAttributeValue(attriPara.getXpath());
            if (attriParaValue == null) continue;
            this.setHardSpecIndexFieldValue(ehsIndex, attriPara.getName(), attriParaValue);
        }
        return ehsIndex;
    }

    private void parseDiffEleme(Element diffElement, String schemaName, List<NEHardSpecIndex> mhsIndexList) {
        NEHardSpecIndex ehsIndex = new NEHardSpecIndex();
        ehsIndex.setSchemaName(schemaName);
        List<Element> hsIndexElementList = this.getElementList(diffElement.getChildNodes());
        String tagName = null;
        String text = null;
        for (Element hsIndexElement : hsIndexElementList) {
            tagName = hsIndexElement.getTagName().trim();
            text = hsIndexElement.getTextContent().trim();
            this.setHardSpecIndexFieldValue(ehsIndex, tagName, text);
        }
        mhsIndexList.add(ehsIndex);
    }

    private void parseSchemaElement(Element schemaElement, Map<String, List<NEHardSpecIndex>> hsIndexMap) {
        String schemaName = schemaElement.getAttribute("name");
        ArrayList<NEHardSpecIndex> neHardSpecIndexList = new ArrayList<NEHardSpecIndex>();
        hsIndexMap.put(schemaName, neHardSpecIndexList);
        List<Element> diffElementsList = this.getElementList(schemaElement.getChildNodes());
        List<Element> diffElementList = this.getElementList(diffElementsList.get(0).getChildNodes());
        for (Element diffElement : diffElementList) {
            this.parseDiffEleme(diffElement, schemaName, neHardSpecIndexList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveHardSpecIndexListToFile(String deviceType, String deviceVersion, Map<String, List<NEHardSpecIndex>> hsIndexMap) {
        BufferedWriter writer;
        FileWriter fileWriter;
        block12: {
            block11: {
                fileWriter = null;
                writer = null;
                try {
                    File hsIndexDir = new File(CapabilityMgrConstants.HARDSPECINDEX_FILE_PARENT_DIR + deviceType + File.separator + deviceVersion);
                    if (!hsIndexDir.exists() && !hsIndexDir.mkdirs()) {
                        this.logger.error("create hardSpecIndex directory error. path =" + hsIndexDir.getPath());
                        return;
                    }
                    File hsIndexFile = new File(hsIndexDir.getAbsolutePath() + File.separator + "hardSpecIndex.xml");
                    if (!hsIndexFile.createNewFile()) {
                        this.logger.error("create hardSpecIndex file error. path =" + hsIndexFile.getPath());
                        IOUtil.close((Writer)fileWriter);
                        break block11;
                    }
                    fileWriter = new FileWriter(hsIndexFile);
                    writer = new BufferedWriter(fileWriter);
                    Iterator<Map.Entry<String, List<NEHardSpecIndex>>> hsIndexIte = hsIndexMap.entrySet().iterator();
                    Map.Entry<String, List<NEHardSpecIndex>> hsIndexEntry = null;
                    String schemaName = null;
                    writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    writer.newLine();
                    writer.write("<hardSpecIndex>");
                    writer.newLine();
                    while (hsIndexIte.hasNext()) {
                        hsIndexEntry = hsIndexIte.next();
                        schemaName = hsIndexEntry.getKey();
                        List<NEHardSpecIndex> mhsIndexList = hsIndexEntry.getValue();
                        writer.write("<schema name=\"" + schemaName + "\">");
                        writer.newLine();
                        writer.write("<diffElements>");
                        writer.newLine();
                        for (NEHardSpecIndex mhsIndex : mhsIndexList) {
                            writer.write("<diffElement>");
                            writer.newLine();
                            writer.write("<bindType>" + mhsIndex.getBindType() + "</bindType>");
                            writer.newLine();
                            writer.write("<elementXpath>" + mhsIndex.getElementXpath() + "</elementXpath>");
                            writer.newLine();
                            writer.write("<bindXpath>" + mhsIndex.getBindXpath() + "</bindXpath>");
                            writer.newLine();
                            writer.write("<parentXpath>" + mhsIndex.getParentXpath() + "</parentXpath>");
                            writer.newLine();
                            writer.write("</diffElement>");
                            writer.newLine();
                        }
                        writer.write("</diffElements>");
                        writer.newLine();
                        writer.write("</schema>");
                        writer.newLine();
                    }
                    writer.write("</hardSpecIndex>");
                    writer.flush();
                    IOUtil.close((Writer)fileWriter);
                    break block12;
                }
                catch (Exception e) {
                    this.logger.error("HardSpecIndexDataFactory.saveHardSpecIndexListToFile", (Throwable)e);
                    return;
                }
            }
            IOUtil.close((Writer)writer);
            return;
        }
        IOUtil.close((Writer)writer);
        return;
        finally {
            IOUtil.close(fileWriter);
            IOUtil.close(writer);
        }
    }

    private void setHardSpecIndexFieldValue(NEHardSpecIndex hsIndex, String fieldName, String fieldValue) {
        try {
            String methodName = "set" + StringUtil.toDefaultLocaleUpperCase((String)(fieldName.toCharArray()[0] + "")) + fieldName.substring(1);
            Method method = hsIndex.getClass().getMethod(methodName, String.class);
            method.invoke((Object)hsIndex, fieldValue);
        }
        catch (Exception e) {
            this.logger.error("HardSpecIndexDataFactory.setHardSpecIndexFieldValue", (Throwable)e);
        }
    }
}

