/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.capabilitymgr.harddiff;

import com.huawei.vmf.qat.capabilitymgr.domain.AttributePara;
import com.huawei.vmf.qat.capabilitymgr.util.CapabilityMgrConstants;
import com.huawei.vmf.qat.common.CommonUtil;
import com.huawei.vmf.qat.common.log.RunLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HardSpecConfigInfoFactory {
    private static HashMap<String, Vector<List<AttributePara>>> configInfoMap = new HashMap();
    private static HardSpecConfigInfoFactory instance = new HardSpecConfigInfoFactory();
    private static final Logger logger = RunLogger.getRunLogger();

    public static HardSpecConfigInfoFactory getInstance() {
        return instance;
    }

    public List<AttributePara> getHardSpecDiffConditionParaMap(String deviceType, String deviceVersion) {
        Vector<List<AttributePara>> configInfoVec = this.getHardSpecConfigInfVec(deviceType, deviceVersion);
        if (CommonUtil.isEmpty(configInfoVec)) {
            return null;
        }
        return configInfoVec.get(2);
    }

    public List<AttributePara> getHardSpecDiffQueryParaMap(String deviceType, String deviceVersion) {
        ArrayList<AttributePara> queryAttriParaList = new ArrayList<AttributePara>();
        this.mergeAttributeParaList(queryAttriParaList, this.getHardSpecDiffConditionParaMap(deviceType, deviceVersion));
        this.mergeAttributeParaList(queryAttriParaList, this.getHardSpecDiffReturnParaMap(deviceType, deviceVersion));
        return queryAttriParaList;
    }

    public List<AttributePara> getHardSpecDiffReturnParaMap(String deviceType, String deviceVersion) {
        Vector<List<AttributePara>> configInfoVec = this.getHardSpecConfigInfVec(deviceType, deviceVersion);
        if (CommonUtil.isEmpty(configInfoVec)) {
            return null;
        }
        return configInfoVec.get(3);
    }

    public List<AttributePara> getHardSpecIndexConditionParaMap(String deviceType, String deviceVersion) {
        Vector<List<AttributePara>> configInfoVec = this.getHardSpecConfigInfVec(deviceType, deviceVersion);
        if (CommonUtil.isEmpty(configInfoVec)) {
            return null;
        }
        return configInfoVec.get(0);
    }

    public List<AttributePara> getHardSpecIndexQueryParaMap(String deviceType, String deviceVersion) {
        ArrayList<AttributePara> queryAttriParaList = new ArrayList<AttributePara>();
        this.mergeAttributeParaList(queryAttriParaList, this.getHardSpecIndexConditionParaMap(deviceType, deviceVersion));
        this.mergeAttributeParaList(queryAttriParaList, this.getHardSpecIndexReturnParaMap(deviceType, deviceVersion));
        return queryAttriParaList;
    }

    public List<AttributePara> getHardSpecIndexReturnParaMap(String deviceType, String deviceVersion) {
        Vector<List<AttributePara>> configInfoVec = this.getHardSpecConfigInfVec(deviceType, deviceVersion);
        if (CommonUtil.isEmpty(configInfoVec)) {
            return null;
        }
        return configInfoVec.get(1);
    }

    private AttributePara getAttributePara(Element element) {
        AttributePara attriPara = new AttributePara();
        attriPara.setName(element.getTagName());
        attriPara.setXpath(element.getTextContent().trim());
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null && attributes.getLength() > 0) {
            Node attribute = null;
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                attribute = attributes.item(i);
                if (!attribute.getNodeName().equals("defaultValue")) continue;
                attriPara.setValue(attribute.getNodeValue());
                break;
            }
        }
        return attriPara;
    }

    private List<Element> getElementList(NodeList nodeList) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        Node node = null;
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            elementList.add((Element)node);
        }
        return elementList;
    }

    private Vector<List<AttributePara>> getHardSpecConfigInfVec(String deviceType, String deviceVersion) {
        String keyStr = deviceType + "_" + deviceVersion;
        if (configInfoMap.get(keyStr) == null) {
            this.parseHardSpecConfigFile(deviceType, deviceVersion);
        }
        return configInfoMap.get(keyStr);
    }

    private List<AttributePara> mergeAttributeParaList(List<AttributePara> destAttriParaList, List<AttributePara> sourceAttriParaList) {
        if (CommonUtil.isEmpty(sourceAttriParaList)) {
            return destAttriParaList;
        }
        for (AttributePara attriPara : sourceAttriParaList) {
            if (destAttriParaList.indexOf(attriPara) >= 0) continue;
            destAttriParaList.add(attriPara);
        }
        return destAttriParaList;
    }

    private void parseConditionElement(Element conditionElement, Vector<List<AttributePara>> configInfoVec) {
        List<Element> subElementList = this.getElementList(conditionElement.getChildNodes());
        for (Element subElement : subElementList) {
            ArrayList<AttributePara> attriParaList = new ArrayList<AttributePara>();
            List<Element> tagXpathElementList = this.getElementList(subElement.getChildNodes());
            for (Element tagXpathElement : tagXpathElementList) {
                attriParaList.add(this.getAttributePara(tagXpathElement));
            }
            configInfoVec.add(attriParaList);
        }
    }

    private void parseHardSpecConfigFile(String deviceType, String deviceVersion) {
        String hardSpecConfigFilePath = CapabilityMgrConstants.HARDSPEC_CONFIG_FILE_PARENT_DIR + deviceType + File.separator + deviceVersion + CapabilityMgrConstants.HARDSPEC_CONFIG_FILE_SUB_DIR;
        if (!CommonUtil.exists((String)hardSpecConfigFilePath)) {
            return;
        }
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = builder.parse(hardSpecConfigFilePath);
            Element root = document.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            List<Element> conditionElementList = this.getElementList(childNodes);
            Vector<List<AttributePara>> configInfoVec = new Vector<List<AttributePara>>();
            configInfoMap.put(deviceType + "_" + deviceVersion, configInfoVec);
            for (Element conditionElement : conditionElementList) {
                this.parseConditionElement(conditionElement, configInfoVec);
            }
        }
        catch (Exception e) {
            logger.error("HardSpecConfigInfoFactory.parseHardSpecConfigFile", (Throwable)e);
        }
    }
}

