/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.capabilitymgr.functreemgr.impl;

import com.huawei.uflight.threadpool.ThreadPool;
import com.huawei.vmf.common.pnp.domain.PnpForm;
import com.huawei.vmf.extendpoint.framework.IApplyDifference;
import com.huawei.vmf.extendpoint.register.FrameExtendPointServiceMgr;
import com.huawei.vmf.qat.capabilitymgr.functreemgr.BoardCapabilityMgr;
import com.huawei.vmf.qat.capabilitymgr.functreemgr.FuncTreeNodeInfo;
import com.huawei.vmf.qat.capabilitymgr.functreemgr.FuncTreeNodeType;
import com.huawei.vmf.qat.capabilitymgr.functreemgr.FunctionTreeMgr;
import com.huawei.vmf.qat.capabilitymgr.functreemgr.NodeDomain;
import com.huawei.vmf.qat.capabilitymgr.functreemgr.TreeType;
import com.huawei.vmf.qat.capabilitymgr.info.CapabilityInfoMgr;
import com.huawei.vmf.qat.capabilitymgr.info.NECapabilityInfo;
import com.huawei.vmf.qat.capabilitymgr.util.CapabilityMgrConstants;
import com.huawei.vmf.qat.capabilitymgr.util.Util;
import com.huawei.vmf.qat.common.CommonUtil;
import com.huawei.vmf.qat.common.domain.GUIType;
import com.huawei.vmf.qat.common.infomgr.CustomTabMgr;
import com.huawei.vmf.qat.common.infomgr.TypeCustomInfoMgr;
import com.huawei.vmf.qat.common.json.JSONRPCContextHolder;
import com.huawei.vmf.qat.common.log.PerfLogger;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.common.rsp.OperResult;
import com.huawei.vmf.qat.common.rsp.OperResultType;
import com.huawei.vmf.qat.common.rsp.QatOperException;
import com.huawei.vmf.qat.common.xmlfile.Dom4jProcessor;
import com.huawei.vmf.qat.devicemgr.devinfo.DeviceInfo;
import com.huawei.vmf.qat.devicemgr.devmgr.DeviceMgr;
import com.huawei.vmf.qat.devicemgr.devmgr.DeviceMgrIntegration;
import com.huawei.vmf.qat.devicemgr.devnavigator.LRVRCapabilityMgr;
import com.huawei.vmf.qat.schemaprocessor.infomodel.CapaOperType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.CtrlInfo;
import com.huawei.vmf.qat.schemaprocessor.infomodel.CustomInfoType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.FeatureCapaInfo;
import com.huawei.vmf.qat.schemaprocessor.infomodel.MOType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.Schema;
import com.huawei.vmf.qat.schemaprocessor.infomodel.SchemaBuilder;
import com.huawei.vmf.qat.schemaprocessor.infomodel.SchemaId;
import com.huawei.vmf.qat.schemaprocessor.infomodel.TypeCustomInfo;
import com.huawei.vmf.qat.security.support.SessionDataHolder;
import com.huawei.vmf.qat.xmlprocessor.infomodel.LightMO;
import com.huawei.vmf.qat.xmlprocessor.infomodel.LightMOTree;
import com.huawei.vmf.qat.xmlprocessor.infomodel.MOXMLBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;

public class FunctionTreeMgrImpl
implements FunctionTreeMgr,
InitializingBean {
    public static final String FUNCTREE_NODE_APPEARONCE = "appearOnce";
    public static final String FUNCTREE_NODE_DOMAIN = "domain";
    public static final String FUNCTREE_NODE_NAME = "name";
    public static final String FUNCTREE_NODE_PARENTNAME = "parentName";
    public static final String FUNCTREE_NODE_TYPE = "type";
    public static final String FUNCTREE_NODE_UNSUPPORTEDLR = "unSupportedLR";
    public static final String FUNCTREE_NODE_UNSUPPORTEDVR = "unSupportedVR";
    public static final String FUNCTREE_NODE_VISIABLE = "visiable";
    private static volatile Schema funcTreeSchema;
    private static Logger logger;
    private Map<String, Map<String, List<FuncTreeNodeInfo>>> allDevTypeFuncTreeInfos;
    private Map<String, Document> allDevTypeTreeInfoDoc = new HashMap<String, Document>();
    private Set<CustomInfoType> availableCustomInfoTypes;
    private BoardCapabilityMgr boardCapMgr;
    private CapabilityInfoMgr capaInfoMgr;
    private CustomTabMgr customTabMgr;
    private DeviceMgr deviceMgr;
    private DeviceMgrIntegration deviceMgrIntegration;
    private Map<String, FuncTreeNodeType> funcNodeTypeMap;
    private LRVRCapabilityMgr lrvrCapabilityMgr;
    private MOXMLBuilder moXmlBuilder;
    private Map<String, NodeDomain> nodeDomainMap;
    private SchemaBuilder schemaBuilder;
    private TypeCustomInfoMgr typeCustomInfoMgr;
    private Dom4jProcessor xmlUtil;

    public FunctionTreeMgrImpl() {
        PerfLogger.debug((String)"enter FunctionTreeMgrImpl()");
        this.nodeDomainMap = new HashMap<String, NodeDomain>();
        this.nodeDomainMap.put(NodeDomain.LR.getDescription(), NodeDomain.LR);
        this.nodeDomainMap.put(NodeDomain.VR.getDescription(), NodeDomain.VR);
        this.nodeDomainMap.put(NodeDomain.BOTH.getDescription(), NodeDomain.BOTH);
        this.nodeDomainMap.put(NodeDomain.LR_ADMIN.getDescription(), NodeDomain.LR_ADMIN);
        this.nodeDomainMap.put(NodeDomain.PR_ADMIN.getDescription(), NodeDomain.PR_ADMIN);
        this.funcNodeTypeMap = new HashMap<String, FuncTreeNodeType>();
        this.funcNodeTypeMap.put("manager", FuncTreeNodeType.MANAGER);
        this.funcNodeTypeMap.put("feature", FuncTreeNodeType.FEATURE);
        this.funcNodeTypeMap.put("content", FuncTreeNodeType.CONTENT);
        this.funcNodeTypeMap.put("url", FuncTreeNodeType.URL);
        this.funcNodeTypeMap.put("customurl", FuncTreeNodeType.CUSTOMURL);
        this.allDevTypeFuncTreeInfos = new HashMap<String, Map<String, List<FuncTreeNodeInfo>>>();
    }

    public void afterPropertiesSet() throws Exception {
        this.initFunctreeInfos();
    }

    @Override
    public OperResult<String, Void> getAdminTree(PnpForm pnpForm) {
        OperResult operResult = new OperResult();
        List<FuncTreeNodeInfo> nodeInfoList = this.getAdminTreeNodeInfoList(pnpForm);
        operResult.setResultType(OperResultType.OPER_OK);
        operResult.setReturnObj((Object)this.funcTreeByVisiableToString(nodeInfoList));
        return operResult;
    }

    public BoardCapabilityMgr getBoardCapMgr() {
        return this.boardCapMgr;
    }

    public CustomTabMgr getCustomTabMgr() {
        return this.customTabMgr;
    }

    @Override
    public List<FuncTreeNodeInfo> getFeatureTreeInfo(String deviceType, String deviceVersion, String domain) throws QatOperException {
        String workplaceTreeFilePath = Util.getWorkspaceTreeXMLPath(deviceType, deviceVersion);
        File treeFile = new File(workplaceTreeFilePath);
        if (!treeFile.exists() || !treeFile.isFile()) {
            throw new QatOperException("The file workspacetree.xml does not exist!");
        }
        this.getFuncTreeSchema();
        MOType funcTreeNodeMOType = funcTreeSchema.getMOType("/treeInfo/funcTree/funcnodes/funcnode");
        LightMOTree moXML = this.moXmlBuilder.buildMOXMLByURL(workplaceTreeFilePath, funcTreeSchema);
        List funcMOList = moXML.getMOList(funcTreeNodeMOType);
        ArrayList<LightMO> removeMOList = new ArrayList<LightMO>();
        if ("LR".equals(domain)) {
            removeMOList.addAll(this.getMOListByDomain("VR", funcMOList));
            removeMOList.addAll(this.getMOListByDomain("LR-Admin", funcMOList));
        } else if ("VR".equals(domain)) {
            removeMOList.addAll(this.getMOListByDomain("LR", funcMOList));
            removeMOList.addAll(this.getMOListByDomain("LR-Admin", funcMOList));
        }
        for (LightMO mo : removeMOList) {
            funcMOList.remove(mo);
        }
        List<FuncTreeNodeInfo> nodeInfoList = null;
        if (null == funcMOList) {
            logger.error("The funcTreeMOList object is null or the size of funcTreeMOList object is 0!");
            throw new QatOperException("The funcTreeMOList object is null or the size of funcTreeMOList object is 0!");
        }
        nodeInfoList = this.dealFeatureTreeNodeMO(funcTreeNodeMOType, funcMOList, deviceType, deviceVersion);
        List<FuncTreeNodeInfo> funcNodeList = this.getFuncNodeList(new NECapabilityInfo(), nodeInfoList, TreeType.WORKSPACE);
        return this.delNodeAppearOnce(funcNodeList);
    }

    @Override
    public OperResult<String, Void> getFunctionTree(PnpForm pnpFrom, String neFlag, String deviceType, String deviceVersion, String neId, String isWorkSpace, boolean isSupportPartition) {
        OperResult operResult = new OperResult();
        String resFileName = deviceType + "_" + deviceVersion;
        String resFileNode = "<resFileName value=\"" + resFileName + "\" />";
        List<FuncTreeNodeInfo> nodeInfoList = null;
        try {
            nodeInfoList = this.getFuncTreeNodeInfoList(pnpFrom, neFlag, new NECapabilityInfo(), isWorkSpace, isSupportPartition, null);
        }
        catch (QatOperException e) {
            logger.error("Getting list of FuncTreeNodeInfo failed!", (Throwable)e);
            operResult.setResultType(OperResultType.OPER_NOK);
            operResult.addError(1107525641);
            return operResult;
        }
        operResult.setResultType(OperResultType.OPER_OK);
        operResult.setReturnObj((Object)(this.funcTreeByVisiableToString(nodeInfoList) + resFileNode));
        return operResult;
    }

    @Override
    public OperResult<String, Void> getFunctionTree(PnpForm pnpForm, String neFlag, String sessionId, String neId, String isWorkSpace, String devIP, String boardCapTypes) {
        Element element;
        PerfLogger.debug((String)"enter getFunctionTree");
        if (StringUtils.isBlank((String)sessionId) || StringUtils.isBlank((String)neFlag) || StringUtils.isBlank((String)neId)) {
            throw new IllegalArgumentException("[FunctionTreeMgrImpl:getFunctionTree]The parameter is error.");
        }
        OperResult operResult = new OperResult();
        OperResult<List<FuncTreeNodeInfo>, Void> nodeInfosResult = this.getFuncTreeNodeInfoList(pnpForm, neFlag, sessionId, neId, isWorkSpace, devIP, boardCapTypes);
        if (OperResultType.OPER_OK != nodeInfosResult.getResultType()) {
            logger.error("get func tree node info fail.");
            operResult.setResultType(OperResultType.OPER_NOK);
            operResult.addErrors(nodeInfosResult.getErrors());
            return operResult;
        }
        PerfLogger.debug((String)"end getFuncTreeNodeInfoList");
        Document treeDoc = this.getFuncTreeDoc(pnpForm, TreeType.WINDOW, boardCapTypes);
        boolean isExtResExist = null == treeDoc ? false : (element = (Element)this.xmlUtil.selectSingleNode((Node)treeDoc, "/treeInfo")).attributeValue("extRes") != null;
        String treeString = this.funcTreeByVisiableToString((List)nodeInfosResult.getReturnObj()) + "<resFileName value=\"" + pnpForm.getDeviceType() + "_" + pnpForm.getDeviceVersion() + "_" + "treeinfo" + "\" />" + "<isSupportLRPartition value=\"" + this.lrvrCapabilityMgr.isSupportMultiLR(pnpForm.getDeviceType(), pnpForm.getDeviceVersion()) + "\" />" + "<isAdminTreeFileExist value=\"" + this.lrvrCapabilityMgr.isAdminTreeFileExist(pnpForm.getDeviceType(), pnpForm.getDeviceVersion()) + "\" />" + "<extRes value=\"" + isExtResExist + "\" />";
        PerfLogger.debug((String)"end funcTreeByVisiableToString");
        operResult.setResultType(OperResultType.OPER_OK);
        operResult.setReturnObj((Object)treeString);
        return operResult;
    }

    @Override
    public List<FuncTreeNodeInfo> getFuncTreeNodeInfoList(PnpForm pnpForm, String neFlag, NECapabilityInfo neLicCapa, String isWorkSpace, boolean isSupportPartition, String boardCapTypes) throws QatOperException {
        if (null == pnpForm || StringUtils.isBlank((String)neFlag)) {
            throw new IllegalArgumentException("[FunctionTreeMgrImpl:getFuncTreeNodeInfoList]The parameter is error.");
        }
        TreeType type = boardCapTypes != null ? TreeType.BOARD : this.isWorkspace(isWorkSpace);
        return this.dealFuncTreeFile(pnpForm, neFlag, neLicCapa, isSupportPartition, type, boardCapTypes);
    }

    @Override
    public OperResult<List<FuncTreeNodeInfo>, Void> getFuncTreeNodeInfoList(PnpForm pnpForm, String neFlag, String neId, String devIP, String boardCapTypes) {
        String sessionId = JSONRPCContextHolder.getHttpSessionId();
        return this.getFuncTreeNodeInfoList(pnpForm, neFlag, sessionId, neId, "false", devIP, boardCapTypes);
    }

    public void setAvailableCustomInfoTypes(Set<CustomInfoType> availableCustomInfoTypes) {
        this.availableCustomInfoTypes = availableCustomInfoTypes;
    }

    public void setBoardCapMgr(BoardCapabilityMgr boardCapMgr) {
        this.boardCapMgr = boardCapMgr;
    }

    public void setCapabilityInfoMgr(CapabilityInfoMgr capaInfoMgr) {
        this.capaInfoMgr = capaInfoMgr;
    }

    public void setCustomTabMgr(CustomTabMgr customTabMgr) {
        this.customTabMgr = customTabMgr;
    }

    public void setDeviceMgr(DeviceMgr deviceMgr) {
        this.deviceMgr = deviceMgr;
    }

    public void setDeviceMgrIntegration(DeviceMgrIntegration deviceMgrIntegration) {
        PerfLogger.debug((String)"enter setDeviceMgrIntegration()");
        this.deviceMgrIntegration = deviceMgrIntegration;
    }

    public void setLrvrCapabilityMgr(LRVRCapabilityMgr lrvrCapabilityMgr) {
        this.lrvrCapabilityMgr = lrvrCapabilityMgr;
    }

    public void setMoXMLBuilder(MOXMLBuilder moXmlBuilder) {
        this.moXmlBuilder = moXmlBuilder;
    }

    public void setSchemaBuilder(SchemaBuilder schemaBuilder) {
        this.schemaBuilder = schemaBuilder;
    }

    public void setTypeCustomInfoMgr(TypeCustomInfoMgr typeCustomInfoMgr) {
        this.typeCustomInfoMgr = typeCustomInfoMgr;
    }

    public void setXmlUtil(Dom4jProcessor xmlUtil) {
        this.xmlUtil = xmlUtil;
    }

    private void addFunctreeMosInfoToMemory(PnpForm pnpForm, List<FuncTreeNodeInfo> treeNodes, TreeType type, String boardCapTypes) {
        String devType = pnpForm.getDeviceType() + "_" + pnpForm.getDeviceVersion();
        Map<String, List<FuncTreeNodeInfo>> functionInfos = this.allDevTypeFuncTreeInfos.get(devType);
        if (null == functionInfos) {
            functionInfos = new HashMap<String, List<FuncTreeNodeInfo>>();
        }
        switch (type) {
            case WORKSPACE: {
                functionInfos.put("workspace", treeNodes);
                break;
            }
            case WINDOW: {
                functionInfos.put("window", treeNodes);
                break;
            }
            case ADMIN: {
                functionInfos.put("admintree", treeNodes);
                break;
            }
            case BOARD: {
                functionInfos.put(boardCapTypes, treeNodes);
                break;
            }
            default: {
                functionInfos.put("window", treeNodes);
            }
        }
        this.allDevTypeFuncTreeInfos.put(devType, functionInfos);
    }

    private void analyseTreeFile(List<FuncTreeNodeInfo> funcNodeList, Document treeDoc) {
        List funcNodes = this.xmlUtil.selectNodes((Node)treeDoc, "/treeInfo/funcTree/funcnodes/funcnode");
        PerfLogger.debug((String)"end xmlUtil.selectNodes");
        Element nodeTmp = null;
        for (Node node : funcNodes) {
            nodeTmp = (Element)node;
            FuncTreeNodeInfo nodeInfo = new FuncTreeNodeInfo();
            nodeInfo.setName(nodeTmp.elementText(FUNCTREE_NODE_NAME));
            nodeInfo.setFuncNodeType(this.funcNodeTypeMap.get(nodeTmp.elementText(FUNCTREE_NODE_TYPE)));
            NodeDomain domain = this.nodeDomainMap.get(nodeTmp.elementText(FUNCTREE_NODE_DOMAIN));
            if (null == domain) {
                logger.debug("Exception in analyseTreeFile:domain is null, elementText = " + nodeTmp.elementText(FUNCTREE_NODE_DOMAIN));
            }
            nodeInfo.setNodeDomain(domain);
            nodeInfo.setParentName(nodeTmp.elementText(FUNCTREE_NODE_PARENTNAME));
            nodeInfo.setUnSupportedLR(nodeTmp.elementText(FUNCTREE_NODE_UNSUPPORTEDLR));
            nodeInfo.setUnSupportedVR(nodeTmp.elementText(FUNCTREE_NODE_UNSUPPORTEDVR));
            nodeInfo.setVisiable(nodeTmp.elementText(FUNCTREE_NODE_VISIABLE.trim()).equalsIgnoreCase(String.valueOf(Boolean.TRUE)));
            nodeInfo.setAppearOnce(nodeTmp.elementText(FUNCTREE_NODE_APPEARONCE.trim()).equalsIgnoreCase(String.valueOf(Boolean.TRUE)));
            nodeInfo.setStrDomain(nodeTmp.elementText(FUNCTREE_NODE_DOMAIN));
            funcNodeList.add(nodeInfo);
        }
        PerfLogger.debug((String)"end FuncTreeNodeInfo");
    }

    private List<FuncTreeNodeInfo> dealFeatureTreeNodeMO(MOType funcTreeNodeMOType, List<LightMO> funcTreeMOList, String deviceType, String deviceVersion) throws QatOperException {
        ArrayList<FuncTreeNodeInfo> nodeInfoList = new ArrayList<FuncTreeNodeInfo>();
        ArrayList<FuncTreeNodeInfo> virtualnodeInfoList = new ArrayList<FuncTreeNodeInfo>();
        FuncTreeNodeInfo nodeInfo = null;
        String nodeName = null;
        String nodeParentName = null;
        FuncTreeNodeType nodeType = null;
        String[] name = null;
        String featureName = null;
        String[] parentInfo = null;
        for (LightMO nodeMO : funcTreeMOList) {
            nodeInfo = new FuncTreeNodeInfo();
            nodeName = nodeMO.getAttributeValue("/treeInfo/funcTree/funcnodes/funcnode/name");
            nodeInfo.setAppearOnce(nodeMO.getAttributeValue("/treeInfo/funcTree/funcnodes/funcnode/appearOnce").trim().equalsIgnoreCase(String.valueOf(Boolean.TRUE)));
            nodeInfo.setNodeDomain(this.nodeDomainMap.get(nodeMO.getAttributeValue("/treeInfo/funcTree/funcnodes/funcnode/domain")));
            nodeInfo.setFuncNodeType(this.funcNodeTypeMap.get(nodeMO.getAttributeValue("/treeInfo/funcTree/funcnodes/funcnode/type")));
            nodeInfo.setVisiable(nodeMO.getAttributeValue("/treeInfo/funcTree/funcnodes/funcnode/visiable").trim().equalsIgnoreCase(String.valueOf(Boolean.TRUE)));
            nodeParentName = nodeMO.getAttributeValue("/treeInfo/funcTree/funcnodes/funcnode/parentName");
            nodeType = nodeInfo.getFuncNodeType();
            name = CommonUtil.normalize((String)nodeName).split("]");
            nodeInfo.setVisiable(true);
            if (nodeType.equals((Object)FuncTreeNodeType.FEATURE)) {
                featureName = name[name.length - 1];
                nodeInfo.setFeatureNameWithVersion("");
                nodeInfo.setName(featureName);
                nodeInfo.setParentName("0");
                nodeInfoList.add(nodeInfo);
                continue;
            }
            if (!nodeType.equals((Object)FuncTreeNodeType.CONTENT)) continue;
            featureName = name[name.length - 2];
            nodeInfo.setFeatureNameWithVersion("");
            nodeInfo.setName(featureName + "]" + name[name.length - 1]);
            parentInfo = CommonUtil.normalize((String)nodeParentName).split("]");
            if (parentInfo[parentInfo.length - 1].equals(featureName)) {
                nodeInfo.setParentName(featureName);
            } else {
                nodeInfo.setParentName(parentInfo[parentInfo.length - 2] + "]" + parentInfo[parentInfo.length - 1]);
            }
            nodeInfoList.add(nodeInfo);
            virtualnodeInfoList.addAll(this.genVirtualChildNodeInfos(deviceType, deviceVersion, nodeInfo));
        }
        boolean isFound = false;
        for (FuncTreeNodeInfo nodeInfoTmp : virtualnodeInfoList) {
            isFound = false;
            for (int i = nodeInfoList.size() - 1; i >= 0; --i) {
                FuncTreeNodeInfo nodeInfoTmp1 = (FuncTreeNodeInfo)nodeInfoList.get(i);
                if (!nodeInfoTmp1.equals(nodeInfoTmp)) continue;
                isFound = true;
                nodeInfoList.remove(nodeInfoTmp1);
                nodeInfoList.add(nodeInfoTmp);
                break;
            }
            if (isFound) continue;
            nodeInfoList.add(nodeInfoTmp);
        }
        return nodeInfoList;
    }

    private List<FuncTreeNodeInfo> dealFuncTreeFile(PnpForm pnpForm, String neFlag, NECapabilityInfo neLicCapa, boolean isSupportPartition, TreeType treeType, String boardCapTypes) throws QatOperException {
        PerfLogger.debug((String)"enter dealFuncTreeFile");
        List<FuncTreeNodeInfo> funcMOList = this.getFunctreeNodes(pnpForm, treeType, boardCapTypes);
        PerfLogger.debug((String)"end getFunctreeNodes");
        List<FuncTreeNodeInfo> nodeInfoList = this.getTreeNodeListByDomain(neFlag, funcMOList, isSupportPartition);
        PerfLogger.debug((String)"end getTreeListByDomain");
        this.reduceFuncTreeByBoardCap(nodeInfoList, pnpForm, boardCapTypes);
        List<FuncTreeNodeInfo> funcNodeList = this.getFuncNodeList(neLicCapa, nodeInfoList, treeType);
        PerfLogger.debug((String)"end getFuncNodeList");
        return !CommonUtil.isEmpty(funcNodeList) ? this.delNoChildNodeFromFunc(funcNodeList) : funcNodeList;
    }

    private List<FuncTreeNodeInfo> delNoChildNodeFromFunc(List<FuncTreeNodeInfo> funcNodeList) {
        List<FuncTreeNodeInfo> managerAndFeatureNodeList = this.getManagerAndFeatureListFromFunc(funcNodeList);
        ArrayList<FuncTreeNodeInfo> noChildManagerAndFeatureNodeList = new ArrayList<FuncTreeNodeInfo>();
        Iterator<FuncTreeNodeInfo> managerAndFeatureNodeIter = managerAndFeatureNodeList.iterator();
        FuncTreeNodeInfo managerNode = null;
        boolean isChildExist = true;
        while (managerAndFeatureNodeIter.hasNext()) {
            managerNode = managerAndFeatureNodeIter.next();
            isChildExist = this.getNoChildManagerNodeFromFunc(managerNode.getName(), funcNodeList);
            if (isChildExist) continue;
            noChildManagerAndFeatureNodeList.add(managerNode);
        }
        HashSet<String> parentNameSet = new HashSet<String>();
        if (!noChildManagerAndFeatureNodeList.isEmpty()) {
            Iterator noChildNodeIter = noChildManagerAndFeatureNodeList.iterator();
            FuncTreeNodeInfo noChildManagerAndFeatureNode = null;
            String parentName = null;
            while (noChildNodeIter.hasNext()) {
                noChildManagerAndFeatureNode = (FuncTreeNodeInfo)noChildNodeIter.next();
                parentName = noChildManagerAndFeatureNode.getParentName();
                if (!parentName.equals("0")) {
                    parentNameSet.add(parentName);
                }
                funcNodeList.remove(noChildManagerAndFeatureNode);
            }
        }
        return parentNameSet.isEmpty() ? funcNodeList : this.delParentNodeFromFunc(parentNameSet, funcNodeList);
    }

    private List<FuncTreeNodeInfo> delNodeAppearOnce(List<FuncTreeNodeInfo> funcNodeList) {
        if (funcNodeList == null || funcNodeList.size() == 0) {
            return funcNodeList;
        }
        ArrayList<FuncTreeNodeInfo> appearOnceNodeList = new ArrayList<FuncTreeNodeInfo>();
        FuncTreeNodeInfo node = null;
        Iterator<FuncTreeNodeInfo> iter = funcNodeList.iterator();
        while (iter.hasNext()) {
            node = iter.next();
            if (!node.isAppearOnce()) continue;
            appearOnceNodeList.add(node);
            iter.remove();
        }
        String parentName = null;
        for (FuncTreeNodeInfo treenode : funcNodeList) {
            parentName = treenode.getParentName();
            for (FuncTreeNodeInfo appearOnceNode : appearOnceNodeList) {
                if (!parentName.equals(appearOnceNode.getName())) continue;
                treenode.setParentName(appearOnceNode.getParentName());
            }
        }
        return funcNodeList;
    }

    private List<FuncTreeNodeInfo> delParentNodeFromFunc(Set<String> parentNameSet, List<FuncTreeNodeInfo> funcNodeList) {
        ArrayList<String> delParentNodeList = new ArrayList<String>();
        Iterator<String> pidSetIter = parentNameSet.iterator();
        String pid = null;
        while (pidSetIter.hasNext()) {
            pid = pidSetIter.next();
            if (this.getNoChildManagerNodeFromFunc(pid, funcNodeList)) continue;
            delParentNodeList.add(pid);
        }
        List<FuncTreeNodeInfo> funcTreeNodeList = null;
        if (!delParentNodeList.isEmpty()) {
            ArrayList<FuncTreeNodeInfo> delTreeNodeList = new ArrayList<FuncTreeNodeInfo>();
            HashSet<String> delParentNameSet = new HashSet<String>();
            this.getDelParentNode(funcNodeList, delParentNodeList, delTreeNodeList, delParentNameSet);
            Iterator iter = delTreeNodeList.iterator();
            while (iter.hasNext()) {
                funcNodeList.remove(iter.next());
            }
            funcTreeNodeList = delParentNameSet.isEmpty() ? funcNodeList : this.delParentNodeFromFunc(delParentNameSet, funcNodeList);
        } else {
            funcTreeNodeList = funcNodeList;
        }
        return funcTreeNodeList;
    }

    private String funcTreeByVisiableToString(List<FuncTreeNodeInfo> nodeInfoList) {
        StringBuffer funcTree = new StringBuffer();
        if (nodeInfoList.size() > 0) {
            funcTree.append(this.treeToString(nodeInfoList));
        } else {
            funcTree.append("<funcTreeNodeNum value=\"0\" />");
        }
        return funcTree.toString();
    }

    private List<FuncTreeNodeInfo> genVirtualChildNodeInfos(String pnpDeviceType, String pnpDeviceVersion, FuncTreeNodeInfo nodeInfo) {
        SchemaId schemaId = new SchemaId(pnpDeviceType, pnpDeviceVersion, nodeInfo.getFeatureName(), null, null, null);
        List typeCustomInfos = this.typeCustomInfoMgr.getTypeCustomInfos(schemaId, nodeInfo.getXpath(), GUIType.TEMPLATE);
        List<TypeCustomInfo> availableTypeCustomInfos = this.getAvailableTypeCustomInfos(typeCustomInfos);
        if (CommonUtil.isEmpty(availableTypeCustomInfos)) {
            return Collections.emptyList();
        }
        ArrayList<FuncTreeNodeInfo> virtualChildNodeInfos = new ArrayList<FuncTreeNodeInfo>();
        String parentNodeName = nodeInfo.getName();
        String tmpVirtualChildXpath = null;
        FuncTreeNodeInfo tmpVirtualChildNodeInfo = null;
        for (TypeCustomInfo availableTypeCustomInfo : availableTypeCustomInfos) {
            tmpVirtualChildXpath = availableTypeCustomInfo.getCustomAttributeValue("xpath", "");
            tmpVirtualChildNodeInfo = (FuncTreeNodeInfo)nodeInfo.clone();
            tmpVirtualChildNodeInfo.setName(this.getVirtualChildNodeName(tmpVirtualChildXpath, parentNodeName));
            tmpVirtualChildNodeInfo.setParentName(parentNodeName);
            tmpVirtualChildNodeInfo.setVisiable(false);
            virtualChildNodeInfos.add(tmpVirtualChildNodeInfo);
        }
        return virtualChildNodeInfos;
    }

    private List<FuncTreeNodeInfo> getAdminTreeNodeInfoList(PnpForm pnpForm) {
        if (null == pnpForm) {
            throw new IllegalArgumentException("get Admin Tree File Fild, The parameter pnpForm is null.");
        }
        return this.getFunctreeNodes(pnpForm, TreeType.ADMIN, null);
    }

    private List<TypeCustomInfo> getAvailableTypeCustomInfos(List<TypeCustomInfo> typeCustomInfos) {
        if (CommonUtil.isEmpty(typeCustomInfos)) {
            return Collections.emptyList();
        }
        ArrayList<TypeCustomInfo> availableTypeCustomInfos = new ArrayList<TypeCustomInfo>();
        for (TypeCustomInfo typeCustomInfo : typeCustomInfos) {
            if (!this.availableCustomInfoTypes.contains(typeCustomInfo.getCustomType())) continue;
            availableTypeCustomInfos.add(typeCustomInfo);
        }
        return availableTypeCustomInfos;
    }

    private List<FuncTreeNodeInfo> getDelNodeList(List<FuncTreeNodeInfo> nodeInfoList, String featureName, List<CtrlInfo> elementCapaInfo) {
        ArrayList<FuncTreeNodeInfo> delNodeList = new ArrayList<FuncTreeNodeInfo>();
        Iterator<FuncTreeNodeInfo> treeIter = null;
        FuncTreeNodeInfo treeNode2 = null;
        for (CtrlInfo ctrlInfo : elementCapaInfo) {
            if (!ctrlInfo.getOperationType().equals((Object)CapaOperType.CLASSCTRL)) continue;
            for (FuncTreeNodeInfo treeNode2 : nodeInfoList) {
                this.isTrimNode(featureName, delNodeList, ctrlInfo.getXPath(), treeNode2);
            }
        }
        return delNodeList;
    }

    private void getDelParentNode(List<FuncTreeNodeInfo> funcNodeList, List<String> delParentNodeList, List<FuncTreeNodeInfo> delTreeNodeList, Set<String> delParentNameSet) {
        FuncTreeNodeInfo treeNode2 = null;
        String pName = null;
        Iterator<FuncTreeNodeInfo> treeNodeIter = null;
        for (String parentName : delParentNodeList) {
            for (FuncTreeNodeInfo treeNode2 : funcNodeList) {
                pName = treeNode2.getParentName();
                if (treeNode2.getName().equals(parentName)) {
                    delTreeNodeList.add(treeNode2);
                }
                if (!treeNode2.getName().equals(parentName) || pName.equals("0")) continue;
                delParentNameSet.add(pName);
            }
        }
    }

    private String getFeatureName(FuncTreeNodeInfo typeNode) {
        String feature = null;
        String[] featureNames = CommonUtil.normalize((String)typeNode.getName()).split("]");
        String[] urlInfo = null;
        if (typeNode.getFuncNodeType().equals((Object)FuncTreeNodeType.FEATURE)) {
            feature = featureNames[featureNames.length - 1];
        } else if (typeNode.getFuncNodeType().equals((Object)FuncTreeNodeType.CONTENT)) {
            feature = featureNames[featureNames.length - 2];
        } else if (typeNode.getFuncNodeType().equals((Object)FuncTreeNodeType.URL)) {
            urlInfo = CommonUtil.normalize((String)featureNames[featureNames.length - 1]).split("@");
            feature = urlInfo[0];
        } else {
            feature = null;
        }
        return feature;
    }

    private List<FuncTreeNodeInfo> getFuncNodeList(NECapabilityInfo neLicCapa, List<FuncTreeNodeInfo> nodeInfoList, TreeType type) {
        if (CommonUtil.isEmpty(neLicCapa.getNECapaInfoMap())) {
            return nodeInfoList;
        }
        ArrayList<String> featureTypeNode = new ArrayList<String>();
        Iterator<FuncTreeNodeInfo> funcTreeListIter = nodeInfoList.iterator();
        FuncTreeNodeInfo typeNode = null;
        String feature = null;
        while (funcTreeListIter.hasNext()) {
            typeNode = funcTreeListIter.next();
            feature = this.getFeatureName(typeNode);
            if (!typeNode.getFuncNodeType().equals((Object)FuncTreeNodeType.FEATURE)) continue;
            featureTypeNode.add(feature);
        }
        Map<String, FeatureCapaInfo> licCapaMap = neLicCapa.getNECapaInfoMap();
        String featureFileName = null;
        Iterator<FuncTreeNodeInfo> iter = null;
        List<FuncTreeNodeInfo> delNodeList = null;
        for (String featureName : featureTypeNode) {
            featureFileName = featureName + ".xsd";
            if (!licCapaMap.containsKey(featureFileName)) continue;
            delNodeList = this.getDelNodeList(nodeInfoList, featureName, licCapaMap.get(featureFileName).getElementCapaInfo());
            iter = delNodeList.iterator();
            while (iter.hasNext()) {
                nodeInfoList.remove(iter.next());
            }
        }
        return nodeInfoList;
    }

    private Document getFuncTreeDoc(PnpForm pnpForm, TreeType type, String boardCapTypes) {
        String key = pnpForm.getDeviceType() + "_" + pnpForm.getDeviceVersion() + "_" + type.getDescription();
        Document treeDoc = null;
        if (this.allDevTypeTreeInfoDoc.containsKey(key) && null != (treeDoc = this.allDevTypeTreeInfoDoc.get(key))) {
            return treeDoc;
        }
        try {
            String funcTreeFilePath = Util.getFunctreeFilePath(pnpForm.getDeviceType(), pnpForm.getDeviceVersion(), type, boardCapTypes);
            PerfLogger.debug((String)"enter xmlUtil.getDocument");
            treeDoc = this.xmlUtil.getDocument(funcTreeFilePath);
            PerfLogger.debug((String)"end xmlUtil.getDocument");
        }
        catch (DocumentException e) {
            logger.error("parse tree file error.", (Throwable)e);
            return null;
        }
        this.allDevTypeTreeInfoDoc.put(key, treeDoc);
        return treeDoc;
    }

    private OperResult<List<FuncTreeNodeInfo>, Void> getFuncTreeNodeInfoList(PnpForm pnpForm, String neFlag, String sessionId, String neId, String isWorkSpace, String devIP, String boardCapTypes) {
        boolean isSupVRPartition = this.lrvrCapabilityMgr.isSupportMultiVR(pnpForm.getDeviceType(), pnpForm.getDeviceVersion());
        OperResult operResult = new OperResult();
        DeviceInfo devInfo = this.deviceMgr.getCurrentDeviceInfo(sessionId, devIP);
        if (null == devInfo) {
            operResult.setResultType(OperResultType.OPER_NOK);
            operResult.addError(1107525641);
            logger.error("Getting device information failed!");
            return operResult;
        }
        PerfLogger.debug((String)"start getNELicCapa");
        OperResult<NECapabilityInfo, Void> licInfo = this.capaInfoMgr.getNELicCapa(sessionId, neId);
        if (OperResultType.OPER_OK != licInfo.getResultType()) {
            logger.info("The method getFunctionTree: Query License infomation failed.");
            operResult.setResultType(OperResultType.OPER_NOK);
            operResult.addErrors(licInfo.getErrors());
            return operResult;
        }
        PerfLogger.debug((String)"end getNELicCapa");
        List<FuncTreeNodeInfo> nodeInfoList = null;
        try {
            nodeInfoList = this.getFuncTreeNodeInfoList(pnpForm, neFlag, (NECapabilityInfo)licInfo.getReturnObj(), isWorkSpace, isSupVRPartition, boardCapTypes);
            operResult.setReturnObj(nodeInfoList);
        }
        catch (QatOperException e) {
            logger.error("Getting list of FuncTreeNodeInfo failed!", (Throwable)e);
            operResult.setResultType(OperResultType.OPER_NOK);
            operResult.addError(1107525641);
            return operResult;
        }
        return operResult;
    }

    private List<FuncTreeNodeInfo> getFunctreeNodes(PnpForm pnpForm, TreeType type, String boardCapTypes) {
        PerfLogger.debug((String)"enter List<FuncTreeNodeInfo> getFunctreeNodes");
        logger.debug("Debug functiontree cut : function tree type = " + (Object)((Object)type) + "; boardCapTypes = " + boardCapTypes);
        String devType = pnpForm.getDeviceType() + "_" + pnpForm.getDeviceVersion();
        Map<String, List<FuncTreeNodeInfo>> functionInfos = this.allDevTypeFuncTreeInfos.get(devType);
        ArrayList<FuncTreeNodeInfo> funcNodeList = null;
        if (null != functionInfos) {
            List<FuncTreeNodeInfo> funcTreeInfoLst = null;
            switch (type) {
                case WINDOW: {
                    funcTreeInfoLst = functionInfos.get(TreeType.WINDOW.getDescription());
                    break;
                }
                case WORKSPACE: {
                    funcTreeInfoLst = functionInfos.get(TreeType.WORKSPACE.getDescription());
                    break;
                }
                case ADMIN: {
                    funcTreeInfoLst = functionInfos.get(TreeType.ADMIN.getDescription());
                    break;
                }
                case BOARD: {
                    funcTreeInfoLst = functionInfos.get(boardCapTypes);
                    break;
                }
                default: {
                    logger.debug("no control");
                }
            }
            if (null != funcTreeInfoLst) {
                funcNodeList = new ArrayList();
                for (FuncTreeNodeInfo nodeInfo : funcTreeInfoLst) {
                    FuncTreeNodeInfo cloneNodeInfo = (FuncTreeNodeInfo)nodeInfo.clone();
                    funcNodeList.add(cloneNodeInfo);
                }
                return funcNodeList;
            }
        }
        funcNodeList = new ArrayList<FuncTreeNodeInfo>();
        Document treeDoc = this.getFuncTreeDoc(pnpForm, type, boardCapTypes);
        if (null == treeDoc) {
            return null;
        }
        this.analyseTreeFile(funcNodeList, treeDoc);
        this.addFunctreeMosInfoToMemory(pnpForm, funcNodeList, type, boardCapTypes);
        PerfLogger.debug((String)"exit List<FuncTreeNodeInfo> getFunctreeNodes");
        return funcNodeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFuncTreeSchema() {
        if (null != funcTreeSchema) {
            return;
        }
        Class<FunctionTreeMgrImpl> clazz = FunctionTreeMgrImpl.class;
        synchronized (FunctionTreeMgrImpl.class) {
            if (null == funcTreeSchema) {
                funcTreeSchema = this.schemaBuilder.buildSchema(CapabilityMgrConstants.TREE_INFO_SCHEMA_PATH);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private List<FuncTreeNodeInfo> getManagerAndFeatureListFromFunc(List<FuncTreeNodeInfo> funcNodeList) {
        ArrayList<FuncTreeNodeInfo> managerAndFeatureNodeList = new ArrayList<FuncTreeNodeInfo>();
        if (!funcNodeList.isEmpty()) {
            for (FuncTreeNodeInfo typeNode : funcNodeList) {
                FuncTreeNodeType funcNodeType = typeNode.getFuncNodeType();
                if (!funcNodeType.equals((Object)FuncTreeNodeType.MANAGER) && !funcNodeType.equals((Object)FuncTreeNodeType.FEATURE)) continue;
                managerAndFeatureNodeList.add(typeNode);
            }
        }
        return managerAndFeatureNodeList;
    }

    private List<LightMO> getMOListByDomain(String neType, List<LightMO> funcTreeMOList) {
        ArrayList<LightMO> moList = new ArrayList<LightMO>();
        Iterator<LightMO> moListIter = funcTreeMOList.iterator();
        LightMO nodeMO = null;
        String domain = null;
        while (moListIter.hasNext()) {
            nodeMO = moListIter.next();
            domain = nodeMO.getAttributeValue("/treeInfo/funcTree/funcnodes/funcnode/domain");
            if (!this.isNodeOfDomain(neType, domain)) continue;
            moList.add(nodeMO);
        }
        return moList;
    }

    private boolean getNoChildManagerNodeFromFunc(String parentName, List<FuncTreeNodeInfo> funcNodeList) {
        int childNum = 0;
        if (!funcNodeList.isEmpty()) {
            Iterator<FuncTreeNodeInfo> funcTreeListIter = funcNodeList.iterator();
            while (funcTreeListIter.hasNext()) {
                if (!funcTreeListIter.next().getParentName().equals(parentName)) continue;
                ++childNum;
                break;
            }
        }
        return childNum > 0;
    }

    private List<FuncTreeNodeInfo> getNodeListByDomain(String neType, List<FuncTreeNodeInfo> funcTreeNodeList) {
        ArrayList<FuncTreeNodeInfo> nodeList = new ArrayList<FuncTreeNodeInfo>();
        if (CommonUtil.isEmpty(funcTreeNodeList)) {
            return nodeList;
        }
        for (FuncTreeNodeInfo node : funcTreeNodeList) {
            if (!this.isNodeOfDomain(neType, node.getStrDomain())) continue;
            nodeList.add(node);
        }
        return nodeList;
    }

    private List<FuncTreeNodeInfo> getTreeNodeListByDomain(String neFlag, List<FuncTreeNodeInfo> funcNodeList, boolean isSupportPartition) {
        List<FuncTreeNodeInfo> moLst = funcNodeList;
        ArrayList<FuncTreeNodeInfo> removeNodeLst = new ArrayList<FuncTreeNodeInfo>();
        List<FuncTreeNodeInfo> lrLst = this.getNodeListByDomain("LR", funcNodeList);
        List<FuncTreeNodeInfo> lradminLst = this.getNodeListByDomain("LR-Admin", funcNodeList);
        PerfLogger.debug((String)"end getMOListByDomain");
        if (isSupportPartition) {
            if ("VR".equals(neFlag)) {
                removeNodeLst.addAll(lrLst);
                removeNodeLst.addAll(lradminLst);
            }
        } else {
            removeNodeLst.addAll(lradminLst);
        }
        for (FuncTreeNodeInfo node : removeNodeLst) {
            moLst.remove(node);
            logger.info("Debug functiontree cut :domain remove node " + node.getName());
        }
        return moLst;
    }

    private String getVirtualChildNodeName(String xpath, String parentName) {
        int xpathIndex = parentName.lastIndexOf("]") + 1;
        return parentName.substring(0, xpathIndex) + xpath;
    }

    private void initFunctreeInfos() {
        PerfLogger.debug((String)"enter initFunctreeInfos()");
        IApplyDifference appDiff = (IApplyDifference)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(IApplyDifference.class);
        if (null != appDiff) {
            appDiff.initFunctreeInfos();
            return;
        }
        if (SessionDataHolder.isIndependence()) {
            return;
        }
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                PerfLogger.debug((String)"enter ThreadPool.getInstance().execute(new Runnable() initFunctreeInfos()");
                Map devInfoMap = FunctionTreeMgrImpl.this.deviceMgrIntegration.getManagedDeviceTypesAndVersions();
                for (String devType : devInfoMap.keySet()) {
                    List versions = (List)devInfoMap.get(devType);
                    if (null == versions) continue;
                    for (String version : (List)devInfoMap.get(devType)) {
                        FunctionTreeMgrImpl.this.getFunctreeNodes(new PnpForm(devType, version), TreeType.WINDOW, null);
                    }
                }
            }
        });
    }

    private boolean isNodeOfDomain(String neType, String attrValue) {
        return neType.equalsIgnoreCase(attrValue);
    }

    private void isTrimNode(String featureName, List<FuncTreeNodeInfo> delNodeList, String xPath, FuncTreeNodeInfo treeNode) {
        String[] featureNames = CommonUtil.normalize((String)treeNode.getName()).split("]");
        if (xPath.equals(".") && treeNode.getFuncNodeType().equals((Object)FuncTreeNodeType.FEATURE) && featureNames[featureNames.length - 1].equals(featureName)) {
            delNodeList.add(treeNode);
            logger.info("Debug functiontree cut : feature treeNode = " + treeNode.getName());
        } else if (treeNode.getFuncNodeType().equals((Object)FuncTreeNodeType.CONTENT) && featureNames[featureNames.length - 1].equals(xPath)) {
            logger.info("Debug functiontree cut : content treeNode = " + treeNode.getName());
            delNodeList.add(treeNode);
        }
    }

    private TreeType isWorkspace(String isWorkSpace) {
        TreeType type = isWorkSpace.equals(String.valueOf(Boolean.TRUE)) ? TreeType.WORKSPACE : TreeType.WINDOW;
        return type;
    }

    private void reduceFuncTreeByBoardCap(List<FuncTreeNodeInfo> nodeInfoList, PnpForm pnpForm, String boardCapTypes) {
        logger.info("Debug functiontree cut :  boardCapTypes = " + boardCapTypes);
        if (boardCapTypes == null) {
            return;
        }
        Iterator<FuncTreeNodeInfo> iterator = nodeInfoList.iterator();
        while (iterator.hasNext()) {
            FuncTreeNodeInfo funcTreeNodeInfo = iterator.next();
            FuncTreeNodeType funcNodeType = funcTreeNodeInfo.getFuncNodeType();
            if (FuncTreeNodeType.URL.equals((Object)funcNodeType)) {
                iterator.remove();
                continue;
            }
            if (FuncTreeNodeType.CUSTOMURL.equals((Object)funcTreeNodeInfo.getFuncNodeType()) && !this.boardCapMgr.isFuncTreeSupport(pnpForm.getDeviceType(), pnpForm.getDeviceVersion(), boardCapTypes, funcTreeNodeInfo.getName())) {
                logger.info("Debug functiontree cut : funcTreeNodeInfoName = " + funcTreeNodeInfo.getName() + " ; boardCapTypes = " + boardCapTypes);
                iterator.remove();
            }
            if (!FuncTreeNodeType.CONTENT.equals((Object)funcTreeNodeInfo.getFuncNodeType()) || this.boardCapMgr.isFuncTreeSupport(pnpForm.getDeviceType(), pnpForm.getDeviceVersion(), boardCapTypes, funcTreeNodeInfo.getName())) continue;
            logger.info("Debug functiontree cut : funcTreeNodeInfoName = " + funcTreeNodeInfo.getName() + " ; boardCapTypes = " + boardCapTypes);
            iterator.remove();
        }
    }

    private String treeToString(List<FuncTreeNodeInfo> nodeInfoList) {
        StringBuffer funcTree = new StringBuffer();
        int i = 0;
        for (FuncTreeNodeInfo nodeInfo : nodeInfoList) {
            if (!nodeInfo.isVisiable()) continue;
            ++i;
            funcTree.append("<object name=\"");
            funcTree.append(nodeInfo.getName());
            funcTree.append("\" parentName=\"");
            funcTree.append(nodeInfo.getParentName());
            funcTree.append("\" nodeType=\"");
            funcTree.append((Object)nodeInfo.getFuncNodeType());
            funcTree.append("\" visiable=\"");
            funcTree.append(nodeInfo.isVisiable());
            funcTree.append("\" domain=\"");
            funcTree.append(nodeInfo.getNodeDomain().getDescription());
            funcTree.append("\" appearOnce=\"");
            funcTree.append(nodeInfo.isAppearOnce());
            funcTree.append("\" unSupportedLR=\"");
            funcTree.append(nodeInfo.getUnSupportedLR());
            funcTree.append("\" unSupportedVR=\"");
            funcTree.append(nodeInfo.getUnSupportedVR());
            if (null != nodeInfo.getFeatureNameWithVersion()) {
                funcTree.append("\" featureNameWithVersion=\"");
                funcTree.append(nodeInfo.getFeatureNameWithVersion());
                funcTree.append("\" />");
                continue;
            }
            funcTree.append("\" featureNamePath=\"\" />");
        }
        funcTree.append("<funcTreeNodeNum value=\"");
        funcTree.append(i);
        funcTree.append("\" />");
        return funcTree.toString();
    }

    static {
        logger = RunLogger.getRunLogger();
    }
}

