/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.capabilitymgr.functreemgr.impl;

import com.huawei.vmf.qat.capabilitymgr.domain.boardcap.Attribute;
import com.huawei.vmf.qat.capabilitymgr.domain.boardcap.BoardCap;
import com.huawei.vmf.qat.capabilitymgr.domain.boardcap.BoardCapExt;
import com.huawei.vmf.qat.capabilitymgr.domain.boardcap.FuncUnit;
import com.huawei.vmf.qat.capabilitymgr.domain.boardcap.FuncUnitExt;
import com.huawei.vmf.qat.capabilitymgr.domain.boardcap.SchemaInfo;
import com.huawei.vmf.qat.capabilitymgr.functreemgr.BoardCapabilityMgr;
import com.huawei.vmf.qat.capabilitymgr.util.CapabilityMgrConstants;
import com.huawei.vmf.qat.common.log.RunLogger;
import com.huawei.vmf.qat.schemaprocessor.infomodel.MOType;
import com.huawei.vmf.qat.schemaprocessor.infomodel.Schema;
import com.huawei.vmf.qat.schemaprocessor.infomodel.SchemaBuilder;
import com.huawei.vmf.qat.xmlprocessor.infomodel.LightMO;
import com.huawei.vmf.qat.xmlprocessor.infomodel.LightMOTree;
import com.huawei.vmf.qat.xmlprocessor.infomodel.MOXMLBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BoardCapabilityMgrImpl
implements BoardCapabilityMgr {
    private Map<String, BoardCapExt> boardCapExtMap = new HashMap<String, BoardCapExt>();
    private Schema boardCapExtSchema;
    private Map<String, BoardCap> boardCapMap = new HashMap<String, BoardCap>();
    private Schema boardCapSchema;
    private Logger logger = RunLogger.getRunLogger();
    private MOXMLBuilder moXMLBuilder;
    private SchemaBuilder schemaBuilder;

    @Override
    public BoardCapExt getBoardCapExt(String deviceType, String deviceVersion) {
        return this.parserBoardCapExtFile(deviceType, deviceVersion);
    }

    public MOXMLBuilder getMoXMLBuilder() {
        return this.moXMLBuilder;
    }

    public SchemaBuilder getSchemaBuilder() {
        return this.schemaBuilder;
    }

    @Override
    public boolean isBoardMenuSupport(String deviceType, String deviceVersion, String boardCapTypes, String boardMenuId) {
        BoardCapExt boardCapExt = this.parserBoardCapExtFile(deviceType, deviceVersion);
        FuncUnitExt funcUnitExt = boardCapExt.getFuncUnitExtByBoardMenuId(boardMenuId);
        if (null == funcUnitExt) {
            return false;
        }
        String id = funcUnitExt.getId();
        Map<String, BoardCap> boardCapMap = this.getBoardCapMap(deviceType, deviceVersion, boardCapTypes);
        for (Map.Entry<String, BoardCap> entry : boardCapMap.entrySet()) {
            BoardCap boardCap = entry.getValue();
            FuncUnit funcUnit = boardCap.getFuncUnit(id);
            if (null == funcUnit || !funcUnit.isSupport()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFuncTreeSupport(String deviceType, String deviceVersion, String boardCapTypes, String funcTreeId) {
        BoardCapExt boardCapExt = this.parserBoardCapExtFile(deviceType, deviceVersion);
        if (null == boardCapExt) {
            return false;
        }
        FuncUnitExt funcUnitExt = boardCapExt.getFuncUnitExtByFuncTreeId(funcTreeId);
        if (null == funcUnitExt) {
            return false;
        }
        String id = funcUnitExt.getId();
        Map<String, BoardCap> boardCapMap = this.getBoardCapMap(deviceType, deviceVersion, boardCapTypes);
        for (Map.Entry<String, BoardCap> entry : boardCapMap.entrySet()) {
            BoardCap boardCap = entry.getValue();
            FuncUnit funcUnit = boardCap.getFuncUnit(id);
            if (null == funcUnit || !funcUnit.isSupport()) continue;
            return true;
        }
        return false;
    }

    public void setMoXMLBuilder(MOXMLBuilder moXMLBuilder) {
        this.moXMLBuilder = moXMLBuilder;
    }

    public void setSchemaBuilder(SchemaBuilder schemaBuilder) {
        this.schemaBuilder = schemaBuilder;
    }

    private String getBoardCapabilityExtPath(String deviceType, String deviceVersion) {
        String boardCapTypeCapDirPath = CapabilityMgrConstants.DEVICE_ROOT_PATH + File.separator + deviceType + File.separator + deviceVersion + File.separator + "default" + File.separator + "panel" + File.separator + "boardcapabilityext" + File.separator + "boardcapext.xml";
        return boardCapTypeCapDirPath;
    }

    private String getBoardCapabilityPath(String deviceType, String deviceVersion, String boardCapType) {
        String boardCapTypeCapDirPath = CapabilityMgrConstants.DEVICE_ROOT_PATH + File.separator + deviceType + File.separator + deviceVersion + File.separator + "default" + File.separator + "panel" + File.separator + "boardcapability" + File.separator + boardCapType + ".xml";
        return boardCapTypeCapDirPath;
    }

    private String getBoardCapExtSchemaPath() {
        String schemaPath = CapabilityMgrConstants.CONF_PATH + File.separator + "qat" + File.separator + "vmtschema" + File.separator + "panel" + File.separator + "boardcapabilityext.xsd";
        return schemaPath;
    }

    private Map<String, BoardCap> getBoardCapMap(String deviceType, String deviceVersion, String boardCapTypes) {
        String[] types;
        HashMap<String, BoardCap> boardMap = new HashMap<String, BoardCap>();
        for (String type : types = boardCapTypes.split("-")) {
            BoardCap boardCap = this.parserBoardCapFile(deviceType, deviceVersion, type);
            if (null == boardCap) continue;
            boardMap.put(type, boardCap);
        }
        return boardMap;
    }

    private String getBoardCapSchemaPath() {
        String schemaPath = CapabilityMgrConstants.CONF_PATH + File.separator + "qat" + File.separator + "vmtschema" + File.separator + "panel" + File.separator + "boardcapability.xsd";
        return schemaPath;
    }

    private BoardCapExt parserBoardCapExtFile(String deviceType, String deviceVersion) {
        String key = deviceType + "_" + deviceVersion;
        if (this.boardCapExtMap.containsKey(key)) {
            return this.boardCapExtMap.get(key);
        }
        String boardCapExtPath = this.getBoardCapabilityExtPath(deviceType, deviceVersion);
        if (!new File(boardCapExtPath).exists()) {
            this.logger.error("the file does not exist. the file path : " + boardCapExtPath);
            return null;
        }
        this.parserBoardCapExtSchema();
        if (null == this.boardCapExtSchema) {
            this.logger.error("schema is null. schema path : " + this.getBoardCapExtSchemaPath());
            return null;
        }
        MOType funcUnitExtMoType = this.boardCapExtSchema.getMOType("/boardCapExt/funcUnits/funcUnit");
        LightMOTree moXML = this.moXMLBuilder.buildMOXMLByURL(boardCapExtPath, this.boardCapExtSchema);
        List funcUnitExtMos = moXML.getMOList(funcUnitExtMoType);
        HashMap<String, FuncUnitExt> funcUnitExtMap = new HashMap<String, FuncUnitExt>();
        for (LightMO funcUnitMo : funcUnitExtMos) {
            FuncUnitExt funcUnitExt = new FuncUnitExt();
            String id = funcUnitMo.getAttributeValue("/boardCapExt/funcUnits/funcUnit/id");
            String funcTreeId = funcUnitMo.getAttributeValue("/boardCapExt/funcUnits/funcUnit/funcTreeId");
            String boardMenuId = funcUnitMo.getAttributeValue("/boardCapExt/funcUnits/funcUnit/boardMenuId");
            funcUnitExt.setId(id);
            funcUnitExt.setFuncTreeId(funcTreeId);
            funcUnitExt.setBoardMenuId(boardMenuId);
            ArrayList<SchemaInfo> schemaInfos = new ArrayList<SchemaInfo>();
            List schemaInfoMos = funcUnitMo.getChildren("/boardCapExt/funcUnits/funcUnit/schemaInfos/schemaInfo");
            for (LightMO schemaInfoMo : schemaInfoMos) {
                SchemaInfo schemaInfo = new SchemaInfo();
                String objXpath = schemaInfoMo.getAttributeValue("/boardCapExt/funcUnits/funcUnit/schemaInfos/schemaInfo/objXpath");
                schemaInfo.setObjXpath(objXpath);
                ArrayList<Attribute> attributes = new ArrayList<Attribute>();
                List attrMos = schemaInfoMo.getChildren("/boardCapExt/funcUnits/funcUnit/schemaInfos/schemaInfo/attributes/attribute");
                for (LightMO attrMo : attrMos) {
                    Attribute attribute = new Attribute();
                    String attrXpath = attrMo.getAttributeValue("/boardCapExt/funcUnits/funcUnit/schemaInfos/schemaInfo/attributes/attribute/attrXpath");
                    attribute.setAttrXpath(attrXpath);
                    String attrValue = attrMo.getAttributeValue("/boardCapExt/funcUnits/funcUnit/schemaInfos/schemaInfo/attributes/attribute/value");
                    String[] attrValues = null == attrValue ? ArrayUtils.EMPTY_STRING_ARRAY : attrValue.replaceAll(" ", "").split(",");
                    attribute.setValues(CollectionUtils.arrayToList((Object)attrValues));
                    attributes.add(attribute);
                }
                schemaInfo.setAttributes(attributes);
                schemaInfos.add(schemaInfo);
            }
            funcUnitExt.setSchemaInfos(schemaInfos);
            funcUnitExtMap.put(id, funcUnitExt);
        }
        BoardCapExt boardCapExt = new BoardCapExt(funcUnitExtMap);
        this.boardCapExtMap.put(key, boardCapExt);
        return boardCapExt;
    }

    private void parserBoardCapExtSchema() {
        if (null == this.boardCapExtSchema) {
            String schemaPath = this.getBoardCapExtSchemaPath();
            if (!new File(schemaPath).exists()) {
                this.logger.error("the file does not exist. the file path : " + schemaPath);
                return;
            }
            this.boardCapExtSchema = this.schemaBuilder.buildSchema(schemaPath);
        }
    }

    private BoardCap parserBoardCapFile(String deviceType, String deviceVersion, String boardCapType) {
        String key = deviceType + "_" + deviceVersion + "_" + boardCapType;
        if (this.boardCapMap.containsKey(key)) {
            return this.boardCapMap.get(key);
        }
        String boardCapPath = this.getBoardCapabilityPath(deviceType, deviceVersion, boardCapType);
        if (!new File(boardCapPath).exists()) {
            this.logger.error("the file does not exist. the file path : " + boardCapPath);
            return null;
        }
        BoardCap boardCap = new BoardCap();
        this.parserBoardCapSchema();
        if (null == this.boardCapSchema) {
            this.logger.error("schema is null. schema path : " + this.getBoardCapSchemaPath());
            return null;
        }
        MOType funcUnitMoType = this.boardCapSchema.getMOType("/boardCap/funcUnits/funcUnit");
        LightMOTree moXML = this.moXMLBuilder.buildMOXMLByURL(boardCapPath, this.boardCapSchema);
        List funcUnitMos = moXML.getMOList(funcUnitMoType);
        HashMap<String, FuncUnit> funcUnitMap = new HashMap<String, FuncUnit>();
        for (LightMO funcUnitMo : funcUnitMos) {
            FuncUnit funcUnit = new FuncUnit();
            String id = funcUnitMo.getAttributeValue("/boardCap/funcUnits/funcUnit/id");
            String support = funcUnitMo.getAttributeValue("/boardCap/funcUnits/funcUnit/support");
            funcUnit.setSupport(StringUtils.endsWithIgnoreCase((String)support, (String)"1"));
            funcUnit.setId(id);
            funcUnitMap.put(id, funcUnit);
        }
        boardCap.setFuncUnitMap(funcUnitMap);
        this.boardCapMap.put(key, boardCap);
        return boardCap;
    }

    private void parserBoardCapSchema() {
        if (null == this.boardCapSchema) {
            String schemaPath = this.getBoardCapSchemaPath();
            if (!new File(schemaPath).exists()) {
                this.logger.error("the file does not exist. the file path : " + schemaPath);
                return;
            }
            this.boardCapSchema = this.schemaBuilder.buildSchema(schemaPath);
        }
    }
}

