/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.qat.capabilitymgr.domain.boardcap;

import com.huawei.vmf.qat.capabilitymgr.domain.boardcap.FuncUnitExt;
import com.huawei.vmf.qat.common.CommonUtil;
import java.util.HashMap;
import java.util.Map;

public class BoardCapExt {
    private Map<String, FuncUnitExt> funcUnitExtMap = new HashMap<String, FuncUnitExt>();
    private Map<String, FuncUnitExt> funcTreeIdToFuncUnitExtMap = new HashMap<String, FuncUnitExt>();
    private Map<String, FuncUnitExt> boardMenuIdToFuncUnitExtMap = new HashMap<String, FuncUnitExt>();

    public BoardCapExt(Map<String, FuncUnitExt> funcUnitExtMap) {
        this.funcUnitExtMap = funcUnitExtMap;
        for (Map.Entry<String, FuncUnitExt> entity : this.funcUnitExtMap.entrySet()) {
            FuncUnitExt funcUnitExt = entity.getValue();
            String funcTreeId = funcUnitExt.getFuncTreeId();
            String boardMenuId = funcUnitExt.getBoardMenuId();
            if (!CommonUtil.isEmpty((CharSequence)funcTreeId)) {
                this.funcTreeIdToFuncUnitExtMap.put(funcTreeId, funcUnitExt);
            }
            if (CommonUtil.isEmpty((CharSequence)boardMenuId)) continue;
            this.boardMenuIdToFuncUnitExtMap.put(boardMenuId, funcUnitExt);
        }
    }

    public FuncUnitExt getFuncUnitExtByFuncTreeId(String funcTreeId) {
        if (this.funcTreeIdToFuncUnitExtMap.containsKey(funcTreeId)) {
            return this.funcTreeIdToFuncUnitExtMap.get(funcTreeId);
        }
        return null;
    }

    public FuncUnitExt getFuncUnitExtByBoardMenuId(String boardMenuId) {
        if (this.boardMenuIdToFuncUnitExtMap.containsKey(boardMenuId)) {
            return this.boardMenuIdToFuncUnitExtMap.get(boardMenuId);
        }
        return null;
    }

    public Map<String, FuncUnitExt> getFuncUnitExtMap() {
        return this.funcUnitExtMap;
    }

    public void setFuncUnitExtMap(Map<String, FuncUnitExt> funcUnitExtMap) {
        this.funcUnitExtMap = funcUnitExtMap;
    }

    public Map<String, FuncUnitExt> getFuncTreeIdToFuncUnitExtMap() {
        return this.funcTreeIdToFuncUnitExtMap;
    }

    public void setFuncTreeIdToFuncUnitExtMap(Map<String, FuncUnitExt> funcTreeIdToFuncUnitExtMap) {
        this.funcTreeIdToFuncUnitExtMap = funcTreeIdToFuncUnitExtMap;
    }

    public Map<String, FuncUnitExt> getBoardMenuIdToFuncUnitExtMap() {
        return this.boardMenuIdToFuncUnitExtMap;
    }

    public void setBoardMenuIdToFuncUnitExtMap(Map<String, FuncUnitExt> boardMenuIdToFuncUnitExtMap) {
        this.boardMenuIdToFuncUnitExtMap = boardMenuIdToFuncUnitExtMap;
    }
}

