/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.util;

import com.huawei.vmf.netconf.error.BadMessageFormatException;
import com.huawei.vmf.netconf.tool.XmlUtil;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class VTDNavAdapter {
    public static XMLStreamReader createStAXFactory(String response) throws BadMessageFormatException {
        if (response == null) {
            return null;
        }
        XMLInputFactory factory = XmlUtil.newXMLInputFactory();
        try {
            XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(response.trim()));
            return reader;
        }
        catch (XMLStreamException e) {
            throw new BadMessageFormatException("rpc-reply is not illegal.", (Throwable)e);
        }
    }

    public static String getStringAttribute(XMLStreamReader reader, String attributeName, String defaultValue) {
        String attr = reader.getAttributeValue(null, attributeName);
        if (attr == null || "".equals(attr)) {
            return defaultValue;
        }
        return attr;
    }

    public static int getIntAttribute(XMLStreamReader reader, String attributeName, int defaultValue) {
        String attr = reader.getAttributeValue(null, attributeName);
        try {
            if (attr != null) {
                return Integer.parseInt(attr.trim());
            }
            return defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static String getElementText(XMLStreamReader reader, String tag) throws XMLStreamException {
        StringWriter out = new StringWriter();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(out);
        int eventType = reader.next();
        while (true) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                writer.writeCharacters(reader.getText());
            } else if (eventType == 1) {
                writer.writeStartElement(reader.getLocalName());
                int nsCnt = reader.getNamespaceCount();
                for (int i = 0; i < nsCnt; ++i) {
                    writer.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                }
                int cnt = reader.getAttributeCount();
                for (int i = 0; i < cnt; ++i) {
                    writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                }
            } else if (eventType == 2) {
                if (tag.equals(reader.getLocalName())) break;
                writer.writeEndElement();
            }
            eventType = reader.next();
        }
        return out.toString().trim();
    }

    public static String encodeXmlText(String text) {
        if (text == null) {
            return null;
        }
        char[] chars = new char[text.length()];
        text.getChars(0, text.length(), chars, 0);
        StringBuilder buf = new StringBuilder();
        block7: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '&': {
                    buf.append("&amp;");
                    continue block7;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    buf.append("&apos;");
                    continue block7;
                }
                default: {
                    buf.append(chars[i]);
                }
            }
        }
        return buf.toString();
    }
}

