/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HWContextUtil {
    public static final int DEFAULT_VR_ID = 0;
    public static final int DEFAULT_LR_ID = 0;
    public static final String HWCONTEXT_ATTR = "hwcontext";
    public static final String LR = "ls";
    public static final String VR = "vs";
    private static final Pattern PATTERN = Pattern.compile("(?:ls=(\\d+))?(?:vs=(\\d+))?");

    public static String contextValue(Integer lrID, Integer vrID) {
        StringBuffer buf = new StringBuffer();
        if (lrID != null) {
            buf.append(LR);
            buf.append('=');
            buf.append(lrID);
        }
        if (vrID != null) {
            buf.append(VR);
            buf.append('=');
            buf.append(vrID);
        }
        return buf.toString();
    }

    public static Map<String, Integer> lrvrValue(String context) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (context == null) {
            return map;
        }
        boolean LR_GROUP = true;
        int VR_GROUP = 2;
        Matcher matcher = PATTERN.matcher(context);
        if (matcher.matches()) {
            String vr;
            String lr = matcher.group(1);
            if (lr != null) {
                map.put(LR, Integer.parseInt(lr));
            }
            if ((vr = matcher.group(2)) != null) {
                map.put(VR, Integer.parseInt(vr));
            }
        }
        return map;
    }
}

