/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.transport;

import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.error.AuthenticationException;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.error.NetconfTimeoutException;
import com.huawei.vmf.netconf.error.TransportIOException;
import com.huawei.vmf.netconf.tool.PlatformCipherTool;
import com.huawei.vmf.netconf.transport.AbstractTransport;
import com.huawei.vmf.netconf.transport.ByteArrayMerger;
import com.huawei.vmf.netconf.transport.ITransportListener;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.ConnectionMonitor;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.channel.ISessionHandler;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSH
extends AbstractTransport
implements ConnectionMonitor {
    private static final int DEFAULT_CHANNEL_CONNECT_TIME_OUT = 20000;
    private static Logger logger = LoggerFactory.getLogger(SSH.class);
    private static final int PWD_END_FLAG_LENGTH = "]]-]]--".length();
    private static final int PWD_START_FLAG_LENGTH = "++[[+[[".length();
    private CommunicateArg arg;
    private Connection conn;
    private AtomicBoolean isSelfClose = new AtomicBoolean(false);
    private Session sess;

    @Override
    public synchronized boolean close() {
        this.isSelfClose.set(true);
        boolean success = null != this.conn;
        this.listeners.clear();
        this.clearRecvBuffer();
        this.closeSession();
        this.closeConnection();
        logger.info("close transport ip={}, success={}", (Object)this.arg.getIp(), (Object)success);
        return success;
    }

    @Override
    public synchronized void connect(CommunicateArg arg, ISessionHandler handler) throws NetconfException {
        if (this.isConnected()) {
            return;
        }
        if (null == arg) {
            throw new NetconfException(-1, "can't connect to device with null communicate argument.");
        }
        long start = System.currentTimeMillis();
        this.arg = arg;
        boolean success = false;
        try {
            this.conn = new Connection(arg.getIp(), arg.getPort());
            this.conn.connect(null, (int)arg.getLoginTimeout(), (int)arg.getLoginTimeout());
            this.authenticate();
            this.conn.addConnectionMonitor((ConnectionMonitor)this);
            this.sess = this.conn.openSession(20000);
            this.sess.setSessionHandler(handler);
            this.sess.startSubSystem("netconf");
            this.connected.set(true);
            success = true;
        }
        catch (AuthenticationException e) {
            logger.error("authenticate fail, close transport.");
            throw e;
        }
        catch (SocketTimeoutException e) {
            throw new NetconfTimeoutException("connect", arg.getLoginTimeout(), System.currentTimeMillis() - start, e);
        }
        catch (IOException e) {
            throw new TransportIOException("exception! connect to device:" + arg, (Throwable)e);
        }
        catch (Exception e) {
            throw new NetconfException(-1, (Throwable)e);
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    public void connectionLost(Throwable e) {
        if (this.isSelfClose.get()) {
            logger.info("already close by NMS. ip={}", (Object)this.arg.getIp());
            return;
        }
        logger.error("connectionLost, ip=" + this.arg.getIp(), e);
        TransportIOException error = new TransportIOException(this.toString() + " connection lost.", e);
        HashSet tmpListeners = new HashSet(this.listeners);
        for (ITransportListener tmpListener : tmpListeners) {
            tmpListener.handleTransportClosed(this, error);
        }
    }

    @Override
    public synchronized void send(String request) throws NetconfException {
        if (null == request) {
            logger.debug("request is null, no need to be send.");
            return;
        }
        if (!this.isConnected()) {
            logger.error("sendMessage error. " + this.toString());
            throw new TransportIOException(this.arg, new IOException("ssh is not connected"));
        }
        long start = System.currentTimeMillis();
        request = SSH.appendSuffix(request);
        ByteArrayMerger byteArrayMerger = this.replacePwd(request);
        byte[] bytes = byteArrayMerger.getTotalArray();
        try {
            this.sess.sendMessage(bytes);
        }
        catch (IOException e) {
            logger.error("sendMessage error. " + this.toString(), (Throwable)e);
            throw new TransportIOException(this.arg, e);
        }
        finally {
            byteArrayMerger.clear();
            ByteArrayMerger.clearBytes(bytes);
        }
        long end = System.currentTimeMillis();
        long elapse = end - start;
        this.averageSendRate(bytes.length, elapse);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SSH [arg=");
        builder.append(this.arg);
        builder.append("]");
        return builder.toString();
    }

    private void authenticate() throws AuthenticationException {
        boolean isAuthenticated = false;
        try {
            switch (this.arg.getType()) {
                case 1: {
                    byte[] tmpPwd = PlatformCipherTool.decrypt(this.arg.getPassword());
                    String pwd = new String(tmpPwd);
                    ByteArrayMerger.clearBytes(tmpPwd);
                    isAuthenticated = this.conn.authenticateWithPassword(this.arg.getUserName().trim(), pwd);
                    break;
                }
                case 2: {
                    char[] keyContent = this.arg.getKey().toCharArray();
                    byte[] tmpPwdPhrase = PlatformCipherTool.decrypt(this.arg.getPasswordPhrase());
                    String pwdPhrase = new String(tmpPwdPhrase);
                    ByteArrayMerger.clearBytes(tmpPwdPhrase);
                    isAuthenticated = this.conn.authenticateWithPublicKey(this.arg.getUserName(), keyContent, pwdPhrase);
                    break;
                }
                case 3: {
                    char[] keyContent = this.arg.getKey().toCharArray();
                    byte[] tmpPwd = PlatformCipherTool.decrypt(this.arg.getPassword());
                    String pwd = new String(tmpPwd);
                    ByteArrayMerger.clearBytes(tmpPwd);
                    byte[] tmpPwdPhrase = PlatformCipherTool.decrypt(this.arg.getPasswordPhrase());
                    String pwdPhrase = new String(tmpPwdPhrase);
                    ByteArrayMerger.clearBytes(tmpPwdPhrase);
                    this.conn.authenticateWithPublicKey(this.arg.getUserName(), keyContent, pwdPhrase);
                    boolean authenticationPartialSuccess = this.conn.isAuthenticationPartialSuccess();
                    if (authenticationPartialSuccess) {
                        isAuthenticated = this.conn.authenticateWithPassword(this.arg.getUserName().trim(), pwd);
                    }
                    break;
                }
                default: {
                    logger.warn("illegal authenticate type, ignore.");
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new AuthenticationException(this.arg, (Throwable)e);
        }
        if (!isAuthenticated) {
            throw new AuthenticationException(this.arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRecvBuffer() {
        try {
            if (null != this.recvBuffer) {
                this.recvBuffer.delete(0, this.recvBuffer.length());
            }
        }
        catch (Exception e) {
            logger.error("clear recvBuffer error. ip=" + this.arg.getIp(), (Throwable)e);
        }
        finally {
            this.recvBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection() {
        try {
            if (null != this.conn) {
                this.conn.close();
            }
        }
        catch (Exception e) {
            logger.error("close connection error. ip=" + this.arg.getIp(), (Throwable)e);
        }
        finally {
            this.conn = null;
            this.connected.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession() {
        try {
            if (null != this.sess) {
                this.sess.close();
            }
        }
        catch (Exception e) {
            logger.error("close session error. ip=" + this.arg.getIp(), (Throwable)e);
        }
        finally {
            this.sess = null;
        }
    }

    private ByteArrayMerger replacePwd(String request) throws TransportIOException {
        int startIndex;
        ByteArrayMerger byteInfo = new ByteArrayMerger();
        if (null == request || request.isEmpty()) {
            return byteInfo;
        }
        int endIndex = startIndex = 0;
        boolean finish = true;
        int length = request.length();
        while (startIndex < length) {
            if (finish) {
                endIndex = request.indexOf("++[[+[[", startIndex);
                if (endIndex < 0) break;
                byteInfo.addByteArray(request.substring(startIndex, endIndex).getBytes());
                startIndex = endIndex + PWD_START_FLAG_LENGTH;
                finish = false;
                continue;
            }
            endIndex = request.indexOf("]]-]]--", startIndex);
            if (endIndex < 0) {
                byteInfo.clear();
                throw new TransportIOException(this.arg, new IOException("XML is not correct, has not end flag from index=" + startIndex));
            }
            String tmpPwd = request.substring(startIndex, endIndex);
            byteInfo.addByteArray(PlatformCipherTool.decrypt(tmpPwd));
            startIndex = endIndex + PWD_END_FLAG_LENGTH;
            finish = true;
        }
        byteInfo.addByteArray(request.substring(startIndex, request.length()).getBytes());
        return byteInfo;
    }
}

