/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.transport;

import com.huawei.vmf.netconf.transport.ITransport;
import com.huawei.vmf.netconf.transport.ITransportListener;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractTransport
implements ITransport {
    public static final String END_TAG_SUFFIX = "]]>]]>";
    protected static final String SUBSYSTEM_NETCONF = "netconf";
    protected StringBuffer recvBuffer;
    protected AtomicBoolean connected;
    protected double sendRate = 0.0;
    protected double recvRate = 0.0;
    protected Set<ITransportListener> listeners = new HashSet<ITransportListener>();

    public AbstractTransport() {
        this.connected = new AtomicBoolean(false);
    }

    public StringBuffer getRecvBuffer() {
        return this.recvBuffer;
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    public static byte[] getBytes(String data) {
        if (data == null) {
            return new byte[0];
        }
        byte[] bytes = null;
        try {
            bytes = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = data.getBytes();
        }
        return bytes;
    }

    public static String appendSuffix(String data) {
        if (data == null) {
            return data;
        }
        if (data.endsWith(END_TAG_SUFFIX)) {
            return data;
        }
        return data + END_TAG_SUFFIX;
    }

    protected void averageSendRate(long bytes, long elapse) {
        if (elapse == 0L) {
            return;
        }
        double rate = (double)bytes / (double)elapse / 1000.0;
        this.sendRate = this.sendRate == 0.0 ? rate : (this.sendRate + rate) / 2.0;
    }

    protected void averageRecvRate(long bytes, long elapse) {
        if (elapse == 0L) {
            return;
        }
        double rate = (double)bytes / (double)elapse / 1000.0;
        this.recvRate = this.recvRate == 0.0 ? rate : (this.recvRate + rate) / 2.0;
    }

    public double getSendRate() {
        return this.sendRate;
    }

    public double getRecvRate() {
        return this.recvRate;
    }

    @Override
    public void registryListener(ITransportListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void unregistryListener(ITransportListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }
}

