/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.session.impl;

import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.Netconf;
import com.huawei.vmf.netconf.session.DefaultSession;
import com.huawei.vmf.netconf.session.ISession;
import com.huawei.vmf.netconf.session.impl.DeviceSessionPool;
import com.huawei.vmf.netconf.session.impl.ISessionCreater;
import com.huawei.vmf.netconf.session.impl.LockFailedException;
import com.huawei.vmf.netconf.session.impl.SessionWrapper;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionPoolImpl {
    private static final long _1_SECOND = 1000L;
    private static final String FREE_SESSION_THREAD_NAME = "_SessionPollImpl_Release_Thread_";
    private static final SessionPoolImpl INSTANCE = new SessionPoolImpl();
    private static final int MAX_SESSION_LIMIT = Netconf.getMaxHoldConnections();
    private final Map<String, DeviceSessionPool> agents = new HashMap<String, DeviceSessionPool>();
    private final PriorityQueue<DeviceSessionPool> cache = new PriorityQueue<DeviceSessionPool>(800, new Comparator<DeviceSessionPool>(){

        @Override
        public int compare(DeviceSessionPool da1, DeviceSessionPool da2) {
            return da1.compareTo(da2);
        }
    });
    private final Object cleanerMonitor = new boolean[0];
    private Thread clearThread;
    private boolean isInit = false;
    private final Lock lockImpl = new ReentrantLock();
    private final Logger logger = LoggerFactory.getLogger(DeviceSessionPool.class);
    private final Object monitor = new boolean[0];
    private int needRelease = 0;
    private int sessionCounter = 0;

    private SessionPoolImpl() {
    }

    public static SessionPoolImpl instance() {
        return INSTANCE;
    }

    static void closeQuietly(ISession session) {
        if (session == null) {
            return;
        }
        try {
            session.close();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(DeviceSessionPool.class).error("closeQuietly error.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() {
        if (this.isInit) {
            return;
        }
        SessionPoolImpl sessionPoolImpl = this;
        synchronized (sessionPoolImpl) {
            if (this.isInit) {
                return;
            }
            this.isInit = true;
            this.clearThread = new Thread((Runnable)new Cleaner(), "DeviceMgr-cleaner");
            this.clearThread.setDaemon(true);
            this.clearThread.start();
        }
    }

    void dumpSessionStatus(StringBuilder stringBuilder) {
        stringBuilder.append("-----begin dump SessionPoolImpl\n");
        if (this.clearThread != null) {
            stringBuilder.append("------begin dump stack of " + this.clearThread.getName() + "\n");
            for (StackTraceElement stack : this.clearThread.getStackTrace()) {
                stringBuilder.append(stack + "\n");
            }
            stringBuilder.append("------end dump stack of " + this.clearThread.getName() + "\n");
        }
        stringBuilder.append("-----begin dump SessionPoolImpl\n");
        stringBuilder.append("agentCount " + this.agents.size() + "\n");
        stringBuilder.append("needRelease " + this.needRelease + "\n");
        stringBuilder.append("sessionCounter " + this.sessionCounter + "\n");
        stringBuilder.append("cacheCounter " + this.cache.size() + "\n");
        Iterator<DeviceSessionPool> da = this.cache.iterator();
        while (da.hasNext()) {
            stringBuilder.append(da.next() + "\n");
        }
        stringBuilder.append("-----end dump SessionPoolImpl\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeSession(ISession session, boolean isSessionClosed) {
        if (session == null) {
            return;
        }
        if (this.isInFreeSessionCxt()) {
            return;
        }
        Thread thisThread = Thread.currentThread();
        String oldThreadName = thisThread.getName();
        try {
            thisThread.setName(FREE_SESSION_THREAD_NAME);
            this.freeSessionImpl(session, isSessionClosed);
        }
        finally {
            thisThread.setName(oldThreadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ISession getSession(String ip, ISessionCreater creater, long deadLine, Netconf.SESSION_PRIORITY priority) throws NetconfException, LockFailedException {
        DeviceSessionPool da;
        this.startup();
        this.lock(deadLine);
        try {
            da = this.agents.get(ip);
            if (da == null) {
                da = new DeviceSessionPool(ip, Netconf.getMaxConnectionPerDevice(), System.currentTimeMillis());
                this.agents.put(ip, da);
            }
            if (Netconf.SESSION_PRIORITY.HIGH.equals((Object)priority) && this.cache.contains(da)) {
                this.cache.remove(da);
                da.access();
                this.cache.add(da);
            }
        }
        finally {
            this.unlock();
        }
        ISession[] existSession = new ISession[]{null};
        SessionWrapper sessionWrapper = da.bookSession(deadLine, existSession);
        if (sessionWrapper == null) {
            throw new NetconfException(1107495869, "device netconf session reach max limit, ip=" + ip);
        }
        ISession session = this.connect(sessionWrapper, deadLine, existSession[0], creater, da);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDevDelete(String ip) {
        this.lockWithoutTimeout();
        try {
            DeviceSessionPool da = this.agents.get(ip);
            if (da == null) {
                return;
            }
            this.agents.remove(ip);
            Object object = da.getMonitor();
            synchronized (object) {
                for (SessionWrapper session : da.getAllValidSessions()) {
                    if (session.isFree()) {
                        this.closeSessionWithinFreeCxt(session.getSession());
                        session.onSessionClose();
                    }
                    this.decrementSessionCounter();
                }
            }
            this.cache.remove(da);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onNetconfParameterChanged(String ip) {
        this.lockWithoutTimeout();
        try {
            DeviceSessionPool da = this.agents.get(ip);
            if (da == null) {
                return;
            }
            da.setNetconfParameterSetTime(System.currentTimeMillis());
            Object object = da.getMonitor();
            synchronized (object) {
                for (SessionWrapper session : da.getAllValidSessions()) {
                    if (session.isFree()) {
                        this.closeSessionWithinFreeCxt(session.getSession());
                        session.onSessionClose();
                    }
                    this.decrementSessionCounter();
                }
            }
            this.cache.remove(da);
        }
        finally {
            this.unlock();
        }
    }

    private void closeSessionWithinFreeCxt(ISession session) {
        if (session == null) {
            return;
        }
        Thread thisThread = Thread.currentThread();
        String oldThreadName = thisThread.getName();
        thisThread.setName(FREE_SESSION_THREAD_NAME);
        SessionPoolImpl.closeQuietly(session);
        thisThread.setName(oldThreadName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISession connect(SessionWrapper sessionWrapper, long deadLine, ISession existSession, ISessionCreater creater, DeviceSessionPool da) throws NetconfException {
        if (existSession != null) {
            boolean clearSuccess = SessionWrapper.clearSession(existSession);
            this.lockWithoutTimeout();
            try {
                if (clearSuccess) {
                    if (sessionWrapper.getSession() == existSession) {
                        this.logger.info("reuse session " + existSession);
                        ISession iSession = existSession;
                        return iSession;
                    }
                    this.closeSessionWithinFreeCxt(existSession);
                    this.logger.error("session {} is closed before clearSession", (Object)sessionWrapper);
                    throw new NetconfException(1107495873, "device netconf session reach max limit, sessionWrapper=" + sessionWrapper);
                }
                this.closeSessionWithinFreeCxt(existSession);
                sessionWrapper.onSessionClose();
                this.decrementSessionCounter();
            }
            finally {
                this.unlock();
            }
        }
        ISession newSession = null;
        boolean needUnlock = false;
        try {
            if (!this.incrementSessionCounter(deadLine)) {
                this.logger.error("total device netconf session number reach max:" + this.sessionCounter);
                throw new NetconfException(1107495869);
            }
            newSession = creater.getSession();
            this.lockWithoutTimeout();
            needUnlock = true;
            sessionWrapper.setSession(newSession);
            ISession iSession = sessionWrapper.getSession();
            if (newSession == null) {
                this.decrementSessionCounter();
                this.freeDeviceSession(da, sessionWrapper, !needUnlock);
            }
            if (needUnlock) {
                this.unlock();
            }
            return iSession;
        }
        catch (Throwable throwable) {
            if (newSession == null) {
                this.decrementSessionCounter();
                this.freeDeviceSession(da, sessionWrapper, !needUnlock);
            }
            if (needUnlock) {
                this.unlock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementSessionCounter() {
        Object object = this.monitor;
        synchronized (object) {
            --this.sessionCounter;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeDeviceSession(DeviceSessionPool da, SessionWrapper sessionWrapper, boolean needLock) {
        if (needLock) {
            this.lockWithoutTimeout();
        }
        try {
            da.freeSession(sessionWrapper);
        }
        finally {
            if (needLock) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeSessionImpl(ISession _session, boolean isSessionHasClosed) {
        if (!(_session instanceof DefaultSession)) {
            SessionPoolImpl.closeQuietly(_session);
            return;
        }
        DefaultSession session = (DefaultSession)_session;
        boolean isFreeSuccess = false;
        this.lockWithoutTimeout();
        try {
            DeviceSessionPool da = this.agents.get(session.getIp());
            if (da == null) {
                this.logger.error("device not found, sa is null, session = {}", (Object)session);
                SessionPoolImpl.closeQuietly(session);
                return;
            }
            if (session.getCreateTime() < da.getNetconfParameterSetTime()) {
                this.logger.error("device not found, session = {}, da = {}", (Object)session, (Object)da);
                SessionPoolImpl.closeQuietly(session);
                return;
            }
            boolean freeSuccess = da.freeSession(_session, isSessionHasClosed);
            if (isSessionHasClosed && freeSuccess) {
                isFreeSuccess = true;
            }
            this.reCache(da);
        }
        finally {
            if (isFreeSuccess) {
                this.decrementSessionCounter();
            }
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean incrementSessionCounter(long deadLine) {
        Object object = this.monitor;
        synchronized (object) {
            while (MAX_SESSION_LIMIT <= this.sessionCounter) {
                if (System.currentTimeMillis() > deadLine) {
                    this.logger.error("getSessionImpl timeout");
                    return false;
                }
                this.releaseUnUsedSessionAync();
                try {
                    this.monitor.wait(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.error("unknown ex on getSession ", (Throwable)e);
                    return false;
                }
            }
            ++this.sessionCounter;
            return true;
        }
    }

    private boolean isInFreeSessionCxt() {
        return FREE_SESSION_THREAD_NAME.equals(Thread.currentThread().getName());
    }

    private boolean lock(long deadLine) throws LockFailedException {
        long timeout = deadLine - System.currentTimeMillis();
        try {
            if (!this.lockImpl.tryLock(timeout, TimeUnit.MILLISECONDS)) {
                throw new LockFailedException("timeout = " + timeout);
            }
        }
        catch (InterruptedException e) {
            throw new LockFailedException(e);
        }
        return true;
    }

    private void lockWithoutTimeout() {
        this.lockImpl.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reCache(DeviceSessionPool da) {
        if (da == null) {
            return;
        }
        DeviceSessionPool deviceSessionPool = da;
        synchronized (deviceSessionPool) {
            if (!da.hasFreeValidSession()) {
                if (this.cache.contains(da)) {
                    this.cache.remove(da);
                    this.logger.info("remove from cache,  session for {}", (Object)da);
                }
            } else if (!this.cache.contains(da)) {
                this.logger.info("cache session for {}", (Object)da);
                this.cache.add(da);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseUnUsedSessionAync() {
        Object object = this.cleanerMonitor;
        synchronized (object) {
            ++this.needRelease;
            this.cleanerMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean releaseUnUsedSessionImpl() {
        this.lockWithoutTimeout();
        boolean isSuccess = false;
        try {
            while (!this.cache.isEmpty()) {
                DeviceSessionPool da = this.cache.peek();
                if (da == null) {
                    this.cache.poll();
                    continue;
                }
                Object object = da.getMonitor();
                synchronized (object) {
                    Collection<SessionWrapper> sessionWrappers = da.getFreeValidSessions();
                    if (sessionWrappers.isEmpty()) {
                        this.cache.poll();
                        continue;
                    }
                    this.logger.info("releaseUnUsedSession session of {}, has {} free-avalid sessions", (Object)da.getIp(), (Object)sessionWrappers.size());
                    SessionWrapper sessionWrapper = sessionWrappers.iterator().next();
                    ISession sessionToClose = sessionWrapper.getSession();
                    sessionWrapper.onSessionClose();
                    this.closeSessionWithinFreeCxt(sessionToClose);
                    if (sessionWrappers.size() <= 1) {
                        this.cache.poll();
                    }
                }
                isSuccess = true;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (isSuccess) {
                this.decrementSessionCounter();
            }
            this.unlock();
        }
    }

    private void unlock() {
        this.lockImpl.unlock();
    }

    private class Cleaner
    implements Runnable {
        private Cleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                boolean needRelease = false;
                Object object = SessionPoolImpl.this.cleanerMonitor;
                synchronized (object) {
                    if (SessionPoolImpl.this.needRelease > 0) {
                        needRelease = true;
                        --SessionPoolImpl.this.needRelease;
                    } else {
                        try {
                            SessionPoolImpl.this.cleanerMonitor.wait(60000L);
                        }
                        catch (InterruptedException e) {
                            SessionPoolImpl.this.logger.error("unknown ex", (Throwable)e);
                        }
                    }
                }
                if (!needRelease) continue;
                SessionPoolImpl.this.releaseUnUsedSessionImpl();
            }
        }
    }
}

