/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.session.impl;

import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.Netconf;
import com.huawei.vmf.netconf.session.DeviceSessionBucket;
import com.huawei.vmf.netconf.session.ISession;
import com.huawei.vmf.netconf.session.ISessionCheckHandle;
import com.huawei.vmf.netconf.session.SessionPool;
import com.huawei.vmf.netconf.session.impl.ISessionPool;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NoCacheSessionPool
implements ISessionPool {
    private static final NoCacheSessionPool INSTANCE = new NoCacheSessionPool();
    private final Map<String, DeviceSessionBucket> buckets = Collections.synchronizedMap(new HashMap());
    private final Logger logger = LoggerFactory.getLogger(SessionPool.class);
    private final AtomicInteger totalSessionNum = new AtomicInteger();

    private NoCacheSessionPool() {
    }

    public static ISessionPool instance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISession getSession(String creator, CommunicateArg arg, List<ISessionCheckHandle> sessionCheckServiceList, Netconf.SESSION_PRIORITY priority) throws NetconfException {
        this.logger.info("start get session ip={}, shared={}", (Object)arg.getIp(), (Object)false);
        this.checkTotalSessionLimit();
        boolean success = false;
        try {
            DeviceSessionBucket bucket = this.createBucket(arg.getIp());
            ISession session = bucket.getSession(creator, arg, false, sessionCheckServiceList);
            success = true;
            this.logger.info("get session ip={} success", (Object)arg.getIp());
            ISession iSession = session;
            return iSession;
        }
        finally {
            if (!success) {
                this.totalSessionNum.getAndDecrement();
            }
        }
    }

    @Override
    public void onDevDelete(String ip) {
        this.close(ip);
    }

    @Override
    public void onNetconfParameterChanged(String ip) {
        this.close(ip);
    }

    @Override
    public void onSessionClosedNotify(ISession session) {
    }

    @Override
    public void onSessionDirectClosed(ISession session) {
        this.releaseSession(session);
    }

    @Override
    public void releaseSession(ISession session) {
        this.logger.info("give back release session {}, totalSessionNum={}", (Object)session, (Object)this.totalSessionNum.get());
        if (null == session) {
            this.logger.warn("session is null");
            return;
        }
        DeviceSessionBucket bucket = this.buckets.get(session.getCommunicationArg().getIp());
        boolean success = false;
        success = null == bucket ? session.close() : bucket.close(session);
        if (success) {
            this.totalSessionNum.decrementAndGet();
        }
        this.logger.info("give back  session {} success, totalSessionNum={}", (Object)session, (Object)this.totalSessionNum.get());
    }

    @Override
    public int testConnective(CommunicateArg communicateArg, long timeout, List<ISessionCheckHandle> sessionCheckServiceList) {
        DeviceSessionBucket bucket = this.createBucket(communicateArg.getIp());
        return bucket.testConnective(communicateArg, sessionCheckServiceList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTotalSessionLimit() throws NetconfException {
        Class<SessionPool> clazz = SessionPool.class;
        synchronized (SessionPool.class) {
            if (this.totalSessionNum.get() >= Netconf.getMaxHoldConnections()) {
                this.logger.error("total device netconf session number reach max:" + this.totalSessionNum.get());
                throw new NetconfException(1107495869);
            }
            this.totalSessionNum.getAndIncrement();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void close(String ip) {
        DeviceSessionBucket deviceSessionBucket = this.buckets.remove(ip);
        if (null != deviceSessionBucket) {
            deviceSessionBucket.closeAll();
        } else {
            this.logger.info("Device:{} DeviceSessionBucket is null.", (Object)ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceSessionBucket createBucket(String ip) {
        DeviceSessionBucket bucket = null;
        Map<String, DeviceSessionBucket> map = this.buckets;
        synchronized (map) {
            bucket = this.buckets.get(ip);
            if (bucket == null) {
                bucket = new DeviceSessionBucket(ip, Netconf.getMaxConnectionPerDevice());
                this.buckets.put(ip, bucket);
            }
        }
        return bucket;
    }
}

