/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.session.impl;

import com.huawei.vmf.netconf.service.Netconf;
import com.huawei.vmf.netconf.session.ISession;
import com.huawei.vmf.netconf.session.impl.SessionWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceSessionPool
implements Comparable<DeviceSessionPool> {
    private static final long _1_SECOND = 1000L;
    private static final int N = Netconf.getCachePolicyLastAccessCounter();
    private static final int PRI_EQ = 0;
    private static final int PRI_HIGH = 1;
    private static final int PRI_LOW = -1;
    private int index = 0;
    private final String ip;
    private final long[] lastAccessTimes = new long[N];
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Object monitor = new boolean[0];
    private long netconfParameterSetTime;
    private final SessionWrapper[] sessions;
    private long weight = 0L;

    public DeviceSessionPool(String ip, int sessionLimit, long createTime) {
        this.ip = ip;
        Arrays.fill(this.lastAccessTimes, 0L);
        this.sessions = new SessionWrapper[sessionLimit];
        this.netconfParameterSetTime = createTime;
    }

    public void access() {
        if (this.index >= N) {
            this.index = 0;
        }
        this.lastAccessTimes[this.index++] = System.currentTimeMillis();
        this.weight = 0L;
        for (int i = 0; i < N; ++i) {
            this.weight += this.lastAccessTimes[i];
        }
    }

    public SessionWrapper bookSession(long deadLine, ISession[] sessions) {
        Object object = this.monitor;
        synchronized (object) {
            SessionWrapper sessionWrapper;
            while ((sessionWrapper = this.bookSession()) == null) {
                try {
                    this.monitor.wait(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.error("bookSession error.", (Throwable)e);
                    return null;
                }
                if (System.currentTimeMillis() <= deadLine) continue;
                this.logger.error("booksession timeout, ip = {}", (Object)this.ip);
                return null;
            }
            if (sessions.length > 0) {
                sessions[0] = sessionWrapper.getSession();
            }
            return sessionWrapper;
        }
    }

    @Override
    public int compareTo(DeviceSessionPool that) {
        long weigth1;
        long weigth0 = this.getWeight();
        if (weigth0 > (weigth1 = that.getWeight())) {
            return 1;
        }
        if (weigth0 == weigth1) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (that instanceof DeviceSessionPool) {
            DeviceSessionPool that1 = (DeviceSessionPool)that;
            return this.ip.equals(that1.ip);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean freeSession(ISession session, boolean isSessionHasClosed) {
        Object object = this.monitor;
        synchronized (object) {
            for (SessionWrapper sessionWrapper : this.sessions) {
                if (sessionWrapper == null || sessionWrapper.getSession() != session) continue;
                sessionWrapper.free();
                if (isSessionHasClosed) {
                    sessionWrapper.close();
                }
                this.monitor.notifyAll();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeSession(SessionWrapper session) {
        if (session == null) {
            return;
        }
        Object object = this.monitor;
        synchronized (object) {
            session.free();
            this.monitor.notifyAll();
        }
    }

    public Collection<SessionWrapper> getAllValidSessions() {
        ArrayList<SessionWrapper> ret = new ArrayList<SessionWrapper>();
        for (int i = 0; i < this.sessions.length; ++i) {
            if (this.sessions[i] == null) continue;
            ret.add(this.sessions[i]);
        }
        return ret;
    }

    public Collection<SessionWrapper> getFreeValidSessions() {
        ArrayList<SessionWrapper> ret = new ArrayList<SessionWrapper>();
        for (int i = 0; i < this.sessions.length; ++i) {
            if (this.sessions[i] == null || !this.sessions[i].isFree() || this.sessions[i].getSession() == null) continue;
            ret.add(this.sessions[i]);
        }
        return ret;
    }

    public String getIp() {
        return this.ip;
    }

    public Object getMonitor() {
        return this.monitor;
    }

    public long getNetconfParameterSetTime() {
        return this.netconfParameterSetTime;
    }

    public boolean hasFreeValidSession() {
        return !this.getFreeValidSessions().isEmpty();
    }

    public int hashCode() {
        return (this.getClass().getName() + this.ip).hashCode();
    }

    public void setNetconfParameterSetTime(long netconfParameterSetTime) {
        this.netconfParameterSetTime = netconfParameterSetTime;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DeviceSessionPool(" + this.ip + ")");
        stringBuilder.append(";createTime=" + this.netconfParameterSetTime);
        stringBuilder.append(";weigth=" + this.getWeight() + "\n");
        for (SessionWrapper sessionWrapper : this.sessions) {
            stringBuilder.append("session:" + sessionWrapper + "\n");
        }
        return stringBuilder.toString();
    }

    private SessionWrapper bookSession() {
        for (int i = 0; i < this.sessions.length; ++i) {
            if (this.sessions[i] == null) {
                this.sessions[i] = new SessionWrapper();
                this.sessions[i].setUsing();
                return this.sessions[i];
            }
            if (!this.sessions[i].isFree()) continue;
            this.sessions[i].setUsing();
            return this.sessions[i];
        }
        return null;
    }

    private long getWeight() {
        return this.weight;
    }
}

