/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.session.impl;

import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.Netconf;
import com.huawei.vmf.netconf.session.DeviceSessionBucket;
import com.huawei.vmf.netconf.session.ISession;
import com.huawei.vmf.netconf.session.ISessionCheckHandle;
import com.huawei.vmf.netconf.session.impl.CacheSessionPool;
import com.huawei.vmf.netconf.session.impl.ISessionCreater;
import com.huawei.vmf.netconf.session.impl.ISessionPool;
import com.huawei.vmf.netconf.session.impl.LockFailedException;
import com.huawei.vmf.netconf.session.impl.SessionPoolImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CacheSessionPoolImpl
implements ISessionPool {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected CacheSessionPoolImpl() {
    }

    private static final long defaultDeadLine() {
        return System.currentTimeMillis() + (long)Netconf.getDefaultLoginTimeout();
    }

    @Override
    public ISession getSession(final String creator, final CommunicateArg arg, final List<ISessionCheckHandle> sessionCheckServiceList, Netconf.SESSION_PRIORITY priority) throws NetconfException {
        final DeviceSessionBucket bucket = new DeviceSessionBucket(arg.getIp(), Integer.MAX_VALUE);
        try {
            return SessionPoolImpl.instance().getSession(arg.getIp(), new ISessionCreater(){

                @Override
                public ISession getSession() throws NetconfException {
                    return bucket.getSession(creator, arg, false, sessionCheckServiceList);
                }
            }, CacheSessionPoolImpl.defaultDeadLine(), priority);
        }
        catch (LockFailedException e) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("there is a deadlock problem, begin dump the callor's stack\n");
            for (Thread callor : CacheSessionPool.getCallors()) {
                stringBuilder.append("------begin dump stack of " + callor.getName() + "\n");
                for (StackTraceElement stack : callor.getStackTrace()) {
                    stringBuilder.append(stack + "\n");
                }
                stringBuilder.append("------end dump stack of " + callor.getName() + "\n");
            }
            SessionPoolImpl.instance().dumpSessionStatus(stringBuilder);
            this.logger.info(stringBuilder.toString());
            throw new NetconfException(1107495869, "device netconf session reach max limit, arg=" + arg, e);
        }
    }

    @Override
    public void onDevDelete(String ip) {
        SessionPoolImpl.instance().onDevDelete(ip);
    }

    @Override
    public void onNetconfParameterChanged(String ip) {
        SessionPoolImpl.instance().onNetconfParameterChanged(ip);
    }

    @Override
    public void onSessionClosedNotify(ISession session) {
        SessionPoolImpl.instance().freeSession(session, true);
    }

    @Override
    public void onSessionDirectClosed(ISession session) {
        SessionPoolImpl.instance().freeSession(session, true);
    }

    @Override
    public void releaseSession(ISession session) {
        SessionPoolImpl.instance().freeSession(session, false);
    }

    @Override
    public int testConnective(CommunicateArg communicateArg, long timeout, List<ISessionCheckHandle> sessionCheckServiceList) {
        return new DeviceSessionBucket(communicateArg.getIp(), Integer.MAX_VALUE).testConnective(communicateArg, sessionCheckServiceList);
    }
}

