/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.session.impl;

import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.Netconf;
import com.huawei.vmf.netconf.session.ISession;
import com.huawei.vmf.netconf.session.ISessionCheckHandle;
import com.huawei.vmf.netconf.session.impl.CacheSessionPoolImpl;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

class CacheSessionPool
extends CacheSessionPoolImpl {
    private static final Set<Thread> callors = new ConcurrentSkipListSet<Thread>(new Comparator<Thread>(){

        @Override
        public int compare(Thread arg0, Thread arg1) {
            return (int)(arg0.getId() - arg1.getId());
        }
    });

    CacheSessionPool() {
    }

    public static Set<Thread> getCallors() {
        return callors;
    }

    private static final void entryCallor() {
        callors.add(Thread.currentThread());
    }

    private static final void exitCallor() {
        callors.remove(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISession getSession(String creator, CommunicateArg arg, List<ISessionCheckHandle> sessionCheckServiceList, Netconf.SESSION_PRIORITY priority) throws NetconfException {
        CacheSessionPool.entryCallor();
        try {
            ISession iSession = super.getSession(creator, arg, sessionCheckServiceList, priority);
            return iSession;
        }
        finally {
            CacheSessionPool.exitCallor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDevDelete(String ip) {
        CacheSessionPool.entryCallor();
        try {
            super.onDevDelete(ip);
        }
        finally {
            CacheSessionPool.exitCallor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNetconfParameterChanged(String ip) {
        CacheSessionPool.entryCallor();
        try {
            super.onNetconfParameterChanged(ip);
        }
        finally {
            CacheSessionPool.exitCallor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSessionClosedNotify(ISession session) {
        CacheSessionPool.entryCallor();
        try {
            super.onSessionClosedNotify(session);
        }
        finally {
            CacheSessionPool.exitCallor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSessionDirectClosed(ISession session) {
        CacheSessionPool.entryCallor();
        try {
            super.onSessionDirectClosed(session);
        }
        finally {
            CacheSessionPool.exitCallor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSession(ISession session) {
        CacheSessionPool.entryCallor();
        try {
            super.releaseSession(session);
        }
        finally {
            CacheSessionPool.exitCallor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int testConnective(CommunicateArg communicateArg, long timeout, List<ISessionCheckHandle> sessionCheckServiceList) {
        CacheSessionPool.entryCallor();
        try {
            int n = super.testConnective(communicateArg, timeout, sessionCheckServiceList);
            return n;
        }
        finally {
            CacheSessionPool.exitCallor();
        }
    }
}

