/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.session;

import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.Netconf;
import com.huawei.vmf.netconf.session.ISession;
import com.huawei.vmf.netconf.session.ISessionCheckHandle;
import com.huawei.vmf.netconf.session.impl.SessionPoolFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionPool {
    private static Logger logger = LoggerFactory.getLogger(SessionPool.class);

    @Deprecated
    public static void close(String ip) {
        SessionPoolFactory.getSessionPool().onDevDelete(ip);
    }

    public static void directCloseSession(ISession session) {
        logger.info("directCloseSession {}", (Object)session);
        SessionPoolFactory.getSessionPool().onSessionDirectClosed(session);
        logger.info("directCloseSession {} success", (Object)session);
    }

    @Deprecated
    public static ISession getSession(String creator, CommunicateArg arg, boolean shared, List<ISessionCheckHandle> sessionCheckServiceList) throws NetconfException {
        return SessionPool.getSession(creator, arg, shared, sessionCheckServiceList, Netconf.SESSION_PRIORITY.HIGH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISession getSession(String creator, CommunicateArg arg, boolean shared, List<ISessionCheckHandle> sessionCheckServiceList, Netconf.SESSION_PRIORITY priority) throws NetconfException {
        ISession iSession;
        logger.info("start get session ip={}, shared={}", (Object)arg.getIp(), (Object)shared);
        ISession ret = null;
        try {
            iSession = ret = SessionPoolFactory.getSessionPool().getSession(creator, arg, sessionCheckServiceList, priority);
        }
        catch (Throwable throwable) {
            logger.info("end get session ip={}, shared={}, ret = {}", new Object[]{arg.getIp(), shared, ret});
            throw throwable;
        }
        logger.info("end get session ip={}, shared={}, ret = {}", new Object[]{arg.getIp(), shared, ret});
        return iSession;
    }

    public static void onDevDelete(String ip) {
        SessionPoolFactory.getSessionPool().onDevDelete(ip);
    }

    public static void onNetconfParameterChanged(String ip) {
        SessionPoolFactory.getSessionPool().onNetconfParameterChanged(ip);
    }

    public static void releaseSession(ISession session) {
        logger.info("give back release session {}", (Object)session);
        SessionPoolFactory.getSessionPool().releaseSession(session);
        logger.info("give back  session {} success", (Object)session);
    }

    public static int testConnective(CommunicateArg communicateArg, long timeout, List<ISessionCheckHandle> sessionCheckServiceList) {
        return SessionPoolFactory.getSessionPool().testConnective(communicateArg, timeout, sessionCheckServiceList);
    }

    static void onSessonClosed(ISession session) {
        logger.info("session {} closed", (Object)session);
        SessionPoolFactory.getSessionPool().onSessionDirectClosed(session);
    }
}

