/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.session;

import com.huawei.vmf.netconf.datadefination.RpcErrorInfo;
import com.huawei.vmf.netconf.error.BadMessageFormatException;
import com.huawei.vmf.netconf.service.IRpcReply;
import com.huawei.vmf.netconf.session.NetconfAbility;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ServerHello
implements IRpcReply {
    public static final String HELLO_HEAD = "hello";
    private NetconfAbility ability;
    private int sessionID;

    public ServerHello(XMLStreamReader reader) throws BadMessageFormatException {
        if (HELLO_HEAD.equals(reader.getLocalName())) {
            try {
                this.ability = new NetconfAbility(reader);
                while (reader.hasNext()) {
                    int event = reader.next();
                    if (event == 1) {
                        if (!"session-id".equals(reader.getLocalName())) continue;
                        this.sessionID = Integer.parseInt(reader.getElementText().trim());
                        continue;
                    }
                    if (event != 2 || !HELLO_HEAD.equals(reader.getLocalName())) continue;
                    return;
                }
            }
            catch (NumberFormatException e) {
                throw new BadMessageFormatException("session-id is not illegal.", (Throwable)e);
            }
            catch (XMLStreamException e) {
                throw new BadMessageFormatException("hello is not illegal.", (Throwable)e);
            }
        } else {
            throw new BadMessageFormatException("expected <hello> but actual is " + reader.getLocalName(), null);
        }
    }

    public NetconfAbility getAbility() {
        return this.ability;
    }

    public void setAbility(NetconfAbility ability) {
        this.ability = ability;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(int sessionID) {
        this.sessionID = sessionID;
    }

    @Override
    public boolean isOK() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public int getFlowID() {
        return 0;
    }

    @Override
    public String getContent() {
        return null;
    }

    @Override
    public Collection<RpcErrorInfo> getErrorInfos() {
        return null;
    }

    @Override
    public int getSetID() {
        return -1;
    }

    @Override
    public Collection<IRpcReply> getPackages() {
        return null;
    }

    @Override
    public void addPackage(IRpcReply reply) {
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public int getMessageID() {
        return 0;
    }

    @Override
    public Integer getLrID() {
        return null;
    }

    @Override
    public Integer getVrID() {
        return null;
    }
}

