/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.session;

import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.session.DefaultSession;
import com.huawei.vmf.netconf.session.ISessionCheckHandle;
import com.huawei.vmf.netconf.session.ISessionListener;
import com.huawei.vmf.netconf.session.impl.SessionPoolFactory;
import com.huawei.vmf.netconf.transport.ITransport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PooledSession
extends DefaultSession {
    private String holder;
    private boolean inUsed;
    private boolean isClosed = false;
    private Collection<ISessionListener> listeners = new ArrayList<ISessionListener>();

    public PooledSession(CommunicateArg arg, int serial, List<ISessionCheckHandle> sessionCheckServiceList) throws NetconfException {
        super(arg, serial, sessionCheckServiceList);
    }

    public void addListener(ISessionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean close() {
        if (this.isClosed) {
            return true;
        }
        SessionPoolFactory.getSessionPool().onSessionClosedNotify(this);
        this.listeners.clear();
        this.cancelCollectorTask();
        this.isClosed = true;
        return super.close();
    }

    public Collection<ISessionListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void handleTransportClosed(ITransport transport, NetconfException error) {
        super.handleTransportClosed(transport, error);
        this.cancelCollectorTask();
        ArrayList<ISessionListener> tmpListeners = new ArrayList<ISessionListener>(this.listeners);
        for (ISessionListener tmpListener : tmpListeners) {
            tmpListener.disconnect(this);
        }
    }

    public boolean isInUsed() {
        return this.inUsed;
    }

    public void setInUsed(String holder) {
        this.inUsed = true;
        this.holder = holder;
        this.cancelCollectorTask();
    }

    public void setUnUsed() {
        this.inUsed = false;
        this.holder = null;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PooledSession [holder=");
        builder.append(this.holder);
        builder.append(", devIP=");
        builder.append(this.getCommunicationArg().getIp());
        builder.append(", id=");
        builder.append(this.getId());
        builder.append("]");
        return builder.toString();
    }

    private void cancelCollectorTask() {
    }
}

