/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.session;

import com.huawei.vmf.netconf.error.BadMessageFormatException;
import com.huawei.vmf.netconf.service.TargetType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class NetconfAbility {
    public static final int ACTION = 16384;
    public static final int ACTIVE = 32768;
    public static final int BASE = 1;
    public static final int CANDIDATE = 4;
    public static final int COMMIT_DESCRIPTION = 262144;
    public static final int COMPARE = 512;
    public static final int CONFIRMED_COMMIT = 8;
    public static final int DISCARD_COMMIT = 65536;
    public static final int EXCHANGE = 4096;
    public static final int EXECUTE_CLI = 2048;
    public static final int GET_NEXT = 524288;
    public static final int PREVIEW = 131072;
    public static final int ROLLBACK = 1024;
    public static final int ROLLBACK_ON_ERROR = 16;
    public static final int STARTUP = 64;
    public static final int SYNC = 8192;
    public static final int SYNC11 = 0x200000;
    public static final int UPDATE = 0x100000;
    public static final int URL = 128;
    public static final int VALIDATE = 32;
    public static final int WRITABLE_RUNNING = 2;
    public static final int XPATH = 256;
    private static final List<String> abilityItem = new ArrayList<String>();
    private static final String clientAbilityHello;
    private int deviceAbilityVolumn;

    public NetconfAbility(XMLStreamReader reader) throws BadMessageFormatException {
        try {
            while (reader.hasNext()) {
                int event = reader.next();
                if (event == 1) {
                    String ability;
                    int index;
                    if (!"capability".equals(reader.getLocalName()) || (index = abilityItem.indexOf((ability = reader.getElementText()).trim())) < 0) continue;
                    this.deviceAbilityVolumn |= 1 << index;
                    continue;
                }
                if (event != 2 || !"capabilities".equals(reader.getLocalName())) continue;
                return;
            }
        }
        catch (XMLStreamException e) {
            throw new BadMessageFormatException("capabilities is not illegal.", (Throwable)e);
        }
    }

    public static boolean capable(TargetType target, int capability) {
        if (target == TargetType.CDB && (4 & capability) == 0) {
            return false;
        }
        if (target == TargetType.URL && (0x80 & capability) == 0) {
            return false;
        }
        return target != TargetType.STARTUP || (0x40 & capability) != 0;
    }

    public static String getClientabilityhello() {
        return clientAbilityHello;
    }

    public int getDeviceAbilityVolumn() {
        return this.deviceAbilityVolumn;
    }

    static {
        abilityItem.add("urn:ietf:params:netconf:base:1.0");
        abilityItem.add("urn:ietf:params:netconf:capability:writable-running:1.0");
        abilityItem.add("urn:ietf:params:netconf:capability:candidate:1.0");
        abilityItem.add("urn:ietf:params:netconf:capability:confirmed-commit:1.0");
        abilityItem.add("urn:ietf:params:netconf:capability:rollback-on-error:1.0");
        abilityItem.add("urn:ietf:params:netconf:capability:validate:1.0");
        abilityItem.add("urn:ietf:params:netconf:capability:startup:1.0");
        abilityItem.add("urn:ietf:params:netconf:capability:url:1.0?protocol=ftp");
        abilityItem.add("urn:ietf:params:netconf:capability:xpath:1.0");
        abilityItem.add("urn:huawei:netconf:capability:compare:1.0");
        abilityItem.add("http://www.huawei.com/netconf/capability/rollback/1.0");
        abilityItem.add("http://www.huawei.com/netconf/capability/execute-cli/1.0");
        abilityItem.add("http://www.huawei.com/netconf/capability/exchange/1.0");
        abilityItem.add("http://www.huawei.com/netconf/capability/sync/1.0");
        abilityItem.add("http://www.huawei.com/netconf/capability/action/1.0");
        abilityItem.add("http://www.huawei.com/netconf/capability/active/1.0");
        abilityItem.add("http://www.huawei.com/netconf/capability/discard-commit/1.0");
        abilityItem.add("http://www.huawei.com/netconf/capability/preview/1.0");
        abilityItem.add("http://www.huawei.com/netconf/capability/commit-description/1.0");
        abilityItem.add("http://www.huawei.com/netconf/capability/get-next/1.0");
        abilityItem.add("http://www.huawei.com/netconf/capability/update/1.0");
        abilityItem.add("http://www.huawei.com/netconf/capability/sync/1.1");
        String beginTag = "<capability>";
        String endTag = "</capability>";
        StringBuffer buf = new StringBuffer();
        buf.append("<capabilities>");
        for (String item : abilityItem) {
            buf.append(beginTag);
            buf.append(item);
            buf.append(endTag);
        }
        buf.append("</capabilities>");
        clientAbilityHello = buf.toString();
    }
}

