/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.session;

import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.error.NetconfTimeoutException;
import com.huawei.vmf.netconf.service.IAsyncRpcHandler;
import com.huawei.vmf.netconf.service.IRpc;
import com.huawei.vmf.netconf.service.IRpcReply;
import com.huawei.vmf.netconf.session.DefaultSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageUnit {
    private static Logger logger = LoggerFactory.getLogger(MessageUnit.class);
    private IRpc req;
    private int messageID;
    private IRpcReply resp;
    private NetconfException error;
    private IAsyncRpcHandler handler;
    private long start;
    private boolean sent;
    private DefaultSession session;

    public MessageUnit(DefaultSession session, IRpc req, int messageID, IAsyncRpcHandler handler) {
        this.session = session;
        this.req = req;
        this.messageID = messageID;
        this.handler = handler;
        this.start = System.currentTimeMillis();
    }

    public MessageUnit(DefaultSession session, IRpc req, int messageID) {
        this(session, req, messageID, null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageUnit other = (MessageUnit)obj;
        return this.messageID == other.messageID;
    }

    public NetconfException getError() {
        return this.error;
    }

    public IAsyncRpcHandler getHandler() {
        return this.handler;
    }

    public int getMessageID() {
        return this.messageID;
    }

    public IRpc getReq() {
        return this.req;
    }

    public IRpcReply getResp() {
        return this.resp;
    }

    public long getTimeout() {
        return this.req.getTimeout();
    }

    public long getRemaining() {
        return this.req.getTimeout() - (System.currentTimeMillis() - this.start);
    }

    public long getElapse() {
        return System.currentTimeMillis() - this.start;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.messageID;
        return result;
    }

    public boolean isActive() {
        return this.resp != null && this.resp.isActive();
    }

    public boolean isAsynchronized() {
        return this.handler != null;
    }

    public boolean isError() {
        return this.error != null;
    }

    public boolean isFinished() {
        return !this.isActive() && (this.resp != null || this.error != null);
    }

    public boolean isKeepAlive() {
        return this.req.isKeepAlive();
    }

    public String serialize() throws NetconfException {
        return this.req.toCommand(this.messageID);
    }

    public String logSerialize() throws NetconfException {
        return this.req.toLogCommand(this.messageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setError(NetconfException error) {
        MessageUnit messageUnit = this;
        synchronized (messageUnit) {
            this.error = error;
            this.notifyAll();
        }
    }

    public void setHandler(IAsyncRpcHandler handler) {
        this.handler = handler;
    }

    public void setReq(IRpc req) {
        this.req = req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResp(IRpcReply resp) {
        if (this.isAsynchronized()) {
            this.handler.handle(this.req, resp);
        } else {
            MessageUnit messageUnit = this;
            synchronized (messageUnit) {
                this.resp = resp;
                this.notifyAll();
            }
        }
    }

    public void setStart() {
        this.start = System.currentTimeMillis();
        this.resp = null;
    }

    public boolean isSent() {
        return this.sent;
    }

    public void setSent(boolean sent) {
        this.sent = sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForReply() throws NetconfException {
        MessageUnit messageUnit = this;
        synchronized (messageUnit) {
            while (!this.isFinished()) {
                if (this.getRemaining() <= 0L) {
                    throw new NetconfTimeoutException(this.toString(), this.getTimeout(), this.getElapse());
                }
                try {
                    this.wait(this.getRemaining());
                }
                catch (InterruptedException e) {
                    throw new NetconfTimeoutException(this.toString(), this.getTimeout(), this.getElapse(), e);
                }
                if (!this.isActive() || !this.isKeepAlive()) continue;
                this.setStart();
            }
        }
        logger.info(this.toString() + " use time:" + this.getElapse());
        if (this.isError()) {
            throw this.getError();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MessageUnit [messageID=");
        builder.append(this.messageID);
        builder.append(", session=");
        builder.append(this.session);
        builder.append("]");
        return builder.toString();
    }
}

