/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.session;

import com.huawei.vmf.netconf.datadefination.ExecuteActionArg;
import com.huawei.vmf.netconf.datadefination.ReqCmd;
import com.huawei.vmf.netconf.datadefination.RpcErrorInfo;
import com.huawei.vmf.netconf.datadefination.RspCmd;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.IRpcReply;
import com.huawei.vmf.netconf.session.ISession;
import com.huawei.vmf.netconf.session.ISessionCheckHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LCTSessionCheckHandle
implements ISessionCheckHandle {
    private static Logger logger = LoggerFactory.getLogger(LCTSessionCheckHandle.class);
    private String messageTempletInfo;

    public LCTSessionCheckHandle(String messageTempletInfo) {
        this.messageTempletInfo = messageTempletInfo;
    }

    @Override
    public boolean checkSession(ISession sessionHandler) throws NetconfException {
        IRpcReply reply;
        if (this.messageTempletInfo == null || "".equals(this.messageTempletInfo.trim())) {
            return true;
        }
        boolean sendResult = false;
        ExecuteActionArg operArg = new ExecuteActionArg(this.messageTempletInfo, this.messageTempletInfo);
        ReqCmd reqCmd = new ReqCmd(null, null, true, null, operArg);
        try {
            reply = sessionHandler.synSend(reqCmd);
        }
        catch (NetconfException e) {
            logger.error("send lct control action exception.", (Throwable)e);
            throw e;
        }
        RspCmd rspCmd = (RspCmd)reply;
        if (rspCmd.getType() != 1) {
            sendResult = false;
            RpcErrorInfo error = rspCmd.getErrorInfo().get(0);
            logger.error("errorTag is " + error.getErrAppTag() + ",errorMessage is " + error.getErrMsg());
            throw new NetconfException(1107495895, error.getErrMsg());
        }
        sendResult = true;
        return sendResult;
    }
}

