/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.session;

import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.session.ISession;
import com.huawei.vmf.netconf.session.ISessionCheckHandle;
import com.huawei.vmf.netconf.session.ISessionListener;
import com.huawei.vmf.netconf.session.PooledSession;
import com.huawei.vmf.netconf.session.SessionPool;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceSessionBucket
implements ISessionListener {
    private static Logger logger = LoggerFactory.getLogger(DeviceSessionBucket.class);
    private static AtomicInteger serialSeed = new AtomicInteger(0);
    private final String ip;
    private final int maxSessionLimit;
    private AtomicInteger sessionNum = new AtomicInteger();

    public DeviceSessionBucket(String ip, int maxSessionLimit) {
        this.ip = ip;
        this.maxSessionLimit = maxSessionLimit;
    }

    public boolean close(ISession session) {
        if (null == session) {
            logger.debug("close null session.");
            return false;
        }
        if (session.close()) {
            this.sessionNum.getAndDecrement();
            return true;
        }
        return false;
    }

    public void closeAll() {
    }

    @Override
    public void disconnect(ISession session) {
        SessionPool.onSessonClosed(session);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceSessionBucket other = (DeviceSessionBucket)obj;
        return !(this.ip == null ? other.ip != null : !this.ip.equals(other.ip));
    }

    public ISession getSession(String creator, CommunicateArg arg, boolean shared, List<ISessionCheckHandle> sessionCheckServiceList) throws NetconfException {
        return this.tryCreateSession(creator, arg, sessionCheckServiceList);
    }

    public int getSessionNum() {
        return this.sessionNum.get();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int testConnective(CommunicateArg arg, List<ISessionCheckHandle> sessionCheckServiceList) {
        ISession session = null;
        try {
            session = this.tryCreateSession(Thread.currentThread().getName(), arg, sessionCheckServiceList);
            int n = 0;
            return n;
        }
        catch (NetconfException e) {
            logger.warn("test connect exception. ip=" + arg.getIp(), (Throwable)e);
            int n = e.getErrorCode();
            return n;
        }
        finally {
            if (null == session) {
                logger.debug("close null session.");
            } else {
                this.close(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISession tryCreateSession(String holder, CommunicateArg arg, List<ISessionCheckHandle> sessionCheckServiceList) throws NetconfException {
        DeviceSessionBucket deviceSessionBucket = this;
        synchronized (deviceSessionBucket) {
            if (this.sessionNum.get() >= this.maxSessionLimit) {
                throw new NetconfException(1107495869, "device netconf session reach max limit, arg=" + arg);
            }
            this.sessionNum.getAndIncrement();
        }
        logger.info("create new connect ip={}", (Object)arg.getIp());
        boolean success = false;
        PooledSession session = null;
        try {
            session = new PooledSession(arg, serialSeed.getAndIncrement(), sessionCheckServiceList);
            session.setInUsed(holder);
            session.addListener(this);
            session.createTransport();
            success = true;
            PooledSession pooledSession = session;
            return pooledSession;
        }
        catch (NetconfException e) {
            logger.error("create netconf sessiont error. arg=" + arg, (Throwable)e);
            throw e;
        }
        finally {
            if (!success) {
                this.sessionNum.getAndDecrement();
                if (null != session) {
                    session.close();
                }
            }
        }
    }
}

