/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.session;

import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.datadefination.RspCmd;
import com.huawei.vmf.netconf.error.BadMessageFormatException;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.error.TransportIOException;
import com.huawei.vmf.netconf.service.IAsyncRpcHandler;
import com.huawei.vmf.netconf.service.IRpc;
import com.huawei.vmf.netconf.service.IRpcReply;
import com.huawei.vmf.netconf.service.Netconf;
import com.huawei.vmf.netconf.session.ClientHello;
import com.huawei.vmf.netconf.session.ISession;
import com.huawei.vmf.netconf.session.ISessionCheckHandle;
import com.huawei.vmf.netconf.session.MessageUnit;
import com.huawei.vmf.netconf.session.NetconfAbility;
import com.huawei.vmf.netconf.session.ServerHello;
import com.huawei.vmf.netconf.transport.ITransport;
import com.huawei.vmf.netconf.transport.ITransportListener;
import com.huawei.vmf.netconf.util.VTDNavAdapter;
import com.trilead.ssh2.channel.ISessionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSession
implements ISession,
ITransportListener,
ISessionHandler {
    public static final int HELLO_MESSAGE_ID = 0;
    protected static final String SESSION_BEGIN_TAG = "<session-id>";
    protected static final int STATE_CLOSED = 3;
    protected static final int STATE_CONNECTED = 1;
    protected static final int STATE_INITIAL = 0;
    protected static final int STATE_PEER_CLOSED = 2;
    private static Logger logger = LoggerFactory.getLogger(DefaultSession.class);
    private final CommunicateArg arg;
    private final long createTime = System.currentTimeMillis();
    private ServerHello deviceHello;
    private final int id;
    private AtomicInteger messageID;
    private List<ISessionCheckHandle> sessionCheckServiceList;
    private ITransport transport;
    private Map<Integer, MessageUnit> waitingForReply;

    protected DefaultSession(CommunicateArg arg, int serial, List<ISessionCheckHandle> sessionCheckServiceList) throws NetconfException {
        this.arg = arg;
        this.messageID = new AtomicInteger(0);
        this.sessionCheckServiceList = sessionCheckServiceList;
        this.waitingForReply = Collections.synchronizedMap(new HashMap());
        this.id = serial;
    }

    @Override
    public void aSynSend(IRpc reqCmd, IAsyncRpcHandler netconfHandle) throws NetconfException {
        if (reqCmd == null) {
            throw new NetconfException(-1, "can't send null rpc request.");
        }
        MessageUnit unit = this.allocateMessageUnit(reqCmd, netconfHandle);
        this.sync(Arrays.asList(unit));
    }

    @Override
    public boolean close() {
        if (null != this.transport) {
            return this.transport.close();
        }
        return false;
    }

    @Override
    public void createTransport() throws NetconfException {
        if (this.transport != null && this.transport.isConnected()) {
            logger.info("transport has been connected.");
            return;
        }
        this.transport = Netconf.createTransportInstance(this.arg);
        this.transport.registryListener(this);
        this.transport.connect(this.arg, this);
        this.hello();
        this.sessionCheck();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultSession other = (DefaultSession)obj;
        return this.id == other.id;
    }

    public String getCharsetName() {
        return "UTF-8";
    }

    @Override
    public CommunicateArg getCommunicationArg() {
        return this.arg;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String getIp() {
        if (this.arg == null || this.arg.getIp() == null) {
            return "";
        }
        return this.arg.getIp();
    }

    public String getPacketEndTag() {
        return "]]>]]>";
    }

    @Override
    public int getSessionID() {
        int sessionID = -1;
        if (this.deviceHello != null) {
            sessionID = this.deviceHello.getSessionID();
        }
        return sessionID;
    }

    public void handleError(String error) {
        logger.info("receive rpc-reply error:[session={}, rpc-reply={}]", new Object[]{this.toString(), error});
        this.handleTransportClosed(this.transport, null);
    }

    public void handlePacket(String response) {
        logger.info("receive rpc-reply:[session={}, rpc-reply={}]", new Object[]{this.toString(), response});
        if (response == null) {
            return;
        }
        try {
            XMLStreamReader reader = VTDNavAdapter.createStAXFactory(response);
            this.handleDeviceResponse(reader);
        }
        catch (Exception e) {
            logger.error("bad format of response. session=" + this.toString(), (Throwable)e);
        }
    }

    @Override
    public void handleTransportClosed(ITransport transport, NetconfException error) {
        logger.debug("connection[{}] closed by peer, notify listeners.", (Object)this.toString(), (Object)error);
        this.clearWaitingRpc(error);
    }

    @Override
    public boolean hasCapability(int deviceCapability) {
        NetconfAbility ability = this.deviceHello.getAbility();
        int deviceAbilitys = ability.getDeviceAbilityVolumn();
        return (deviceAbilitys & deviceCapability) != 0;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    @Override
    public boolean isConnected() {
        if (this.transport != null) {
            return this.transport.isConnected();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IRpcReply> pSynSend(Collection<IRpc> reqCmd) throws NetconfException {
        if (reqCmd == null) {
            throw new NetconfException(-1, "can't send null rpc request.");
        }
        ArrayList<MessageUnit> units = new ArrayList<MessageUnit>(reqCmd.size());
        for (IRpc rpc : reqCmd) {
            MessageUnit unit = this.allocateMessageUnit(rpc, null);
            units.add(unit);
        }
        this.sync(units);
        ArrayList<IRpcReply> replys = new ArrayList<IRpcReply>(reqCmd.size());
        try {
            for (MessageUnit unit : units) {
                unit.waitForReply();
                if (unit.isError()) {
                    throw unit.getError();
                }
                if (unit.getResp() == null) continue;
                replys.add(unit.getResp());
            }
        }
        finally {
            for (MessageUnit unit : units) {
                this.waitingForReply.remove(unit.getMessageID());
            }
        }
        return replys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRpcReply synSend(IRpc reqCmd) throws NetconfException {
        if (reqCmd == null) {
            throw new NetconfException(-1, "can't send null rpc request.");
        }
        MessageUnit unit = this.allocateMessageUnit(reqCmd, null);
        try {
            this.sync(Arrays.asList(unit));
            unit.waitForReply();
        }
        finally {
            this.waitingForReply.remove(unit.getMessageID());
        }
        return unit.getResp();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DefaultSession [ip=");
        builder.append(this.arg.getIp());
        builder.append(", id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }

    MessageUnit getUnitByMessageID(Integer messageID) {
        if (messageID == null) {
            return null;
        }
        return this.waitingForReply.get(messageID);
    }

    MessageUnit handleDeviceResponse(XMLStreamReader reader) throws BadMessageFormatException, XMLStreamException {
        MessageUnit unit = null;
        while (reader.hasNext()) {
            int event = reader.next();
            if (event != 1) continue;
            IRpcReply reply = null;
            if ("hello".equals(reader.getLocalName())) {
                this.deviceHello = new ServerHello(reader);
                reply = this.deviceHello;
            } else if ("rpc-reply".equals(reader.getLocalName()) || "active".equals(reader.getLocalName())) {
                reply = new RspCmd(reader);
            } else {
                logger.info("didn't know reply tag:{}", (Object)reader.getLocalName());
            }
            if (null == reply) break;
            Integer messageID = reply.getMessageID();
            unit = this.waitingForReply.get(messageID);
            if (null != unit) {
                logger.info("received message-id={}", (Object)reply.getMessageID());
                unit.setResp(reply);
                if (unit.isActive()) break;
                this.waitingForReply.remove(messageID);
                break;
            }
            logger.info("drop message-id={}", (Object)reply.getMessageID());
            break;
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(String request, String logRequest) throws NetconfException {
        long start = System.currentTimeMillis();
        try {
            logger.info("send rpc begin:[session={}, body={}]", new Object[]{this.toString(), logRequest});
            this.getTransport().send(request);
        }
        catch (Throwable throwable) {
            long elapse = System.currentTimeMillis() - start;
            logger.info("send rpc end:[session={}, elapse={}]", new Object[]{this.toString(), elapse});
            throw throwable;
        }
        long elapse = System.currentTimeMillis() - start;
        logger.info("send rpc end:[session={}, elapse={}]", new Object[]{this.toString(), elapse});
    }

    void sync(Collection<MessageUnit> units) throws NetconfException {
        int i;
        String[] messages = new String[units.size()];
        String[] logMessages = new String[units.size()];
        Iterator<MessageUnit> iter = units.iterator();
        for (i = 0; i < messages.length; ++i) {
            MessageUnit unit = iter.next();
            messages[i] = unit.serialize();
            logMessages[i] = unit.logSerialize();
            this.waitingForReply.put(unit.getMessageID(), unit);
        }
        for (i = 0; i < messages.length; ++i) {
            this.send(messages[i], logMessages[i]);
        }
    }

    private MessageUnit allocateMessageUnit(IRpc reqCmd, IAsyncRpcHandler handler) {
        if (reqCmd == null) {
            return null;
        }
        reqCmd.setTimeout(this.arg.getResponseTimeout());
        int msgID = this.messageID.getAndIncrement();
        MessageUnit unit = new MessageUnit(this, reqCmd, msgID);
        if (handler != null) {
            unit.setHandler(handler);
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearWaitingRpc(NetconfException error) {
        Map<Integer, MessageUnit> map = this.waitingForReply;
        synchronized (map) {
            Iterator<MessageUnit> iter = this.waitingForReply.values().iterator();
            while (iter.hasNext()) {
                iter.next().setError(error);
                iter.remove();
            }
        }
    }

    private ITransport getTransport() {
        return this.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hello() throws NetconfException {
        if (!this.transport.isConnected()) {
            throw new TransportIOException("device connection haven't establish yet:" + this.arg, null);
        }
        ClientHello helloRpc = new ClientHello(this.arg.getResponseTimeout());
        MessageUnit unit = this.allocateMessageUnit(helloRpc, null);
        try {
            this.sync(Arrays.asList(unit));
            unit.waitForReply();
        }
        catch (NetconfException e) {
            logger.error("send hello exception.", (Throwable)e);
        }
        finally {
            this.waitingForReply.remove(unit.getMessageID());
        }
    }

    private void sessionCheck() throws NetconfException {
        if (this.sessionCheckServiceList == null || this.sessionCheckServiceList.size() == 0) {
            logger.info("sessionCheck : sessionCheckServiceList is null");
            return;
        }
        boolean checkResult = false;
        for (ISessionCheckHandle sessionCheckHandle : this.sessionCheckServiceList) {
            checkResult = sessionCheckHandle.checkSession(this);
            if (checkResult) continue;
            logger.info("sessionCheck : checkSession failed");
            break;
        }
    }
}

