/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.session;

import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.IAsyncRpcHandler;
import com.huawei.vmf.netconf.session.MessageUnit;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncRpcScheduler {
    private static final Logger logger = LoggerFactory.getLogger(AsyncRpcScheduler.class);
    private static ExecutorService srv = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            ThreadFactory factory = Executors.defaultThreadFactory();
            Thread thread = factory.newThread(r);
            thread.setName("NETCONF-ASYN-THREAD-POOL" + thread.getName());
            return thread;
        }
    });

    public static void schedule(MessageUnit unit) {
        Worker worker = new Worker(unit);
        srv.execute(worker);
    }

    private static class Worker
    implements Runnable {
        private MessageUnit unit;

        public Worker(MessageUnit unit) {
            this.unit = unit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IAsyncRpcHandler handler = this.unit.getHandler();
            if (handler == null) {
                logger.info("message[id={}]'s asyn handle is null.", (Object)this.unit.getMessageID());
                return;
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
                if (this.unit.isError()) {
                    handler.exception(this.unit.getError());
                } else if (this.unit.isFinished()) {
                    handler.handle(this.unit.getReq(), this.unit.getResp());
                } else {
                    handler.exception(new NetconfException(1107495893, ""));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }
}

