/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.service;

public enum TargetType {
    RDB(1),
    CDB(2),
    STARTUP(3),
    URL(4),
    CHECKPOINT(5);

    private int type;

    private TargetType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public String targetCommand(String content, String tag) {
        StringBuilder buf = new StringBuilder();
        buf.append('<');
        buf.append(tag);
        buf.append('>');
        if (this == RDB) {
            buf.append("<running/>");
        } else if (this == CDB) {
            buf.append("<candidate/>");
        } else if (this == STARTUP) {
            buf.append("<startup/>");
        } else if (this == URL) {
            buf.append("<url>");
            buf.append(content);
            buf.append("</url>");
        } else if (this == CHECKPOINT) {
            buf.append("<checkpoint>");
            buf.append(content);
            buf.append("</checkpoint>");
        }
        buf.append('<');
        buf.append('/');
        buf.append(tag);
        buf.append('>');
        return buf.toString();
    }
}

