/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.service;

import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.service.CommunicationArgumentMgr;
import com.huawei.vmf.netconf.service.DefaultNetconfClient;
import com.huawei.vmf.netconf.service.DevTypePnPClient;
import com.huawei.vmf.netconf.service.INetconfClient;
import com.huawei.vmf.netconf.session.ISessionCheckHandle;
import com.huawei.vmf.netconf.session.SessionPool;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfClientFactory {
    private static Logger logger = LoggerFactory.getLogger(NetconfClientFactory.class);

    public static void close(INetconfClient client) {
        logger.debug("close netconf client:{}", (Object)client);
        if (client == null) {
            return;
        }
        ((DefaultNetconfClient)client).close();
    }

    public static void directCloseSession(INetconfClient client) {
        if (client == null) {
            return;
        }
        logger.debug("directCloseSession netconf client:{}", (Object)client);
        ((DefaultNetconfClient)client).directCloseSession();
    }

    public static INetconfClient getDevTypePnPClient(String creator, String ip, boolean shared, CommunicateArg commArg, List<ISessionCheckHandle> sessionCheckServiceList) {
        if (creator == null || "".equals(creator)) {
            throw new IllegalArgumentException("creator can't be null or empty string.");
        }
        DevTypePnPClient client = new DevTypePnPClient(ip, Thread.currentThread().getName(), creator, shared, commArg, sessionCheckServiceList);
        return client;
    }

    public static INetconfClient getNetconfClient(int devID, String creator, String ip, boolean shared, List<ISessionCheckHandle> sessionCheckServiceList) {
        if (creator == null || "".equals(creator)) {
            throw new IllegalArgumentException("creator can't be null or empty string.");
        }
        DefaultNetconfClient client = new DefaultNetconfClient(devID, ip, Thread.currentThread().getName(), creator, shared, sessionCheckServiceList);
        return client;
    }

    public static INetconfClient getNetconfClient(String creator, String ip, boolean shared, List<ISessionCheckHandle> sessionCheckServiceList) {
        if (creator == null || "".equals(creator)) {
            throw new IllegalArgumentException("creator can't be null or empty string.");
        }
        DefaultNetconfClient client = new DefaultNetconfClient(ip, Thread.currentThread().getName(), creator, shared, sessionCheckServiceList);
        return client;
    }

    public static int testConnective(String ip, List<ISessionCheckHandle> sessionCheckServiceList) {
        CommunicateArg arg = CommunicationArgumentMgr.getCommunicateArg(ip);
        if (arg == null) {
            return 1107495868;
        }
        return SessionPool.testConnective(arg, 0L, sessionCheckServiceList);
    }
}

