/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.service;

import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.transport.ITransport;
import com.huawei.vmf.netconf.transport.SSH;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Netconf {
    private static final String APP_NAME = System.getProperty("appName");
    private static final String APP_PATH = System.getenv().get("IMAP_ROOT") + File.separator + "nemgr" + File.separator + APP_NAME;
    private static final int BASE = 1000;
    private static int cachePolicyLastAccessCounter = 30;
    private static final String DEFAULT_FILE_PATH = APP_PATH + File.separator + "conf" + File.separator + "netconf" + File.separator + "netconf.properties";
    private static int defaultLoginTimeout = 30;
    private static int defaultResponseTimeout = 60;
    private static String defaultTransportType = SSH.class.getName();
    private static int enableSessionPool = 0;
    private static Logger logger = LoggerFactory.getLogger(Netconf.class);
    private static int maxConnectionPerDevice = 2;
    private static int maxHoldConnections = 200;
    private static int maxIdelTimeout = 1200;
    private static int maxThreadIdleTimeout = 60000;
    private static int minConnectionPerDevice = 1;

    public static ITransport createTransportInstance(CommunicateArg arg) {
        try {
            String protocol = arg.getProtocol();
            if (null == protocol) {
                protocol = defaultTransportType;
            }
            Class<?> clazz = Class.forName(protocol);
            return (ITransport)clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal Transport Type:" + defaultTransportType, e);
        }
    }

    public static int getCachePolicyLastAccessCounter() {
        return cachePolicyLastAccessCounter;
    }

    public static int getDefaultLoginTimeout() {
        return defaultLoginTimeout;
    }

    public static int getDefaultResponseTimeout() {
        return defaultResponseTimeout;
    }

    public static String getDefaultTransportType() {
        return defaultTransportType;
    }

    public static int getMaxConnectionPerDevice() {
        return maxConnectionPerDevice;
    }

    public static int getMaxHoldConnections() {
        return maxHoldConnections;
    }

    public static int getMaxIdelTimeout() {
        return maxIdelTimeout;
    }

    public static int getMaxThreadIdleTimeout() {
        return maxThreadIdleTimeout;
    }

    public static int getMinConnectionPerDevice() {
        return minConnectionPerDevice;
    }

    public static boolean isEnableSessionPool() {
        return enableSessionPool != 0;
    }

    private static int getIntProperty(Properties properties, String property, int defaultValue) {
        int ret = defaultValue;
        if (properties != null && (property = properties.getProperty(property)) != null) {
            try {
                ret = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                logger.error("getIntProperty error.", (Throwable)e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() throws IOException {
        File file = new File(DEFAULT_FILE_PATH);
        Properties properties = new Properties();
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            properties.load(stream);
        }
        catch (Exception e) {
            logger.debug("config file[{}] doesn't exsit.", (Object)DEFAULT_FILE_PATH);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e2) {
                    logger.info("close stream failed!");
                }
            }
        }
        maxConnectionPerDevice = Netconf.getIntProperty(properties, "MAX_CONNECTION_PER_DEVICE", maxConnectionPerDevice);
        minConnectionPerDevice = Netconf.getIntProperty(properties, "MIN_CONNECTION_PER_DEVICE", minConnectionPerDevice);
        enableSessionPool = Netconf.getIntProperty(properties, "ENABLE_SESSION_POOL", enableSessionPool);
        maxHoldConnections = Netconf.getIntProperty(properties, "MAX_HOLD_CONNECTION", maxHoldConnections);
        maxIdelTimeout = Netconf.getIntProperty(properties, "MAX_IDLE_TIMEOUT", maxIdelTimeout) * 1000;
        defaultResponseTimeout = Netconf.getIntProperty(properties, "RPC_TIMEOUT", defaultResponseTimeout) * 1000;
        defaultLoginTimeout = Netconf.getIntProperty(properties, "GET_SESSION_TIMEOUT", defaultLoginTimeout) * 1000;
        defaultTransportType = properties.getProperty("DEFAULT_TRANSPORT_PROTOCOL", defaultTransportType);
        if (!defaultTransportType.startsWith(SSH.class.getPackage().getName())) {
            defaultTransportType = defaultTransportType + SSH.class.getPackage().getName() + "." + defaultTransportType;
        }
        cachePolicyLastAccessCounter = Netconf.getIntProperty(properties, "CACHE_POLICY_LAST_ACCESS_COUNT", cachePolicyLastAccessCounter);
    }

    static {
        try {
            Netconf.init();
        }
        catch (Exception e) {
            logger.error("can't init netconf.", (Throwable)e);
        }
    }

    public static enum SESSION_PRIORITY {
        HIGH,
        LOW;

    }
}

