/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.service;

import com.huawei.vmf.extendpoint.framework.ISessionFactory;
import com.huawei.vmf.extendpoint.register.FrameExtendPointServiceMgr;
import com.huawei.vmf.netconf.datadefination.CommitArg;
import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.datadefination.CopyConfigArg;
import com.huawei.vmf.netconf.datadefination.DiscardChangesArg;
import com.huawei.vmf.netconf.datadefination.DiscardCommitArg;
import com.huawei.vmf.netconf.datadefination.EditConfigArg;
import com.huawei.vmf.netconf.datadefination.ExecuteActionArg;
import com.huawei.vmf.netconf.datadefination.ExecuteCliArg;
import com.huawei.vmf.netconf.datadefination.FTPType;
import com.huawei.vmf.netconf.datadefination.GetArg;
import com.huawei.vmf.netconf.datadefination.GetConfigArg;
import com.huawei.vmf.netconf.datadefination.GetNextArg;
import com.huawei.vmf.netconf.datadefination.HWContext;
import com.huawei.vmf.netconf.datadefination.LockArg;
import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.datadefination.ReqCmd;
import com.huawei.vmf.netconf.datadefination.RollbackConfigArg;
import com.huawei.vmf.netconf.datadefination.RpcArg;
import com.huawei.vmf.netconf.datadefination.RspCmd;
import com.huawei.vmf.netconf.datadefination.SaveCheckPointArg;
import com.huawei.vmf.netconf.datadefination.SyncFullArg;
import com.huawei.vmf.netconf.datadefination.SyncFullArgBySFTP;
import com.huawei.vmf.netconf.datadefination.SyncIncrementArg;
import com.huawei.vmf.netconf.datadefination.UnLockArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.AbstractNetconfClient;
import com.huawei.vmf.netconf.service.CommunicationArgumentMgr;
import com.huawei.vmf.netconf.service.ErrorOperationType;
import com.huawei.vmf.netconf.service.FilterType;
import com.huawei.vmf.netconf.service.IAsyncRpcHandler;
import com.huawei.vmf.netconf.service.INetconfClient;
import com.huawei.vmf.netconf.service.IRpc;
import com.huawei.vmf.netconf.service.IRpcReply;
import com.huawei.vmf.netconf.service.OperationType;
import com.huawei.vmf.netconf.service.TargetType;
import com.huawei.vmf.netconf.service.TestOperationType;
import com.huawei.vmf.netconf.session.ISession;
import com.huawei.vmf.netconf.session.ISessionCheckHandle;
import com.huawei.vmf.netconf.session.SessionPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultNetconfClient
extends AbstractNetconfClient {
    public static final int STATE_ASYNC = 3;
    public static final int STATE_BATCH = 1;
    public static final int STATE_SYNC = 2;
    private static final Logger logger = LoggerFactory.getLogger(DefaultNetconfClient.class);
    protected List<IRpc> batchRequests;
    protected int devID;
    protected IAsyncRpcHandler handler;
    protected Deque<INetconfClient.INetconfClientEventListener> listeners = new LinkedList<INetconfClient.INetconfClientEventListener>();
    protected Set<TargetType> lockTarget;
    protected Integer lrID;
    protected ISession session;
    protected int state = 2;
    protected long timeout;
    protected int vrID;

    public DefaultNetconfClient(int devID, String ip, String threadName, String creator, boolean shared, List<ISessionCheckHandle> sessionCheckServiceList) {
        super(ip, threadName, creator, shared, sessionCheckServiceList);
        this.devID = devID;
    }

    public DefaultNetconfClient(String ip, String threadName, String creator, boolean shared, List<ISessionCheckHandle> sessionCheckServiceList) {
        super(ip, threadName, creator, shared, sessionCheckServiceList);
    }

    @Override
    public void beginBatch() {
        this.state = 1;
    }

    @Override
    public IRpcReply commit(long timeout, boolean confirmed, String description) throws NetconfException {
        if (this.shared) {
            throw new NetconfException(-1, "share state client not support commit.");
        }
        CommitArg commitArg = null;
        commitArg = timeout == 0L ? new CommitArg() : new CommitArg(timeout, confirmed);
        ISession session = this.getSession();
        if (session.hasCapability(262144)) {
            commitArg.setDescription(description);
        }
        return this.send(false, null, commitArg);
    }

    @Override
    public IRpcReply commit(String description) throws NetconfException {
        return this.commit(0L, false, description);
    }

    @Override
    public IRpcReply copyConfig(TargetType sourceCfgType, TargetType targetCfgType) throws NetconfException {
        if (null == sourceCfgType || null == targetCfgType) {
            throw new IllegalArgumentException("copyConfig not allow null TargetType.");
        }
        CopyConfigArg operaArg = new CopyConfigArg(sourceCfgType, targetCfgType);
        return this.send(false, null, operaArg);
    }

    @Override
    public IRpcReply discardChanges() throws NetconfException {
        if (this.shared) {
            throw new NetconfException(-1, "share state client not support discardChanges.");
        }
        DiscardChangesArg operaArg = new DiscardChangesArg();
        return this.send(false, null, operaArg);
    }

    @Override
    public IRpcReply discardCommit() throws NetconfException {
        if (this.shared) {
            throw new NetconfException(-1, "share state client not support discardCommit.");
        }
        DiscardCommitArg operaArg = new DiscardCommitArg();
        return this.send(false, null, operaArg);
    }

    @Override
    public IRpcReply editConfig(TargetType target, OperationType defaultOperation, ErrorOperationType errorOperation, TestOperationType testOperation, String content, String logContent) throws NetconfException {
        if (target == null) {
            throw new IllegalArgumentException("editConfig not allow null TargetType.");
        }
        if (content == null) {
            throw new IllegalArgumentException("editConfig not allow null content.");
        }
        if (this.shared && target == TargetType.CDB) {
            throw new NetconfException(-1, "can't edit cdb through share client.");
        }
        if (defaultOperation == null) {
            defaultOperation = OperationType.NONE;
        }
        if (errorOperation == null) {
            errorOperation = ErrorOperationType.NONE;
        }
        if (testOperation == null) {
            testOperation = TestOperationType.NONE;
        }
        EditConfigArg arg = new EditConfigArg(target, defaultOperation, errorOperation, testOperation);
        arg.setContent(content);
        arg.setLogContent(logContent);
        return this.send(false, null, arg);
    }

    @Override
    public IRpcReply editConfig(TargetType target, String content, String logContent) throws NetconfException {
        return this.editConfig(target, OperationType.MERGE, ErrorOperationType.ROLLBACK_ON_ERROR, TestOperationType.TEST_THEN_SET, content, logContent);
    }

    @Override
    public IRpcReply execute(IRpc req) throws NetconfException {
        return this.send(req);
    }

    @Override
    public IRpcReply executeAction(String action, String logAction) throws NetconfException {
        if (action == null || "".equals(action)) {
            throw new IllegalArgumentException("execute action not allow null action request.");
        }
        ExecuteActionArg arg = new ExecuteActionArg(action, logAction);
        return this.send(false, null, arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IRpcReply> executeBatch() throws NetconfException {
        Collection<IRpcReply> collection;
        try {
            Collection<IRpcReply> replys;
            collection = replys = this.session.pSynSend(this.batchRequests);
            if (this.batchRequests != null) {
                this.batchRequests.clear();
            }
            this.state = this.handler == null ? 2 : 3;
        }
        catch (Throwable throwable) {
            if (this.batchRequests != null) {
                this.batchRequests.clear();
            }
            this.state = this.handler == null ? 2 : 3;
            throw throwable;
        }
        return collection;
    }

    @Override
    public IRpcReply executeCli(String cli) throws NetconfException {
        if (cli == null || "".equals(cli)) {
            throw new IllegalArgumentException("execute cli not allow null cli request.");
        }
        ExecuteCliArg arg = new ExecuteCliArg(cli);
        return this.send(false, null, arg);
    }

    @Override
    public IRpcReply get(FilterType type, String filter, String logFilter, boolean autoNext) throws NetconfException {
        if (type == null) {
            throw new IllegalArgumentException("get rpc command not allow null FilterType.");
        }
        GetArg arg = new GetArg(type);
        arg.setContent(filter);
        arg.setLogContent(logFilter);
        IRpcReply reply = this.send(autoNext, null, arg);
        if (autoNext) {
            this.autoGetNext(reply);
        }
        return reply;
    }

    @Override
    public IRpcReply getConfig(TargetType target, FilterType type, String filter, String logFilter, boolean autoNext) throws NetconfException {
        if (type == null) {
            throw new IllegalArgumentException("get-config rpc command not allow null FilterType.");
        }
        if (target == null) {
            throw new IllegalArgumentException("get-config rpc command not allow null TargetType.");
        }
        if (this.shared && target == TargetType.CDB) {
            throw new NetconfException(-1, "can't edit cdb through share client.");
        }
        GetConfigArg arg = new GetConfigArg(type, target);
        arg.setContent(filter);
        arg.setLogContent(logFilter);
        IRpcReply reply = this.send(autoNext, null, arg);
        if (autoNext) {
            this.autoGetNext(reply);
        }
        return reply;
    }

    public IAsyncRpcHandler getHandler() {
        return this.handler;
    }

    public Integer getLrID() {
        return this.lrID;
    }

    @Override
    public IRpcReply getNext(int setId, boolean discard) throws NetconfException {
        if (setId < 0) {
            throw new NetconfException(-1, "get-next set-id must be greater than 0.");
        }
        GetNextArg arg = new GetNextArg(discard, setId);
        return this.send(false, null, arg);
    }

    public int getState() {
        return this.state;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    public int getVrID() {
        return this.vrID;
    }

    @Override
    public IRpcReply lock(TargetType type) throws NetconfException {
        if (type == null) {
            throw new IllegalArgumentException("lock not allow null TargetType");
        }
        if (type == TargetType.CDB && this.shared) {
            throw new NetconfException(-1, "can't lock cdb through share client.");
        }
        if (this.lockTarget != null && this.lockTarget.contains((Object)type)) {
            logger.info("configuration database={} has been locked.", (Object)type);
            RspCmd reply = new RspCmd();
            return reply;
        }
        LockArg arg = new LockArg(type);
        IRpcReply reply = this.send(false, null, arg);
        if (reply.isOK()) {
            if (this.lockTarget == null) {
                this.lockTarget = new LinkedHashSet<TargetType>();
            }
            this.lockTarget.add(type);
        }
        return reply;
    }

    @Override
    public void registryListener(INetconfClient.INetconfClientEventListener listener) {
        this.listeners.offerLast(listener);
    }

    @Override
    public IRpcReply rollback() throws NetconfException {
        DiscardChangesArg arg = new DiscardChangesArg();
        return this.send(false, null, arg);
    }

    @Override
    public IRpcReply rollback(String checkpoint) throws NetconfException {
        if (checkpoint == null || "".equals(checkpoint)) {
            throw new IllegalArgumentException("rollback not allow null checkpoint.");
        }
        RollbackConfigArg arg = new RollbackConfigArg(checkpoint);
        return this.send(false, null, arg);
    }

    @Override
    public IRpcReply saveCheckPoint(String checkpoint, String description) throws NetconfException {
        if (checkpoint == null || "".equals(checkpoint)) {
            throw new IllegalArgumentException("saveCheckPoint not allow null checkpoint.");
        }
        SaveCheckPointArg arg = new SaveCheckPointArg(checkpoint, description);
        return this.send(false, null, arg);
    }

    public void setHandler(IAsyncRpcHandler handler) {
        this.handler = handler;
    }

    @Override
    public void setIp(String ip) {
        if (ip == null) {
            return;
        }
        this.ip = ip;
    }

    public void setLrID(Integer lrID) {
        this.lrID = lrID;
    }

    @Override
    public void setSession(ISession session) {
        this.session = session;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    @Override
    public IRpcReply syncFull(FilterType type, String filter, String filePrefix, String user, String password, String ftpIp, int port, String path) throws NetconfException {
        if (type == null) {
            throw new IllegalArgumentException("sync-full rpc command not allow null FilterType.");
        }
        SyncFullArg arg = new SyncFullArg(type, filePrefix, user, password, ftpIp, port, path);
        arg.setContent(filter);
        return this.send(false, null, arg);
    }

    @Override
    public IRpcReply syncFull(FilterType type, String filter, String filePrefix, String user, String password, String ftpIp, int port, String path, FTPType ftpType) throws NetconfException {
        if (type == null) {
            throw new IllegalArgumentException("sync-full rpc command not allow null FilterType.");
        }
        if (ftpType == null || ftpType == FTPType.FTP) {
            return this.syncFull(type, filter, filePrefix, user, password, ftpIp, port, path);
        }
        SyncFullArgBySFTP arg = new SyncFullArgBySFTP(type, filePrefix, user, password, ftpIp, port, path);
        arg.setContent(filter);
        return this.send(false, null, arg);
    }

    @Override
    public IRpcReply syncIncrement(FilterType type, String filter, long sourceFlowID, long targetFlowID) throws NetconfException {
        if (type == null) {
            throw new IllegalArgumentException("sync-increment rpc command not allow null FilterType.");
        }
        SyncIncrementArg arg = new SyncIncrementArg(type, sourceFlowID, targetFlowID);
        arg.setContent(filter);
        IRpcReply reply = this.send(true, null, arg);
        if (reply.hasNext()) {
            this.autoGetNext(reply);
        }
        return reply;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DefaultNetconfClient [ip=");
        builder.append(this.ip);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public IRpcReply unlock(TargetType type) throws NetconfException {
        if (type == null) {
            throw new IllegalArgumentException("unlock not allow null TargetType");
        }
        if (type == TargetType.CDB && this.shared) {
            throw new NetconfException(-1, "can't unlock cdb through share client.");
        }
        UnLockArg arg = new UnLockArg(type);
        IRpcReply reply = this.send(false, null, arg);
        if (reply.isOK()) {
            this.lockTarget.remove((Object)type);
            if (this.lockTarget.isEmpty()) {
                this.lockTarget = null;
            }
        }
        return reply;
    }

    protected void autoGetNext(IRpcReply reply) throws NetconfException {
        IRpcReply nextReply = reply;
        while (nextReply.isOK() && nextReply.hasNext()) {
            nextReply = this.getNext(nextReply.getSetID(), false);
            reply.addPackage(nextReply);
        }
    }

    protected void cleanUpLock() {
        if (this.lockTarget == null) {
            return;
        }
        logger.info("client doesn't unlock before close, try to fix it.");
        try {
            for (TargetType target : this.lockTarget) {
                IRpcReply reply = this.unlock(target);
                if (!reply.isOK()) {
                    logger.error("can't unlock:{}", reply.getErrorInfos());
                    continue;
                }
                logger.info("unlock success.");
            }
        }
        catch (NetconfException e) {
            logger.info("try to clean up before close exception.", (Throwable)e);
        }
    }

    protected void closeBefore() {
        this.cleanUpLock();
    }

    protected IRpcReply send(boolean enableNext, List<RpcArg> rpcArgList, OperationArg operArg) throws NetconfException {
        if (this.lrID != null || this.vrID != 0) {
            if (rpcArgList == null) {
                rpcArgList = new ArrayList<RpcArg>();
            }
            rpcArgList.add(new HWContext(this.lrID, this.vrID));
        }
        ReqCmd cmd = new ReqCmd(rpcArgList, operArg, enableNext);
        cmd.setTimeout(this.timeout);
        return this.send(cmd);
    }

    protected IRpcReply send(IRpc reqCmd) throws NetconfException {
        ISession session = this.getSession();
        if (3 == this.state) {
            session.aSynSend(reqCmd, this.handler);
        } else if (1 == this.state) {
            if (this.batchRequests == null) {
                this.batchRequests = new ArrayList<IRpc>();
            }
            this.batchRequests.add(reqCmd);
        } else if (2 == this.state) {
            return session.synSend(reqCmd);
        }
        return null;
    }

    void close() {
        if (this.session == null) {
            logger.info("close netconf client, session has been cleaned.");
            return;
        }
        this.closeBefore();
        logger.info("release netconf session created by ({})", (Object)this.threadName);
        SessionPool.releaseSession(this.session);
        this.setSession(null);
    }

    void directCloseSession() {
        if (this.session == null) {
            return;
        }
        this.closeBefore();
        logger.info("directCloseSession session created by ({})", (Object)this.threadName);
        SessionPool.directCloseSession(this.session);
        this.setSession(null);
    }

    ISession getSession() throws NetconfException {
        if (this.session == null) {
            ISessionFactory sessionFactory = (ISessionFactory)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(ISessionFactory.class);
            if (sessionFactory != null) {
                this.session = (ISession)sessionFactory.GetSession(Integer.valueOf(this.devID), this.ip, Boolean.valueOf(this.shared));
            } else {
                CommunicateArg arg = CommunicationArgumentMgr.getCommunicateArg(this.ip);
                if (arg == null) {
                    throw new NetconfException(-1, "communication argument doesn't exist of device=" + this.ip);
                }
                this.session = SessionPool.getSession(this.threadName, arg, this.shared, this.sessionCheckServiceList);
            }
        }
        return this.session;
    }

    void setState(int state) {
        this.state = state;
    }
}

