/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.service;

import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.error.NetconfException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommunicationArgumentMgr {
    public static final int MODE_BASIC = 0;
    public static final int MODE_IPV4 = 3;
    public static final int MODE_IPV6_4 = 2;
    public static final int MODE_PREFIX = 1;
    private static final Map<String, CommunicateArg> devCommunicateArgs = Collections.synchronizedMap(new HashMap());
    private static final String IPV4_INVALIDATE_SEPARATOR = "..";
    private static final String IPV4_SEPARATOR = ".";
    private static final int IPV4_UNIT_MAX_LENGTH = 3;
    private static final int IPV4_UNIT_MAX_VALUE = 255;
    private static final int IPV4_UNIT_NUM = 4;
    private static final String IPV6_IPV4_TYPE_DEFAULT_POSTFIX = "0:0";
    private static final int IPV6_MAX_LENGTH = 128;
    private static final int IPV6_MAX_UNIT_NUM = 8;
    private static final int IPV6_MIN_UNIT_NUM = 6;
    private static final String IPV6_OMIT_INVALIDATE_SEPARATOR = ":::";
    private static final String IPV6_OMIT_SEPARATOR = "::";
    private static final String IPV6_SEPARATOR = ":";
    private static final int IPV6_UNIT_MAX_LENGTH = 4;
    private static final String MASK_INVALIDATE_SEPARATOR = "//";
    private static final int MASK_MAX_LENGTH = 3;
    private static final String MASK_SEPARATOR = "/";

    public static void addCommunicateArg(CommunicateArg arg) throws NetconfException {
        if (arg == null || null == arg.getIp()) {
            throw new NetconfException(-1, "getSession failed ,because of parameter error");
        }
        if (!CommunicationArgumentMgr.checkIpAddress(arg.getIp())) {
            throw new NetconfException(1107495882, "can't session by illegal ip:" + arg.getIp());
        }
        devCommunicateArgs.put(arg.getIp(), arg);
    }

    public static boolean checkIpAddress(String s) {
        if (CommunicationArgumentMgr.checkBasicIP(s, true)) {
            return true;
        }
        if (CommunicationArgumentMgr.checkPrefixIP(s, true)) {
            return true;
        }
        if (CommunicationArgumentMgr.checkIPv6IPv4(s, true)) {
            return true;
        }
        return CommunicationArgumentMgr.checkIPv4(s, true);
    }

    public static void delCommunicateArg(String ip) {
        devCommunicateArgs.remove(ip);
    }

    public static CommunicateArg[] getAllCommunicateArg() {
        Collection<CommunicateArg> args = devCommunicateArgs.values();
        return args.toArray(new CommunicateArg[args.size()]);
    }

    public static CommunicateArg getCommunicateArg(String ip) {
        return devCommunicateArgs.get(ip);
    }

    private static boolean checkBasicIP(String s, boolean allowBlank) {
        if (!CommunicationArgumentMgr.checkIpChar(s, 0)) {
            return false;
        }
        StringTokenizer stringtokenizer = new StringTokenizer(s, IPV6_SEPARATOR);
        int unitNum = stringtokenizer.countTokens();
        boolean hasOmitSeparator = s.contains(IPV6_OMIT_SEPARATOR);
        if (!hasOmitSeparator && unitNum != 8 || hasOmitSeparator && unitNum > 6) {
            return false;
        }
        while (stringtokenizer.hasMoreTokens()) {
            String unitStr = stringtokenizer.nextToken();
            String trimUnitStr = unitStr.trim();
            int trimUnitStrLength = trimUnitStr.length();
            if (CommunicationArgumentMgr.hasBlankIn(unitStr) || trimUnitStrLength > 4) {
                return false;
            }
            if (unitStr.length() != 0 && (allowBlank || trimUnitStrLength != 0)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIpChar(String s, int ipType) {
        if (null == s) {
            return false;
        }
        if (s.contains(MASK_INVALIDATE_SEPARATOR) || s.contains(IPV4_INVALIDATE_SEPARATOR) || s.contains(IPV6_OMIT_INVALIDATE_SEPARATOR) || s.replaceFirst(IPV6_OMIT_SEPARATOR, "").contains(IPV6_OMIT_SEPARATOR) || s.replaceFirst(MASK_SEPARATOR, "").contains(MASK_SEPARATOR) || ipType != 0 && s.endsWith(IPV6_OMIT_SEPARATOR)) {
            return false;
        }
        String ipCharRe = null;
        ipCharRe = ipType == 0 ? "[0-9a-f: ]*" : (ipType == 1 ? "[0-9a-f:/ ]*" : (ipType == 2 ? "[0-9a-f:/. ]*" : "[0-9. ]*"));
        Pattern pattern = Pattern.compile(ipCharRe);
        Matcher matcher = pattern.matcher(s.toLowerCase(Locale.getDefault()));
        return matcher.matches();
    }

    private static boolean checkIPv4(String s, boolean allowBlank) {
        if (null == s || s.contains(IPV4_INVALIDATE_SEPARATOR)) {
            return false;
        }
        StringTokenizer stringtokenizer = new StringTokenizer(s, IPV4_SEPARATOR);
        if (stringtokenizer.countTokens() != 4) {
            return false;
        }
        try {
            while (!stringtokenizer.hasMoreTokens()) {
                String unitStr = stringtokenizer.nextToken();
                int trimUnitStrLength = unitStr.trim().length();
                if (CommunicationArgumentMgr.hasBlankIn(unitStr) || trimUnitStrLength > 3) {
                    return false;
                }
                if (unitStr.length() == 0 || !allowBlank && trimUnitStrLength == 0) {
                    return false;
                }
                if (allowBlank && trimUnitStrLength == 0 || Integer.parseInt(unitStr.trim()) <= 255) continue;
                return false;
            }
        }
        catch (NumberFormatException numberformatexception) {
            return false;
        }
        return true;
    }

    private static boolean checkIPv6IPv4(String s, boolean allowBlank) {
        if (s == null || !s.contains(IPV6_SEPARATOR)) {
            return false;
        }
        String ipv6Address = s.substring(0, s.lastIndexOf(IPV6_SEPARATOR) + 1);
        String ipv4Address = s.substring(s.lastIndexOf(IPV6_SEPARATOR) + 1);
        return CommunicationArgumentMgr.checkBasicIP(ipv6Address = ipv6Address + IPV6_IPV4_TYPE_DEFAULT_POSTFIX, allowBlank) && CommunicationArgumentMgr.checkIPv4(ipv4Address, allowBlank);
    }

    private static boolean checkPrefixIP(String s, boolean allowBlank) {
        if (null == s || !s.contains(MASK_SEPARATOR)) {
            return false;
        }
        String ipAddressPrefix = s.substring(0, s.indexOf(MASK_SEPARATOR));
        if (!CommunicationArgumentMgr.checkBasicIP(ipAddressPrefix, allowBlank)) {
            return false;
        }
        String mask = s.substring(s.indexOf(MASK_SEPARATOR) + 1);
        int maskLenth = mask.length();
        int trimMaskLength = mask.trim().length();
        if (allowBlank && trimMaskLength == 0 && maskLenth != 0) {
            return true;
        }
        if (CommunicationArgumentMgr.hasBlankIn(mask) || trimMaskLength > 3) {
            return false;
        }
        if (maskLenth == 0 || !allowBlank && trimMaskLength == 0) {
            return false;
        }
        if (allowBlank && trimMaskLength == 0) {
            return true;
        }
        try {
            if (Integer.parseInt(mask.trim()) > 128) {
                return false;
            }
        }
        catch (NumberFormatException numberformatexception) {
            return false;
        }
        return true;
    }

    private static boolean hasBlankIn(String s) {
        return s.trim().length() != s.trim().replaceAll(" ", "").length();
    }
}

