/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.service;

import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.error.NetconfException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationArgFactory {
    private static final Logger log = LoggerFactory.getLogger(CommunicationArgFactory.class);

    public static CommunicateArg getCommucateArg(int authMode, String devIp, String privateKey, String pwdPhrase, String username, String password, int port, int loginTimeout, int rspTimeout) {
        CommunicateArg communicateArg = null;
        switch (authMode) {
            case 1: {
                communicateArg = new CommunicateArg(devIp, username, password, port);
                break;
            }
            case 2: {
                communicateArg = new CommunicateArg(devIp, privateKey, pwdPhrase, port, username);
                break;
            }
            case 3: {
                try {
                    communicateArg = new CommunicateArg(devIp, privateKey, pwdPhrase, username, password, port);
                    break;
                }
                catch (NetconfException e) {
                    log.error("build CommunicateArg failed.", (Throwable)e);
                    return null;
                }
            }
            default: {
                log.error("CommunicationArgFactory:getCommucateArg unkown authmode : " + authMode);
            }
        }
        communicateArg.setLoginTimeout(loginTimeout);
        communicateArg.setResponseTimeout(rspTimeout);
        return communicateArg;
    }
}

