/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.netconfif;

import com.huawei.vmf.extendpoint.framework.ISessionFactory;
import com.huawei.vmf.extendpoint.register.FrameExtendPointServiceMgr;
import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.netconfif.Session;
import com.huawei.vmf.netconf.netconfif.SessionImpl;
import com.huawei.vmf.netconf.service.CommunicationArgumentMgr;
import com.huawei.vmf.netconf.session.ISession;
import com.huawei.vmf.netconf.session.ISessionCheckHandle;
import com.huawei.vmf.netconf.session.SessionPool;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionMgr {
    private static final SessionMgr sessionMgr = new SessionMgr();
    private Logger log = LoggerFactory.getLogger((String)SessionMgr.class.getName());

    private SessionMgr() {
    }

    public static SessionMgr newInstance() {
        return sessionMgr;
    }

    public int addDevSessionPool(CommunicateArg communicateArg, int sessionNum, boolean bVerity) {
        int ret = 0;
        try {
            CommunicationArgumentMgr.addCommunicateArg(communicateArg);
        }
        catch (NetconfException e) {
            this.log.error("add device session pool exception.", (Throwable)e);
            ret = e.getErrorCode();
        }
        return ret;
    }

    public int addDevSessionPool(CommunicateArg communicateArg, int sessionNum, boolean bVerity, int logInTimeout, int sessionTimeout) {
        return this.addDevSessionPool(communicateArg, sessionNum, bVerity);
    }

    public int deleteDevSessionPool(String devIp) {
        SessionPool.onDevDelete(devIp);
        CommunicationArgumentMgr.delCommunicateArg(devIp);
        return 0;
    }

    public Session getSession(String devIp, int timeout, List<ISessionCheckHandle> sessionCheckServiceList) throws NetconfException {
        SessionImpl ret = null;
        ISessionFactory sessionFactory = (ISessionFactory)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(ISessionFactory.class);
        if (sessionFactory != null) {
            ret = new SessionImpl((ISession)sessionFactory.GetSession(Integer.valueOf(-1), devIp, Boolean.valueOf(false)));
        } else {
            try {
                ISession session = SessionPool.getSession(Thread.currentThread().getName(), CommunicationArgumentMgr.getCommunicateArg(devIp), false, sessionCheckServiceList);
                ret = new SessionImpl(session);
            }
            catch (NetconfException e) {
                this.log.error("get netconf session exception.", (Throwable)e);
                throw e;
            }
        }
        return ret;
    }

    public boolean isSessionConnected(Session session) {
        ISession realSession = ((SessionImpl)session).getSession();
        if (realSession != null) {
            return realSession.isConnected();
        }
        return false;
    }

    public int releaseSession(Session session) {
        if (session == null) {
            this.log.debug("release null session.");
            return 0;
        }
        ISession realSession = ((SessionImpl)session).getSession();
        if (realSession != null) {
            SessionPool.releaseSession(realSession);
            ((SessionImpl)session).setSession(null);
        }
        return 0;
    }

    public int testDevCommunicateArg(CommunicateArg communicateArg, List<ISessionCheckHandle> sessionCheckServiceList) {
        return SessionPool.testConnective(communicateArg, communicateArg.getResponseTimeout(), sessionCheckServiceList);
    }
}

