/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.netconf.netconfif;

import com.huawei.vmf.netconf.datadefination.ReqCmd;
import com.huawei.vmf.netconf.datadefination.RspCmd;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.netconfif.Session;
import com.huawei.vmf.netconf.service.IRpcReply;
import com.huawei.vmf.netconf.session.ISession;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionImpl
implements Session {
    private static final Logger logger = LoggerFactory.getLogger(SessionImpl.class);
    private ISession session;

    public SessionImpl(ISession session) {
        this.session = session;
    }

    @Override
    public int synSend(ReqCmd reqCmd, List<RspCmd> rspCmdList, int timeout) {
        int ret = 0;
        try {
            reqCmd.setTimeout(timeout);
            IRpcReply reply = this.session.synSend(reqCmd);
            rspCmdList.add((RspCmd)reply);
        }
        catch (NetconfException e) {
            logger.error("sync request exception.", (Throwable)e);
            ret = e.getErrorCode();
        }
        return ret;
    }

    @Override
    public int synSend(ReqCmd reqCmd, List<RspCmd> rspCmdList) {
        return this.synSend(reqCmd, rspCmdList, 0);
    }

    @Override
    public int getSessionID() {
        return 0;
    }

    void setSession(ISession session) {
        this.session = session;
    }

    ISession getSession() {
        return this.session;
    }

    @Override
    public String getIp() {
        return this.session.getCommunicationArg().getIp();
    }
}

